/*
 * Decompiled with CFR 0.152.
 */
package com.python.pydev.debug.model;

import com.python.pydev.debug.DebugPluginPrefsInitializer;
import com.python.pydev.debug.model.ProcessServerOutputStream;
import com.python.pydev.debug.remote.RemoteDebuggerServer;
import com.rc.retroweaver.runtime.Autobox;
import java.io.InputStream;
import java.io.OutputStream;
import org.python.pydev.core.MyPipedInputStream;
import org.python.pydev.core.docutils.StringUtils;
import org.python.pydev.core.log.Log;

public class ProcessServer
extends Process {
    private MyPipedInputStream inputStream;
    private MyPipedInputStream errorStream;
    private OutputStream outputStream;
    private Object lock;

    public ProcessServer() {
        try {
            this.inputStream = new MyPipedInputStream();
            this.inputStream.write(StringUtils.format((String)"Debug Server at port: %s\r\n", (Object[])new Object[]{Autobox.valueOf((int)DebugPluginPrefsInitializer.getRemoteDebuggerPort())}).getBytes());
            this.errorStream = new MyPipedInputStream();
            this.outputStream = new ProcessServerOutputStream();
            this.lock = new Object();
        }
        catch (Exception e) {
            Log.log((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public InputStream getErrorStream() {
        return this.errorStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int waitFor() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            this.lock.wait();
        }
        return 0;
    }

    public int exitValue() {
        throw new IllegalThreadStateException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        Object object = this.lock;
        synchronized (object) {
            this.lock.notify();
        }
        RemoteDebuggerServer.getInstance().dispose();
        try {
            if (this.outputStream != null) {
                this.outputStream.close();
                this.outputStream = null;
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        try {
            if (this.inputStream != null) {
                this.inputStream.close();
                this.inputStream = null;
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
        try {
            if (this.errorStream != null) {
                this.errorStream.close();
                this.errorStream = null;
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }

    public void writeToStdOut(String str) {
        try {
            MyPipedInputStream p = this.inputStream;
            if (p != null) {
                p.write(str.getBytes());
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }

    public void writeToStdErr(String str) {
        try {
            MyPipedInputStream p = this.errorStream;
            if (p != null) {
                p.write(str.getBytes());
            }
        }
        catch (Exception e) {
            Log.log((Throwable)e);
        }
    }
}

