/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.plotserver;

import gda.observable.IObserver;
import gda.observable.ObservableComponent;
import java.io.File;
import java.io.Serializable;
import java.util.HashMap;
import uk.ac.diamond.scisoft.analysis.PlotServer;
import uk.ac.diamond.scisoft.analysis.plotserver.DataBean;
import uk.ac.diamond.scisoft.analysis.plotserver.FileOperationBean;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiBean;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiParameters;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiPlotMode;
import uk.ac.diamond.scisoft.analysis.plotserver.GuiUpdate;

public class SimplePlotServer
implements PlotServer {
    private ObservableComponent observableComponent = new ObservableComponent();
    private HashMap<String, GuiBean> guiStore = new HashMap();
    private HashMap<String, DataBean> dataStore = new HashMap();
    private String basePath = System.getProperty("gda.data");

    public void setBasePath(String string) {
        this.basePath = string;
    }

    protected String getDefaultDataDir() {
        return String.valueOf(this.basePath) + File.separator;
    }

    @Override
    public GuiBean getGuiState(String string) throws Exception {
        return this.guiStore.get(string);
    }

    @Override
    public DataBean getData(String string) throws Exception {
        return this.dataStore.get(string);
    }

    @Override
    public void setData(String string, DataBean dataBean) throws Exception {
        this.dataStore.put(string, dataBean);
        this.notifyIObservers(this, string);
    }

    @Override
    public void updateGui(String string, GuiBean guiBean) throws Exception {
        this.guiStore.put(string, guiBean);
        this.respondToGui(string, guiBean);
        GuiUpdate guiUpdate = new GuiUpdate(string, guiBean);
        this.notifyIObservers(this, guiUpdate);
    }

    @Override
    public void updateData(String string) throws Exception {
        this.notifyIObservers(this, string);
    }

    private void respondToGui(String string, GuiBean guiBean) throws Exception {
        FileOperationBean fileOperationBean = null;
        fileOperationBean = (FileOperationBean)guiBean.get(GuiParameters.FILEOPERATION);
        if (fileOperationBean != null) {
            switch (fileOperationBean.getMode()) {
                case 1: {
                    break;
                }
                case 2: {
                    if (!guiBean.containsKey(GuiParameters.DISPLAYFILEONVIEW)) break;
                    String string2 = (String)guiBean.get(GuiParameters.DISPLAYFILEONVIEW);
                    DataBean dataBean = fileOperationBean.loadImage(false);
                    if (dataBean == null) break;
                    GuiBean guiBean2 = this.getGuiState(string);
                    if (!guiBean2.containsKey(GuiParameters.PLOTMODE) || !((Serializable)guiBean2.get(GuiParameters.PLOTMODE)).equals(GuiPlotMode.TWOD)) {
                        guiBean2 = new GuiBean();
                        guiBean2.put(GuiParameters.PLOTMODE, GuiPlotMode.TWOD);
                    }
                    this.updateGui(string2, guiBean2);
                    this.setData(string2, dataBean);
                    break;
                }
                case 3: {
                    DataBean dataBean = fileOperationBean.loadImage(true);
                    if (dataBean == null) break;
                    this.setData(string, dataBean);
                    break;
                }
                case 4: 
                case 5: 
                case 6: {
                    guiBean.put(GuiParameters.FILEOPERATION, fileOperationBean.chDir(this.basePath));
                    break;
                }
                case 7: {
                    fileOperationBean.deleteDir(String.valueOf(this.getDefaultDataDir()) + "GRIDVIEWDATA/");
                    break;
                }
            }
        }
    }

    public void addIObserver(IObserver iObserver) {
        this.observableComponent.addIObserver(iObserver);
    }

    public void deleteIObserver(IObserver iObserver) {
        this.observableComponent.deleteIObserver(iObserver);
    }

    public void deleteIObservers() {
        this.observableComponent.deleteIObservers();
    }

    public void notifyIObservers(Object object, Object object2) {
        this.observableComponent.notifyIObservers(object, object2);
    }
}

