/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.analysis.io.ScanFileHolderException;
import gda.util.TestUtils;
import junit.framework.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;
import uk.ac.diamond.scisoft.analysis.io.TIFFImageLoader;

public class TiffLoaderTest {
    static String testfile1 = null;
    static String testfile2 = null;
    static String testfile3 = null;
    static String TestFileFolder;

    @BeforeClass
    public static void setUpBeforeClass() {
    }

    @BeforeClass
    public static void setUpClass() {
        TestFileFolder = TestUtils.getGDALargeTestFilesLocation();
        if (TestFileFolder == null) {
            Assert.fail((String)"TestUtils.getGDALargeTestFilesLocation() returned null - test aborted");
        }
        TestFileFolder = String.valueOf(TestFileFolder) + "PilatusTiffLoaderTest/";
        testfile1 = String.valueOf(TestFileFolder) + "fcell_H_8GPa_20keV_18000s_0173.tif";
        testfile2 = String.valueOf(TestFileFolder) + "ipp16.TIF";
        testfile3 = String.valueOf(TestFileFolder) + "crl-bestfocus1.tif";
    }

    @Test
    public void testLoadFile() throws ScanFileHolderException {
        new TIFFImageLoader(testfile1).loadFile();
    }

    @Test
    public void testLoaderFactory() throws Exception {
        DataHolder dataHolder = LoaderFactory.getData(testfile1, null);
        if (dataHolder == null || dataHolder.getNames().length < 1) {
            throw new Exception();
        }
    }

    @Test
    public void testLoadFile12Bit() {
        try {
            new TIFFImageLoader(testfile2).loadFile();
        }
        catch (ScanFileHolderException scanFileHolderException) {
            System.out.println("Caught SFHE as expected - 12bit tiffs are not supported");
        }
    }

    @Test
    public void testLoadFile16Bit() throws ScanFileHolderException {
        new TIFFImageLoader(testfile3).loadFile();
    }
}

