/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.analysis.io.ScanFileHolderException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.LongBuffer;
import java.nio.MappedByteBuffer;
import java.nio.ShortBuffer;
import java.nio.channels.FileChannel;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.BooleanDataset;
import uk.ac.diamond.scisoft.analysis.dataset.BooleanDatasetBase;
import uk.ac.diamond.scisoft.analysis.dataset.ByteDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ComplexDoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ComplexFloatDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundByteDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundDoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundFloatDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundIntegerDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundLongDataset;
import uk.ac.diamond.scisoft.analysis.dataset.CompoundShortDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.FloatDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerDataset;
import uk.ac.diamond.scisoft.analysis.dataset.LongDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ShortDataset;
import uk.ac.diamond.scisoft.analysis.io.AbstractFileLoader;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.RawBinarySaver;

public class RawBinaryLoader
extends AbstractFileLoader {
    private String fileName;

    public RawBinaryLoader() {
    }

    public RawBinaryLoader(String string) {
        this.fileName = string;
    }

    public void setFile(String string) {
        this.fileName = string;
    }

    @Override
    public DataHolder loadFile() throws ScanFileHolderException {
        DataHolder dataHolder = new DataHolder();
        File file = null;
        FileInputStream fileInputStream = null;
        try {
            try {
                Object object;
                int n;
                file = new File(this.fileName);
                fileInputStream = new FileInputStream(file);
                FileChannel fileChannel = fileInputStream.getChannel();
                MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size());
                mappedByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                if (RawBinarySaver.getFormatTag() != mappedByteBuffer.getInt()) {
                    throw new ScanFileHolderException("File does not start with a Diamond format tag " + String.format("%x", mappedByteBuffer.getInt()));
                }
                int n2 = mappedByteBuffer.get();
                int n3 = mappedByteBuffer.get();
                if (n3 < 0) {
                    n3 += 256;
                }
                if ((n = mappedByteBuffer.get()) < 0) {
                    n += 256;
                }
                int n4 = n3;
                int[] nArray = new int[n];
                int n5 = 0;
                while (n5 < n) {
                    nArray[n5] = mappedByteBuffer.getInt();
                    n4 *= nArray[n5];
                    ++n5;
                }
                n5 = mappedByteBuffer.getShort();
                if (n5 < 0) {
                    n5 += 65536;
                }
                byte[] byArray = new byte[n5];
                if (n5 > 0) {
                    mappedByteBuffer.get(byArray);
                }
                while (mappedByteBuffer.position() % 4 != 0) {
                    mappedByteBuffer.get();
                }
                if (n3 != 1) {
                    switch (n2) {
                        case 1: {
                            n2 = 100;
                            break;
                        }
                        case 2: {
                            n2 = 200;
                            break;
                        }
                        case 3: {
                            n2 = 300;
                            break;
                        }
                        case 4: {
                            n2 = 400;
                            break;
                        }
                        case 5: {
                            n2 = 500;
                            break;
                        }
                        case 6: {
                            n2 = 600;
                        }
                    }
                }
                AbstractDataset abstractDataset = null;
                switch (n2) {
                    case 0: {
                        object = new BooleanDataset(nArray);
                        if (mappedByteBuffer.limit() != n4) {
                            throw new ScanFileHolderException("Data size, " + mappedByteBuffer.limit() + ", does not match expected, " + n4);
                        }
                        boolean[] blArray = ((BooleanDatasetBase)object).getData();
                        int n6 = 0;
                        while (n6 < n4) {
                            blArray[n6] = mappedByteBuffer.get() != 0;
                            ++n6;
                        }
                        abstractDataset = object;
                        break;
                    }
                    case 1: {
                        ByteDataset byteDataset = new ByteDataset(nArray);
                        if (mappedByteBuffer.limit() != n4) {
                            throw new ScanFileHolderException("Data size, " + mappedByteBuffer.limit() + ", does not match expected, " + n4);
                        }
                        byte[] byArray2 = byteDataset.getData();
                        int n7 = 0;
                        while (n7 < n4) {
                            byArray2[n7] = mappedByteBuffer.get();
                            ++n7;
                        }
                        abstractDataset = byteDataset;
                        break;
                    }
                    case 2: {
                        ShortDataset shortDataset = new ShortDataset(nArray);
                        ShortBuffer shortBuffer = mappedByteBuffer.asShortBuffer();
                        if (shortBuffer.limit() != n4) {
                            throw new ScanFileHolderException("Data size, " + shortBuffer.limit() + ", does not match expected, " + n4);
                        }
                        short[] sArray = shortDataset.getData();
                        int n8 = 0;
                        while (n8 < n4) {
                            sArray[n8] = shortBuffer.get();
                            ++n8;
                        }
                        abstractDataset = shortDataset;
                        break;
                    }
                    case 3: {
                        IntegerDataset integerDataset = new IntegerDataset(nArray);
                        IntBuffer intBuffer = mappedByteBuffer.asIntBuffer();
                        if (intBuffer.limit() != n4) {
                            throw new ScanFileHolderException("Data size, " + intBuffer.limit() + ", does not match expected, " + n4);
                        }
                        int[] nArray2 = integerDataset.getData();
                        int n9 = 0;
                        while (n9 < n4) {
                            nArray2[n9] = intBuffer.get();
                            ++n9;
                        }
                        abstractDataset = integerDataset;
                        break;
                    }
                    case 4: {
                        LongDataset longDataset = new LongDataset(nArray);
                        LongBuffer longBuffer = mappedByteBuffer.asLongBuffer();
                        if (longBuffer.limit() != n4) {
                            throw new ScanFileHolderException("Data size, " + longBuffer.limit() + ", does not match expected, " + n4);
                        }
                        long[] lArray = longDataset.getData();
                        int n10 = 0;
                        while (n10 < n4) {
                            lArray[n10] = longBuffer.get();
                            ++n10;
                        }
                        abstractDataset = longDataset;
                        break;
                    }
                    case 100: {
                        CompoundByteDataset compoundByteDataset = new CompoundByteDataset(n3, nArray);
                        if (mappedByteBuffer.limit() != n4) {
                            throw new ScanFileHolderException("Data size, " + mappedByteBuffer.limit() + ", does not match expected, " + n4);
                        }
                        byte[] byArray3 = compoundByteDataset.getData();
                        int n11 = 0;
                        while (n11 < n4) {
                            byArray3[n11] = mappedByteBuffer.get();
                            ++n11;
                        }
                        abstractDataset = compoundByteDataset;
                        break;
                    }
                    case 200: {
                        CompoundShortDataset compoundShortDataset = new CompoundShortDataset(n3, nArray);
                        ShortBuffer shortBuffer = mappedByteBuffer.asShortBuffer();
                        if (shortBuffer.limit() != n4) {
                            throw new ScanFileHolderException("Data size, " + shortBuffer.limit() + ", does not match expected, " + n4);
                        }
                        short[] sArray = compoundShortDataset.getData();
                        int n12 = 0;
                        while (n12 < n4) {
                            sArray[n12] = shortBuffer.get();
                            ++n12;
                        }
                        abstractDataset = compoundShortDataset;
                        break;
                    }
                    case 300: {
                        CompoundIntegerDataset compoundIntegerDataset = new CompoundIntegerDataset(n3, nArray);
                        IntBuffer intBuffer = mappedByteBuffer.asIntBuffer();
                        if (intBuffer.limit() != n4) {
                            throw new ScanFileHolderException("Data size, " + intBuffer.limit() + ", does not match expected, " + n4);
                        }
                        int[] nArray3 = compoundIntegerDataset.getData();
                        int n13 = 0;
                        while (n13 < n4) {
                            nArray3[n13] = intBuffer.get();
                            ++n13;
                        }
                        abstractDataset = compoundIntegerDataset;
                        break;
                    }
                    case 400: {
                        CompoundLongDataset compoundLongDataset = new CompoundLongDataset(n3, nArray);
                        LongBuffer longBuffer = mappedByteBuffer.asLongBuffer();
                        if (longBuffer.limit() != n4) {
                            throw new ScanFileHolderException("Data size, " + longBuffer.limit() + ", does not match expected, " + n4);
                        }
                        long[] lArray = compoundLongDataset.getData();
                        int n14 = 0;
                        while (n14 < n4) {
                            lArray[n14] = longBuffer.get();
                            ++n14;
                        }
                        abstractDataset = compoundLongDataset;
                        break;
                    }
                    case 5: {
                        FloatBuffer floatBuffer = mappedByteBuffer.asFloatBuffer();
                        FloatDataset floatDataset = new FloatDataset(nArray);
                        if (floatBuffer.limit() != n4) {
                            throw new ScanFileHolderException("Data size, " + floatBuffer.limit() + ", does not match expected, " + n4);
                        }
                        float[] fArray = floatDataset.getData();
                        int n15 = 0;
                        while (n15 < n4) {
                            fArray[n15] = floatBuffer.get();
                            ++n15;
                        }
                        abstractDataset = floatDataset;
                        break;
                    }
                    case 500: {
                        CompoundFloatDataset compoundFloatDataset = new CompoundFloatDataset(n3, nArray);
                        FloatBuffer floatBuffer = mappedByteBuffer.asFloatBuffer();
                        if (floatBuffer.limit() != n4) {
                            throw new ScanFileHolderException("Data size, " + floatBuffer.limit() + ", does not match expected, " + n4);
                        }
                        float[] fArray = compoundFloatDataset.getData();
                        int n16 = 0;
                        while (n16 < n4) {
                            fArray[n16] = floatBuffer.get();
                            ++n16;
                        }
                        abstractDataset = compoundFloatDataset;
                        break;
                    }
                    case 7: {
                        ComplexFloatDataset complexFloatDataset = new ComplexFloatDataset(nArray);
                        FloatBuffer floatBuffer = mappedByteBuffer.asFloatBuffer();
                        if (floatBuffer.limit() != n4) {
                            throw new ScanFileHolderException("Data size, " + floatBuffer.limit() + ", does not match expected, " + n4);
                        }
                        float[] fArray = complexFloatDataset.getData();
                        int n17 = 0;
                        while (n17 < n4) {
                            fArray[n17] = floatBuffer.get();
                            ++n17;
                        }
                        abstractDataset = complexFloatDataset;
                        break;
                    }
                    case -1: 
                    case 6: {
                        DoubleDataset doubleDataset = new DoubleDataset(nArray);
                        DoubleBuffer doubleBuffer = mappedByteBuffer.asDoubleBuffer();
                        if (doubleBuffer.limit() != n4) {
                            throw new ScanFileHolderException("Data size, " + doubleBuffer.limit() + ", does not match expected, " + n4);
                        }
                        double[] dArray = doubleDataset.getData();
                        int n18 = 0;
                        while (n18 < n4) {
                            dArray[n18] = doubleBuffer.get();
                            ++n18;
                        }
                        abstractDataset = doubleDataset;
                        break;
                    }
                    case 600: {
                        CompoundDoubleDataset compoundDoubleDataset = new CompoundDoubleDataset(n3, nArray);
                        DoubleBuffer doubleBuffer = mappedByteBuffer.asDoubleBuffer();
                        if (doubleBuffer.limit() != n4) {
                            throw new ScanFileHolderException("Data size, " + doubleBuffer.limit() + ", does not match expected, " + n4);
                        }
                        double[] dArray = compoundDoubleDataset.getData();
                        int n19 = 0;
                        while (n19 < n4) {
                            dArray[n19] = doubleBuffer.get();
                            ++n19;
                        }
                        abstractDataset = compoundDoubleDataset;
                        break;
                    }
                    case 8: {
                        ComplexDoubleDataset complexDoubleDataset = new ComplexDoubleDataset(nArray);
                        DoubleBuffer doubleBuffer = mappedByteBuffer.asDoubleBuffer();
                        if (doubleBuffer.limit() != n4) {
                            throw new ScanFileHolderException("Data size, " + doubleBuffer.limit() + ", does not match expected, " + n4);
                        }
                        double[] dArray = complexDoubleDataset.getData();
                        int n20 = 0;
                        while (n20 < n4) {
                            dArray[n20] = doubleBuffer.get();
                            ++n20;
                        }
                        abstractDataset = complexDoubleDataset;
                        break;
                    }
                    default: {
                        throw new ScanFileHolderException("Dataset type not supported");
                    }
                }
                fileChannel.close();
                if (n5 > 0) {
                    object = new String(byArray, "UTF-8");
                    abstractDataset.setName((String)object);
                    dataHolder.addDataset((String)object, abstractDataset);
                } else {
                    dataHolder.addDataset("RAW file", abstractDataset);
                }
                abstractDataset.setDirty();
            }
            catch (Exception exception) {
                if (exception instanceof ScanFileHolderException) {
                    throw (ScanFileHolderException)exception;
                }
                throw new ScanFileHolderException("There was a problem reading the Raw file", exception);
            }
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return dataHolder;
    }
}

