/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import com.sun.media.imageio.plugins.tiff.TIFFDirectory;
import com.sun.media.imageio.plugins.tiff.TIFFField;
import gda.analysis.io.ScanFileHolderException;
import java.io.BufferedReader;
import java.io.File;
import java.io.StringReader;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.FileImageInputStream;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.JavaImageLoader;

public class PilatusTiffLoader
extends JavaImageLoader {
    private Map<String, String> metadataTable = new HashMap<String, String>();

    public PilatusTiffLoader() {
        super(null, "tiff");
    }

    public PilatusTiffLoader(String string) {
        super(string, "tiff");
        this.fileName = string;
    }

    @Override
    public DataHolder loadFile() throws ScanFileHolderException {
        DataHolder dataHolder = null;
        dataHolder = super.loadFile();
        File file = new File(this.fileName);
        String string = "";
        String[] stringArray = new String[]{"Pixel_size", "Silicon sensor, thickness", "Exposure_time", "Exposure_period", "Tau =", "Threshold_setting", "N_excluded_pixels", "Excluded_pixels:", "Trim_directory:", "Flat_field:"};
        try {
            ImageReader imageReader = ImageIO.getImageReadersByFormatName("tiff").next();
            FileImageInputStream fileImageInputStream = new FileImageInputStream(file);
            imageReader.setInput(fileImageInputStream);
            IIOMetadata iIOMetadata = imageReader.getImageMetadata(0);
            TIFFDirectory tIFFDirectory = TIFFDirectory.createFromMetadata((IIOMetadata)iIOMetadata);
            TIFFField[] tIFFFieldArray = tIFFDirectory.getTIFFFields();
            int n = 0;
            boolean bl = false;
            int n2 = 0;
            while (n2 < tIFFFieldArray.length) {
                TIFFField tIFFField = tIFFFieldArray[n2];
                if (tIFFField.getTag().getName().equalsIgnoreCase("ImageDescription")) {
                    BufferedReader bufferedReader = new BufferedReader(new StringReader(tIFFField.getValueAsString(0)));
                    while ((string = bufferedReader.readLine()) != null) {
                        bl = false;
                        int n3 = 0;
                        while (n3 < stringArray.length) {
                            if (string.contains(stringArray[n3])) {
                                this.metadataTable.put(stringArray[n3], string.substring(string.indexOf(stringArray[n3]) + stringArray[n3].length(), string.length()).trim());
                                bl = true;
                                break;
                            }
                            ++n3;
                        }
                        if (bl) continue;
                        this.metadataTable.put("Unknown " + n, string);
                        ++n;
                    }
                } else {
                    this.metadataTable.put(tIFFField.getTag().getName(), tIFFField.getValueAsString(0));
                }
                ++n2;
            }
        }
        catch (Exception exception) {
            throw new ScanFileHolderException("There was a problem loading the tiff header", exception);
        }
        dataHolder.addMetadata(this.metadataTable);
        return dataHolder;
    }
}

