/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.util.TestUtils;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerDataset;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;
import uk.ac.diamond.scisoft.analysis.io.PilatusEdfLoader;

public class PilatusEdfLoaderTest {
    static String testScratchDirectoryName = null;
    static final String testFileFolder = "testfiles/gda/analysis/io/EdfLoaderTest/";

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        testScratchDirectoryName = TestUtils.generateDirectorynameFromClassname((String)PilatusEdfLoader.class.getCanonicalName());
        TestUtils.makeScratchDirectory((String)testScratchDirectoryName);
    }

    @Test
    public void testBoundsOnIntegerDataSet() throws Exception {
        DataHolder dataHolder = LoaderFactory.getData("testfiles/gda/analysis/io/EdfLoaderTest/diff6105.edf", null);
        IntegerDataset integerDataset = (IntegerDataset)dataHolder.getDataset("ESRF Pilatus Data");
        int n = integerDataset.min().intValue();
        int n2 = integerDataset.max().intValue();
        int[] nArray = integerDataset.getData();
        int n3 = Integer.MAX_VALUE;
        int n4 = Integer.MIN_VALUE;
        int n5 = 0;
        while (n5 < nArray.length) {
            n3 = Math.min(n3, nArray[n5]);
            n4 = Math.max(n4, nArray[n5]);
            ++n5;
        }
        if (n != n3) {
            throw new Exception("Maths incorrect in IntegerDataset incorrect minimum calculated!");
        }
        if (n2 != n4) {
            throw new Exception("Maths incorrect in IntegerDataset incorrect maximum calculated!");
        }
    }

    @Test
    public void testUseLoaderFactory() throws Exception {
        DataHolder dataHolder = LoaderFactory.getData("testfiles/gda/analysis/io/EdfLoaderTest/diff6105.edf", null);
        AbstractDataset abstractDataset = dataHolder.getDataset("ESRF Pilatus Data");
        Assert.assertEquals((double)abstractDataset.getDouble(0, 0), (double)5898338.0, (double)0.0);
        Assert.assertEquals((double)abstractDataset.getDouble(2047, 2047), (double)0.0, (double)0.0);
    }

    @Test
    public void testUseMetaDataLoaderFactory() throws Exception {
        IMetaData iMetaData = LoaderFactory.getMetaData("testfiles/gda/analysis/io/EdfLoaderTest/diff6105.edf", null);
        Assert.assertEquals((Object)iMetaData.getMetaValue("HeaderID"), (Object)"EH:000001:000000:000000");
        Assert.assertEquals((Object)iMetaData.getMetaValue("Image"), (Object)"1");
        Assert.assertEquals((Object)iMetaData.getMetaValue("ByteOrder"), (Object)"LowByteFirst");
        Assert.assertEquals((Object)iMetaData.getMetaValue("DataType"), (Object)"UnsignedShort");
        Assert.assertEquals((Object)iMetaData.getMetaValue("Dim_1"), (Object)"2048");
        Assert.assertEquals((Object)iMetaData.getMetaValue("Dim_2"), (Object)"2048");
        Assert.assertEquals((Object)iMetaData.getMetaValue("Size"), (Object)"8388608");
        Assert.assertEquals((Object)iMetaData.getMetaValue("time"), (Object)"Thu Jun 18 04:24:25 2009");
        Assert.assertEquals((Object)iMetaData.getMetaValue("count_time"), (Object)"Na");
        Assert.assertEquals((Object)iMetaData.getMetaValue("title"), (Object)"ESPIA FRELON Image 6105");
        Assert.assertEquals((Object)iMetaData.getMetaValue("run"), (Object)"6105");
    }

    @Test
    public void loadDiff6105() throws Exception {
        PilatusEdfLoader pilatusEdfLoader = new PilatusEdfLoader("testfiles/gda/analysis/io/EdfLoaderTest/diff6105.edf");
        DataHolder dataHolder = pilatusEdfLoader.loadFile();
        Assert.assertEquals((Object)pilatusEdfLoader.getMetaData().getMetaValue("HeaderID"), (Object)"EH:000001:000000:000000");
        Assert.assertEquals((Object)pilatusEdfLoader.getMetaData().getMetaValue("Image"), (Object)"1");
        Assert.assertEquals((Object)pilatusEdfLoader.getMetaData().getMetaValue("ByteOrder"), (Object)"LowByteFirst");
        Assert.assertEquals((Object)pilatusEdfLoader.getMetaData().getMetaValue("DataType"), (Object)"UnsignedShort");
        Assert.assertEquals((Object)pilatusEdfLoader.getMetaData().getMetaValue("Dim_1"), (Object)"2048");
        Assert.assertEquals((Object)pilatusEdfLoader.getMetaData().getMetaValue("Dim_2"), (Object)"2048");
        Assert.assertEquals((Object)pilatusEdfLoader.getMetaData().getMetaValue("Size"), (Object)"8388608");
        Assert.assertEquals((Object)pilatusEdfLoader.getMetaData().getMetaValue("time"), (Object)"Thu Jun 18 04:24:25 2009");
        Assert.assertEquals((Object)pilatusEdfLoader.getMetaData().getMetaValue("count_time"), (Object)"Na");
        Assert.assertEquals((Object)pilatusEdfLoader.getMetaData().getMetaValue("title"), (Object)"ESPIA FRELON Image 6105");
        Assert.assertEquals((Object)pilatusEdfLoader.getMetaData().getMetaValue("run"), (Object)"6105");
        AbstractDataset abstractDataset = dataHolder.getDataset("ESRF Pilatus Data");
        Assert.assertEquals((double)abstractDataset.getDouble(0, 0), (double)5898338.0, (double)0.0);
        Assert.assertEquals((double)abstractDataset.getDouble(2047, 2047), (double)0.0, (double)0.0);
    }

    @Test
    public void load() throws Exception {
        PilatusEdfLoader pilatusEdfLoader = new PilatusEdfLoader("testfiles/gda/analysis/io/EdfLoaderTest/pilatus300k.edf");
        DataHolder dataHolder = pilatusEdfLoader.loadFile();
        Assert.assertEquals((Object)pilatusEdfLoader.getMetaData().getMetaValue("HeaderID"), (Object)"EH:000001:000000:000000");
        Assert.assertEquals((Object)pilatusEdfLoader.getMetaData().getMetaValue("Image"), (Object)"1");
        Assert.assertEquals((Object)pilatusEdfLoader.getMetaData().getMetaValue("VersionNumber"), (Object)"0.10");
        Assert.assertEquals((Object)pilatusEdfLoader.getMetaData().getMetaValue("ByteOrder"), (Object)"LowByteFirst");
        Assert.assertEquals((Object)pilatusEdfLoader.getMetaData().getMetaValue("DataType"), (Object)"SignedInteger");
        Assert.assertEquals((Object)pilatusEdfLoader.getMetaData().getMetaValue("Dim_1"), (Object)"1475");
        Assert.assertEquals((Object)pilatusEdfLoader.getMetaData().getMetaValue("Dim_2"), (Object)"195");
        Assert.assertEquals((Object)pilatusEdfLoader.getMetaData().getMetaValue("Size"), (Object)"1150500");
        Assert.assertEquals((Object)pilatusEdfLoader.getMetaData().getMetaValue("Date"), (Object)"Wed Jun 16 19:14:09 2010");
        Assert.assertEquals((Object)pilatusEdfLoader.getMetaData().getMetaValue("count_time"), (Object)"1.000000000");
        Assert.assertEquals((Object)pilatusEdfLoader.getMetaData().getMetaValue("title"), (Object)"# Pixel_size 172e-6 m x 172e-6 m");
        Assert.assertEquals((Object)pilatusEdfLoader.getMetaData().getMetaValue("run"), (Object)"0");
        AbstractDataset abstractDataset = dataHolder.getDataset("ESRF Pilatus Data");
        Assert.assertEquals((double)abstractDataset.getDouble(0, 0), (double)38.0, (double)0.0);
        Assert.assertEquals((double)abstractDataset.getDouble(0, 1), (double)38.0, (double)0.0);
        Assert.assertEquals((double)abstractDataset.getDouble(0, 2), (double)34.0, (double)0.0);
        Assert.assertEquals((double)abstractDataset.getDouble(0, 3), (double)36.0, (double)0.0);
        Assert.assertEquals((double)abstractDataset.getDouble(0, 4), (double)30.0, (double)0.0);
        Assert.assertEquals((double)abstractDataset.getDouble(194, 1470), (double)223.0, (double)0.0);
        Assert.assertEquals((double)abstractDataset.getDouble(194, 1471), (double)212.0, (double)0.0);
        Assert.assertEquals((double)abstractDataset.getDouble(194, 1472), (double)179.0, (double)0.0);
        Assert.assertEquals((double)abstractDataset.getDouble(194, 1473), (double)191.0, (double)0.0);
        Assert.assertEquals((double)abstractDataset.getDouble(194, 1474), (double)229.0, (double)0.0);
    }
}

