/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.analysis.io.ScanFileHolderException;
import gda.data.nexus.extractor.NexusExtractor;
import gda.data.nexus.extractor.NexusExtractorException;
import gda.data.nexus.extractor.NexusGroupData;
import gda.data.nexus.tree.INexusTree;
import gda.data.nexus.tree.NexusTreeBuilder;
import gda.data.nexus.tree.NexusTreeNodeSelection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.Vector;
import org.nexusformat.NexusException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.Nexus;
import uk.ac.diamond.scisoft.analysis.io.ASCIIDataHolderSaver;
import uk.ac.diamond.scisoft.analysis.io.AbstractFileLoader;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.IDataSetLoader;
import uk.ac.diamond.scisoft.analysis.io.IMetaData;
import uk.ac.diamond.scisoft.analysis.io.IMetaLoader;
import uk.ac.diamond.scisoft.analysis.io.SRSLoader;
import uk.ac.gda.monitor.IMonitor;

public class NexusLoader
extends AbstractFileLoader
implements IMetaLoader,
IDataSetLoader {
    private static final Logger logger = LoggerFactory.getLogger(NexusLoader.class);
    private String filename;
    private String nexusDataSelectionFilename;
    private String nexusMetaDataSelectionFilename;
    private NexusTreeNodeSelection dataSelectionTree;
    private NexusTreeNodeSelection metaSelectionTree;
    private List<String> dataSetNames;
    private boolean keepBitWidth = false;
    private List<String> allDataSetNames;
    private Map<String, Integer> allDataSetSizes;

    public NexusLoader() {
    }

    public NexusLoader(String string, List<String> list) {
        this.filename = string;
        this.nexusDataSelectionFilename = "";
        this.nexusMetaDataSelectionFilename = "";
        this.dataSelectionTree = null;
        this.metaSelectionTree = null;
        this.dataSetNames = list;
    }

    public NexusLoader(String string) {
        this.setFile(string);
    }

    public void setFile(String string) {
        this.filename = string;
        this.nexusDataSelectionFilename = "";
        this.nexusMetaDataSelectionFilename = "";
        this.dataSelectionTree = null;
        this.metaSelectionTree = null;
        this.dataSetNames = null;
    }

    public NexusLoader(String string, String string2, String string3, List<String> list) {
        this.filename = string;
        this.nexusDataSelectionFilename = string2;
        this.nexusMetaDataSelectionFilename = string3;
        this.dataSelectionTree = null;
        this.metaSelectionTree = null;
        this.dataSetNames = list;
    }

    public NexusLoader(String string, NexusTreeNodeSelection nexusTreeNodeSelection, NexusTreeNodeSelection nexusTreeNodeSelection2, List<String> list) {
        this.filename = string;
        this.nexusDataSelectionFilename = null;
        this.nexusMetaDataSelectionFilename = null;
        this.dataSelectionTree = nexusTreeNodeSelection;
        this.metaSelectionTree = nexusTreeNodeSelection2;
        this.dataSetNames = list;
        if (nexusTreeNodeSelection == null || nexusTreeNodeSelection2 == null) {
            throw new IllegalArgumentException("dataSelectionTree == null || metaSelectionTree == null");
        }
    }

    public NexusLoader(String string, boolean bl) {
        if (bl) {
            NexusTreeNodeSelection nexusTreeNodeSelection = NexusTreeNodeSelection.createTreeForAllData();
            this.filename = string;
            this.nexusDataSelectionFilename = null;
            this.nexusMetaDataSelectionFilename = null;
            this.dataSelectionTree = nexusTreeNodeSelection;
            this.metaSelectionTree = nexusTreeNodeSelection;
            this.dataSetNames = null;
        } else {
            this.filename = string;
            this.nexusDataSelectionFilename = "";
            this.nexusMetaDataSelectionFilename = "";
            this.dataSelectionTree = null;
            this.metaSelectionTree = null;
            this.dataSetNames = null;
        }
    }

    public static void convertToAscii(String string, String string2, String string3, String string4, List<String> list) throws ScanFileHolderException {
        DataHolder dataHolder = new NexusLoader(string, string2, string3, list).loadFile();
        new ASCIIDataHolderSaver(string4).saveFile(dataHolder);
    }

    public static void convertToSRS(String string, String string2, String string3, String string4, List<String> list) throws ScanFileHolderException {
        DataHolder dataHolder = new NexusLoader(string, string2, string3, list).loadFile();
        new SRSLoader(string4).saveFile(dataHolder);
    }

    @Override
    public DataHolder loadFile() throws ScanFileHolderException {
        return this.loadFile(null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public DataHolder loadFile(IMonitor iMonitor) throws ScanFileHolderException {
        void var6_16;
        DataHolder dataHolder;
        block17: {
            block16: {
                block15: {
                    try {
                        INexusTree iNexusTree = this.dataSelectionTree != null ? (this.dataSelectionTree.equals(NexusTreeNodeSelection.SKIP) ? null : NexusTreeBuilder.getNexusTree((String)this.filename, (NexusTreeNodeSelection)this.dataSelectionTree, (IMonitor)iMonitor)) : (this.nexusDataSelectionFilename != null && !this.nexusDataSelectionFilename.isEmpty() ? NexusTreeBuilder.getNexusTree((String)this.filename, (String)this.nexusDataSelectionFilename, (IMonitor)iMonitor) : (this.dataSetNames != null ? NexusLoader.getTreeForDatasetNames(this.filename, this.dataSetNames, true, iMonitor) : NexusTreeBuilder.getNexusTree((String)this.filename, (NexusTreeNodeSelection)NexusTreeNodeSelection.createTreeForAllNXData(), (IMonitor)iMonitor)));
                        Map<String, INexusTree> map = NexusLoader.getDatasetNodes(iNexusTree, this.dataSetNames);
                        dataHolder = new DataHolder();
                        Vector<String> vector = new Vector<String>();
                        if (this.dataSetNames != null) {
                            for (String object2 : this.dataSetNames) {
                                if (!map.containsKey(object2)) continue;
                                this.addData(vector, dataHolder, map.get(object2), object2);
                            }
                        } else {
                            for (Map.Entry<String, INexusTree> entry : map.entrySet()) {
                                this.addData(vector, dataHolder, entry.getValue(), entry.getKey());
                            }
                        }
                        if (this.monitorIncrement(iMonitor)) break block15;
                        return null;
                    }
                    catch (Exception exception) {
                        throw new ScanFileHolderException("NexusReader exception loading " + this.filename + (this.nexusDataSelectionFilename == null ? "" : " using selection file" + this.nexusDataSelectionFilename), exception);
                    }
                }
                Object var6_12 = null;
                if (this.metaSelectionTree != null) {
                    INexusTree iNexusTree = this.metaSelectionTree.equals(NexusTreeNodeSelection.SKIP) ? null : NexusTreeBuilder.getNexusTree((String)this.filename, (NexusTreeNodeSelection)this.metaSelectionTree, (IMonitor)iMonitor);
                } else if (this.nexusMetaDataSelectionFilename != null && !this.nexusMetaDataSelectionFilename.isEmpty()) {
                    INexusTree iNexusTree = NexusTreeBuilder.getNexusTree((String)this.filename, (String)this.nexusMetaDataSelectionFilename, (IMonitor)iMonitor);
                } else if (this.dataSetNames == null) {
                    INexusTree iNexusTree = NexusTreeBuilder.getNexusTree((String)this.filename, (NexusTreeNodeSelection)NexusTreeNodeSelection.createTreeForAllMetaData(), (IMonitor)iMonitor);
                }
                if (this.monitorIncrement(iMonitor)) break block16;
                return null;
            }
            if (this.monitorIncrement(iMonitor)) break block17;
            return null;
        }
        if (var6_16 != null) {
            dataHolder.setNexusTree((INexusTree)var6_16);
        }
        return dataHolder;
    }

    public static Map<String, INexusTree> getDatasetNodes(INexusTree iNexusTree, List<String> list) {
        TreeMap<String, INexusTree> treeMap = new TreeMap<String, INexusTree>();
        Vector<String> vector = new Vector<String>();
        if (iNexusTree != null) {
            int n = 0;
            while (n < iNexusTree.getNumberOfChildNodes()) {
                INexusTree iNexusTree2 = iNexusTree.getChildNode(n);
                if (iNexusTree2.getNxClass().equals("NXentry")) {
                    int n2 = 0;
                    while (n2 < iNexusTree2.getNumberOfChildNodes()) {
                        INexusTree iNexusTree3 = iNexusTree2.getChildNode(n2);
                        if (iNexusTree3.getNxClass().equals("NXdata")) {
                            String string = iNexusTree3.getName();
                            int n3 = 0;
                            while (n3 < iNexusTree3.getNumberOfChildNodes()) {
                                INexusTree iNexusTree4 = iNexusTree3.getChildNode(n3);
                                String string2 = iNexusTree4.getName();
                                HashMap hashMap = iNexusTree4.getAttributes();
                                String string3 = null;
                                if (hashMap != null) {
                                    string3 = (String)hashMap.get("target");
                                }
                                boolean bl = true;
                                if (string3 != null) {
                                    boolean bl2 = bl = !vector.contains(string3);
                                    if (bl && string3.endsWith("instrument/" + string + "/" + string2)) {
                                        string2 = String.valueOf(string) + "." + string2;
                                    }
                                } else {
                                    string2 = String.valueOf(string) + "." + string2;
                                }
                                if (bl && (list == null || list.contains(string2)) && !treeMap.containsKey(string2)) {
                                    treeMap.put(string2, iNexusTree4);
                                    if (string3 != null) {
                                        vector.add(string3);
                                    }
                                }
                                ++n3;
                            }
                        }
                        ++n2;
                    }
                }
                ++n;
            }
        }
        return treeMap;
    }

    public static INexusTree getTreeForDatasetNames(String string, List<String> list, boolean bl, IMonitor iMonitor) throws NexusException, NexusExtractorException {
        return NexusTreeBuilder.getNexusTree((String)string, (NexusTreeNodeSelection)NexusTreeNodeSelection.createTreeForDataSetNames(list, (boolean)bl), (IMonitor)iMonitor);
    }

    private void addData(Vector<String> vector, DataHolder dataHolder, INexusTree iNexusTree, String string) {
        NexusGroupData nexusGroupData;
        if (vector.contains(string)) {
            return;
        }
        if ((this.dataSetNames == null || this.dataSetNames.contains(string)) && (nexusGroupData = iNexusTree.getData()) != null && nexusGroupData.getBuffer() != null) {
            AbstractDataset abstractDataset = Nexus.createDataset(nexusGroupData, this.keepBitWidth);
            if (abstractDataset == null) {
                logger.error("NexusLoader cannot handle data of type {}", (Object)nexusGroupData.type);
            } else {
                abstractDataset.setName(string);
                dataHolder.addDataset(string, abstractDataset);
                vector.add(string);
            }
        }
    }

    @Override
    public void loadMetaData(IMonitor iMonitor) throws Exception {
        this.allDataSetNames = NexusLoader.getDatasetNames(this.filename, iMonitor);
        this.allDataSetSizes = this.getDataSetSizes(this.filename, this.allDataSetNames, iMonitor);
    }

    @Override
    public IMetaData getMetaData() {
        return new IMetaData(){

            @Override
            public String getMetaValue(String string) {
                return null;
            }

            @Override
            public Collection<String> getDataNames() {
                return Collections.unmodifiableCollection(NexusLoader.this.allDataSetNames);
            }

            @Override
            public Map<String, Integer> getDataSizes() {
                return NexusLoader.this.allDataSetSizes;
            }
        };
    }

    private Map<String, Integer> getDataSetSizes(String string, List<String> list, IMonitor iMonitor) {
        try {
            Map<String, INexusTree> map = gda.analysis.io.NexusLoader.getDataSetNexusTrees(string, list, false, iMonitor);
            HashMap<String, Integer> hashMap = new HashMap<String, Integer>(list.size());
            for (Map.Entry<String, INexusTree> entry : map.entrySet()) {
                hashMap.put(entry.getKey(), NexusExtractor.calcTotalLength((int[])entry.getValue().getData().dimensions));
            }
            return hashMap;
        }
        catch (Exception exception) {
            logger.error("Cannot get data sizes for " + string, (Throwable)exception);
            return null;
        }
    }

    public static List<String> getDatasetNames(String string, IMonitor iMonitor) throws NexusException, NexusExtractorException, Exception {
        INexusTree iNexusTree = NexusLoader.getTreeForDatasetNames(string, null, false, iMonitor);
        Map<String, INexusTree> map = NexusLoader.getDatasetNodes(iNexusTree, null);
        Vector<String> vector = new Vector<String>();
        for (Map.Entry<String, INexusTree> entry : map.entrySet()) {
            vector.add(entry.getKey());
        }
        return vector;
    }

    public static Map<String, INexusTree> getDatasetNexusTrees(String string, List<String> list, boolean bl, IMonitor iMonitor) throws NexusException, NexusExtractorException, Exception {
        INexusTree iNexusTree = NexusLoader.getTreeForDatasetNames(string, list, bl, iMonitor);
        Map<String, INexusTree> map = NexusLoader.getDatasetNodes(iNexusTree, list);
        return map;
    }

    @Override
    public IDataset loadSet(String string, String string2, IMonitor iMonitor) throws Exception {
        List<String> list = this.dataSetNames;
        try {
            this.dataSetNames = Arrays.asList(string2);
            DataHolder dataHolder = this.loadFile(iMonitor);
            AbstractDataset abstractDataset = dataHolder.getDataset(string2);
            return abstractDataset;
        }
        finally {
            this.dataSetNames = list;
        }
    }
}

