/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import com.sun.media.imageio.plugins.tiff.TIFFDirectory;
import com.sun.media.imageio.plugins.tiff.TIFFField;
import gda.analysis.io.ScanFileHolderException;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.FileImageInputStream;
import javax.vecmath.Matrix3d;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.JavaImageLoader;
import uk.ac.diamond.scisoft.analysis.io.Utils;
import uk.ac.gda.monitor.IMonitor;

public class MARLoader
extends JavaImageLoader {
    static final int MAX_IMAGES = 9;
    static final int MAR_HEADER_SIZE = 3072;
    private boolean littleEndian;
    private HashMap<String, Object> metadataTable = new HashMap();
    public HashMap<String, Object> GDAMetadata = new HashMap();

    public MARLoader() {
        this(null);
    }

    public MARLoader(String string) {
        super(string, "tiff");
        this.fileName = string;
    }

    @Override
    public DataHolder loadFile() throws ScanFileHolderException {
        return this.loadFile(null);
    }

    @Override
    public DataHolder loadFile(IMonitor iMonitor) throws ScanFileHolderException {
        Object[] objectArray;
        Object object;
        Object object2;
        Object object3;
        DataHolder dataHolder = null;
        dataHolder = super.loadFile();
        long l = -1L;
        File file = new File(this.fileName);
        try {
            object3 = ImageIO.getImageReadersByFormatName("tiff").next();
            object2 = new FileImageInputStream(file);
            ((ImageReader)object3).setInput(object2);
            IIOMetadata iIOMetadata = ((ImageReader)object3).getImageMetadata(0);
            object = TIFFDirectory.createFromMetadata((IIOMetadata)iIOMetadata);
            TIFFField[] tIFFFieldArray = object.getTIFFFields();
            if (iMonitor != null) {
                if (iMonitor.isCancelled()) {
                    throw new ScanFileHolderException("Loading of " + this.fileName + " cancelled!");
                }
                iMonitor.worked(5);
            }
            int n = 0;
            while (n < tIFFFieldArray.length) {
                TIFFField tIFFField = tIFFFieldArray[n];
                this.metadataTable.put(tIFFField.getTag().getName(), tIFFField.getValueAsString(0));
                ++n;
            }
            if (iMonitor != null) {
                if (iMonitor.isCancelled()) {
                    throw new ScanFileHolderException("Loading of " + this.fileName + " cancelled!");
                }
                iMonitor.worked(5);
            }
            objectArray = tIFFFieldArray;
            int n2 = tIFFFieldArray.length;
            int n3 = 0;
            while (n3 < n2) {
                TIFFField tIFFField = objectArray[n3];
                if (tIFFField.getTagNumber() == 34710) {
                    l = tIFFField.getAsLong(0);
                    break;
                }
                ++n3;
            }
            if (l < 0L) {
                throw new ScanFileHolderException("There was a problem getting to the begining of the MAR of the header");
            }
        }
        catch (Exception exception) {
            throw new ScanFileHolderException("Problem loading tiff header metadata in the MAR Loader class", exception);
        }
        try {
            object3 = new FileInputStream(file);
            object2 = new byte[3072];
            ((InputStream)object3).skip(l);
            ((InputStream)object3).read((byte[])object2, 0, 3072);
            int n = 28;
            if (Utils.beInt((int)object2[n], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]) == 4321) {
                this.littleEndian = false;
            }
            if (Utils.leInt((int)object2[n], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]) != 1234) {
                throw new ScanFileHolderException("Unknown endian");
            }
            this.littleEndian = true;
            this.metadataTable.put("headerByteOrderLE", this.littleEndian);
            n = 0;
            this.metadataTable.put("headerType", this.getHeaderInt((int)object2[n], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            object = new byte[16];
            System.arraycopy(object2, n += 4, object, 0, 16);
            this.metadataTable.put("headerName", new String((byte[])object, "US-ASCII"));
            this.metadataTable.put("headerMajorVersion", this.getHeaderInt((int)object2[n += 16], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("headerMinorVersion", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            n += 4;
            boolean bl = false;
            if (Utils.beInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]) == 4321) {
                bl = false;
            }
            if (Utils.leInt((int)object2[n], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]) == 1234) {
                bl = true;
            }
            if (iMonitor != null) {
                if (iMonitor.isCancelled()) {
                    throw new ScanFileHolderException("Loading of " + this.fileName + " cancelled!");
                }
                iMonitor.worked(5);
            }
            this.metadataTable.put("dataByteOrder", bl);
            this.metadataTable.put("headerSize", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("frameType", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("magicNumber", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("compressionType", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("compression1", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("compression2", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("compression3", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("compression4", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("compression5", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("compression6", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("nHeaders", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("nFast", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("nSlow", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("depth", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("recordLength", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("signifBits", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("dataType", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("saturatedValue", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("sequence", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("nImages", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("origin", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("orientation", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("viewDirection", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("overflowLocation", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("over8Bits", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("over16Bits", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("multiplexed", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("numFastImages", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("numSlowImages", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("backgroundApplied", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("biasApplied", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("flatFieldApplied", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("distortionApplied", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("originalHeaderType", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("fileSaved", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            n += 4;
            n += 80;
            if (iMonitor != null) {
                if (iMonitor.isCancelled()) {
                    throw new ScanFileHolderException("Loading of " + this.fileName + " cancelled!");
                }
                iMonitor.worked(5);
            }
            int[] nArray = new int[]{this.getHeaderInt((int)object2[n], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]), this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3])};
            this.metadataTable.put("totalCounts", nArray);
            int[] nArray2 = new int[]{this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]), this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3])};
            this.metadataTable.put("specialCounts1", nArray2);
            int[] nArray3 = new int[]{this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]), this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3])};
            this.metadataTable.put("specialCounts2", nArray2);
            this.metadataTable.put("min", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("max", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("mean", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("rms", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("p10", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("p90", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("statsUpToDate", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            n += 4;
            objectArray = new int[9];
            int n4 = 0;
            while (n4 < 9) {
                objectArray[n4] = (TIFFField)this.getHeaderInt((int)object2[n], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]);
                n += 4;
                ++n4;
            }
            this.metadataTable.put("pixelNoise", objectArray);
            n += 40;
            if (iMonitor != null) {
                if (iMonitor.isCancelled()) {
                    throw new ScanFileHolderException("Loading of " + this.fileName + " cancelled!");
                }
                iMonitor.worked(5);
            }
            int[] nArray4 = new int[128];
            int n5 = 0;
            while (n5 < 128) {
                nArray4[n5] = this.littleEndian ? Utils.leInt((int)object2[n], (int)object2[n + 1]) : Utils.beInt((int)object2[n], (int)object2[n + 1]);
                n += 2;
                ++n5;
            }
            this.metadataTable.put("xtaltoDetector", (double)this.getHeaderInt((int)object2[n], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]) / 1000.0);
            this.metadataTable.put("beamX", (double)this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]) / 1000.0);
            this.metadataTable.put("beamY", (double)this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]) / 1000.0);
            this.metadataTable.put("intergrationTime", (double)this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]) / 1000.0);
            this.metadataTable.put("exposureTime", (double)this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]) / 1000.0);
            this.metadataTable.put("readoutTime", (double)this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]) / 1000.0);
            this.metadataTable.put("nReads", (double)this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]) / 1000.0);
            this.metadataTable.put("start2theta", (double)this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]) / 1000.0);
            this.metadataTable.put("startOmega", (double)this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]) / 1000.0);
            this.metadataTable.put("startChi", (double)this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]) / 1000.0);
            this.metadataTable.put("startKappa", (double)this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]) / 1000.0);
            this.metadataTable.put("startPhi", (double)this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]) / 1000.0);
            this.metadataTable.put("startDelta", (double)this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]) / 1000.0);
            this.metadataTable.put("startGamma", (double)this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]) / 1000.0);
            this.metadataTable.put("startXtaltoDetector", (double)this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]) / 1000.0);
            this.metadataTable.put("stop2theta", (double)this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]) / 1000.0);
            this.metadataTable.put("stopOmega", (double)this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]) / 1000.0);
            this.metadataTable.put("stopChi", (double)this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]) / 1000.0);
            this.metadataTable.put("stopKappa", (double)this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]) / 1000.0);
            this.metadataTable.put("stopPhi", (double)this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]) / 1000.0);
            this.metadataTable.put("stopDelta", (double)this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]) / 1000.0);
            this.metadataTable.put("stopGamma", (double)this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]) / 1000.0);
            this.metadataTable.put("stopXtaltoDetector", (double)this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]) / 1000.0);
            this.metadataTable.put("rotationAxis", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("rotationRange", (double)this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]) / 1000.0);
            this.metadataTable.put("detectorRotateX", (double)this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]) / 1000.0);
            this.metadataTable.put("detectorRotateY", (double)this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]) / 1000.0);
            this.metadataTable.put("detectorRotateZ", (double)this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]) / 1000.0);
            n += 4;
            this.metadataTable.put("detectorType", this.getHeaderInt((int)object2[n += 16], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("pixelSizeX", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("pixelSizeY", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("meanBias", (double)this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]) / 1000.0);
            this.metadataTable.put("photonPer100ADU", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            n += 4;
            int[] nArray5 = new int[9];
            int n6 = 0;
            while (n6 < 9) {
                nArray5[n6] = this.getHeaderInt((int)object2[n], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]);
                n += 4;
                ++n6;
            }
            this.metadataTable.put("measuredBias", nArray5);
            if (iMonitor != null) {
                if (iMonitor.isCancelled()) {
                    throw new ScanFileHolderException("Loading of " + this.fileName + " cancelled!");
                }
                iMonitor.worked(5);
            }
            int[] nArray6 = new int[9];
            int n7 = 0;
            while (n7 < 9) {
                nArray6[n7] = this.getHeaderInt((int)object2[n], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]);
                n += 4;
                ++n7;
            }
            this.metadataTable.put("measuredTemperature", nArray6);
            int[] nArray7 = new int[9];
            int n8 = 0;
            while (n8 < 9) {
                nArray7[n8] = this.getHeaderInt((int)object2[n], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]);
                n += 4;
                ++n8;
            }
            if (iMonitor != null) {
                if (iMonitor.isCancelled()) {
                    throw new ScanFileHolderException("Loading of " + this.fileName + " cancelled!");
                }
                iMonitor.worked(5);
            }
            this.metadataTable.put("measuredPressure", nArray7);
            this.metadataTable.put("sourceType", this.getHeaderInt((int)object2[n], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("sourcedx", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("sourcedy", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("sourceWavelength", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("sourcePower", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("sourceVoltage", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("sourceCurrent", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("sourceBias", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("sourcePolerizationX", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("sourcePolerizationY", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            n += 4;
            this.metadataTable.put("opticsType", this.getHeaderInt((int)object2[n += 16], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("opticsdx", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("opticsdy", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("opticsWavelength", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("opticsDispersion", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("opticsCrossfireX", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("opticsCrossfireY", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("opticsAngle", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("opticsPolerizationX", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            this.metadataTable.put("opticsPolerizationY", this.getHeaderInt((int)object2[n += 4], (int)object2[n + 1], (int)object2[n + 2], (int)object2[n + 3]));
            n += 4;
            n += 16;
            n += 16;
            if (iMonitor != null) {
                if (iMonitor.isCancelled()) {
                    throw new ScanFileHolderException("Loading of " + this.fileName + " cancelled!");
                }
                iMonitor.worked(5);
            }
            object = new byte[128];
            System.arraycopy(object2, n, object, 0, 128);
            this.metadataTable.put("filetitle", new String((byte[])object, "US-ASCII"));
            object = new byte[128];
            System.arraycopy(object2, n += 128, object, 0, 128);
            this.metadataTable.put("filepath", new String((byte[])object, "US-ASCII"));
            object = new byte[64];
            System.arraycopy(object2, n += 128, object, 0, 64);
            this.metadataTable.put("filename", new String((byte[])object, "US-ASCII"));
            object = new byte[32];
            System.arraycopy(object2, n += 64, object, 0, 32);
            this.metadataTable.put("AcquireTimestamp", new String((byte[])object, "US-ASCII"));
            n += 32;
            if (iMonitor != null) {
                if (iMonitor.isCancelled()) {
                    throw new ScanFileHolderException("Loading of " + this.fileName + " cancelled!");
                }
                iMonitor.worked(5);
            }
            object = new byte[32];
            System.arraycopy(object2, n, object, 0, 32);
            this.metadataTable.put("headerTimestamp", new String((byte[])object, "US-ASCII"));
            object = new byte[512];
            System.arraycopy(object2, n += 32, object, 0, 512);
            this.metadataTable.put("fileComment", new String((byte[])object, "US-ASCII"));
            n += 512;
            object = new byte[512];
            System.arraycopy(object2, n += 96, object, 0, 512);
            this.metadataTable.put("datasetComments", new String((byte[])object, "US-ASCII"));
            n += 512;
            if (iMonitor != null) {
                if (iMonitor.isCancelled()) {
                    throw new ScanFileHolderException("Loading of " + this.fileName + " cancelled!");
                }
                iMonitor.worked(5);
            }
        }
        catch (Exception exception) {
            throw new ScanFileHolderException("Problem loading MAR metadata", exception);
        }
        this.createGDAMetatdata();
        dataHolder.getDataset(0).setMetadataMap(this.GDAMetadata);
        dataHolder.addMetadata(this.GDAMetadata);
        return dataHolder;
    }

    private int getHeaderInt(int n, int n2, int n3, int n4) {
        int n5 = this.littleEndian ? Utils.leInt(n, n2, n3, n4) : Utils.beInt(n, n2, n3, n4);
        return n5;
    }

    private void createGDAMetatdata() throws ScanFileHolderException {
        try {
            double d = (double)((Integer)this.getMetadataValue("pixelSizeX")).intValue() / 1000000.0;
            int n = Integer.parseInt((String)this.getMetadataValue("ImageWidth"));
            double d2 = (Double)this.getMetadataValue("beamX");
            double d3 = (double)((Integer)this.getMetadataValue("pixelSizeY")).intValue() / 1000000.0;
            int n2 = Integer.parseInt((String)this.getMetadataValue("ImageLength"));
            double d4 = (Double)this.getMetadataValue("beamY");
            double d5 = (Double)this.getMetadataValue("xtaltoDetector");
            double[] dArray = new double[]{((double)n - d2) * d, ((double)n2 - d4) * d3, d5};
            this.GDAMetadata.put("NXdetector:NXgeometery:NXtranslation", dArray);
            this.GDAMetadata.put("NXdetector:NXgeometery:NXtranslation:NXunits", "metre");
            double d6 = (Double)this.getMetadataValue("detectorRotateX");
            double d7 = (Double)this.getMetadataValue("detectorRotateY");
            double d8 = (Double)this.getMetadataValue("detectorRotateZ");
            Matrix3d matrix3d = new Matrix3d();
            matrix3d.rotX(d6);
            Matrix3d matrix3d2 = new Matrix3d();
            matrix3d2.rotY(d7);
            Matrix3d matrix3d3 = new Matrix3d();
            matrix3d3.rotZ(d8);
            Matrix3d matrix3d4 = new Matrix3d();
            matrix3d4.mul(matrix3d, matrix3d2);
            matrix3d4.mul(matrix3d3);
            double[] dArray2 = new double[3];
            double[] dArray3 = new double[3];
            double[] dArray4 = new double[6];
            matrix3d4.getColumn(0, dArray2);
            matrix3d4.getColumn(1, dArray3);
            int n3 = 0;
            while (n3 < dArray4.length / 2) {
                dArray4[n3] = dArray2[n3];
                dArray4[3 + n3] = dArray3[n3];
                ++n3;
            }
            this.GDAMetadata.put("NXdetector:NXgeometery:NXorientation", dArray4);
            double[] dArray5 = new double[]{((double)n - d2) * d, ((double)n2 - d4) * d3, 0.0, 0.0, 0.0, 0.0};
            this.GDAMetadata.put("NXdetector:NXgeometery:NXshape", dArray5);
            this.GDAMetadata.put("NXdetector:NXgeometery:NXshape:NXshape", "milli*metre");
            this.GDAMetadata.put("NXdetector:x_pixel_size", d);
            this.GDAMetadata.put("NXdetector:x_pixel_size:NXunits", "milli*metre");
            this.GDAMetadata.put("NXdetector:y_pixel_size", d3);
            this.GDAMetadata.put("NXdetector:y_pixel_size:NXunits", "milli*metre");
            double d9 = (Integer)this.getMetadataValue("sourceWavelength") / 100000;
            this.GDAMetadata.put("NXmonochromator:wavelength", d9);
            this.GDAMetadata.put("NXmonochromator:wavelength:NXunits", "Angstrom");
            double d10 = Double.parseDouble(this.getMetadataValue("startOmega").toString());
            double d11 = d10 - Double.parseDouble(this.getMetadataValue("stopOmega").toString());
            this.GDAMetadata.put("NXSample:rotation_start", d10);
            this.GDAMetadata.put("NXSample:rotation_start:NXUnits", "degree");
            this.GDAMetadata.put("NXSample:rotation_range", d11);
            this.GDAMetadata.put("NXSample:rotation_range:NXUnits", "degree");
            this.GDAMetadata.put("NXSample:exposure_time", this.getMetadataValue("exposureTime"));
            this.GDAMetadata.put("NXSample:exposure_time:NXUnits", "seconds");
        }
        catch (NumberFormatException numberFormatException) {
            throw new ScanFileHolderException("There was a problem parsing numerical value from string", numberFormatException);
        }
        catch (ScanFileHolderException scanFileHolderException) {}
    }

    private Object getMetadataValue(String string) throws ScanFileHolderException {
        try {
            Object object = this.metadataTable.get(string);
            return object;
        }
        catch (Exception exception) {
            throw new ScanFileHolderException("The keyword " + string + " was not found in the MAR header", exception);
        }
    }
}

