/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.analysis.DataSet;
import gda.data.nexus.tree.INexusTree;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;

public class DataHolder {
    protected static final Logger logger = LoggerFactory.getLogger(DataHolder.class);
    private List<IDataset> data = new Vector<IDataset>();
    private List<String> names = new Vector<String>();
    private List<Map<String, ? extends Object>> metadata = new Vector<Map<String, ? extends Object>>();
    private INexusTree nexusTree;

    @Deprecated
    public void addDataSet(String string, IDataset iDataset) {
        logger.warn("This is deprecated - use addDataset");
        this.names.add(string);
        this.data.add(iDataset);
    }

    @Deprecated
    public void addDataSet(String string, IDataset iDataset, Map<String, ? extends Object> map) {
        logger.warn("This is deprecated - use addDataset");
        this.names.add(string);
        this.data.add(iDataset);
        this.metadata.add(map);
    }

    public void addDataset(String string, IDataset iDataset) {
        this.names.add(string);
        this.data.add(iDataset);
    }

    public void addDataset(String string, IDataset iDataset, Map<String, ? extends Object> map) {
        this.names.add(string);
        this.data.add(iDataset);
        this.metadata.add(map);
    }

    public INexusTree getNexusTree() {
        return this.nexusTree;
    }

    public void setNexusTree(INexusTree iNexusTree) {
        this.nexusTree = iNexusTree;
    }

    public void addMetadata(Map<String, ? extends Object> map) {
        this.metadata.add(map);
    }

    public List<Map<String, ? extends Object>> getMetadata() {
        return this.metadata;
    }

    public Map<String, IDataset> getMap() {
        HashMap<String, IDataset> hashMap = new HashMap<String, IDataset>();
        int n = this.data.size();
        int n2 = 0;
        while (n2 < n) {
            hashMap.put(this.names.get(n2), this.data.get(n2));
            ++n2;
        }
        return hashMap;
    }

    public List<IDataset> getList() {
        int n = this.data.size();
        ArrayList<IDataset> arrayList = new ArrayList<IDataset>(n);
        int n2 = 0;
        while (n2 < n) {
            arrayList.add(this.data.get(n2));
            ++n2;
        }
        return this.data;
    }

    public void setDataset(int n, IDataset iDataset) {
        this.data.set(n, iDataset);
    }

    public void setDataset(String string, IDataset iDataset) {
        this.data.set(this.names.indexOf(string), iDataset);
    }

    public DataSet getDataSet(int n) {
        return DataSet.convertToDataset(this.data.get(n));
    }

    public DataSet getDataSet(String string) {
        if (this.names.contains(string)) {
            return DataSet.convertToDataset(this.data.get(this.names.indexOf(string)));
        }
        return null;
    }

    public AbstractDataset getDataset(int n) {
        return DatasetUtils.convertToAbstractDataset(this.data.get(n));
    }

    public AbstractDataset getDataset(String string) {
        if (this.names.contains(string)) {
            return DatasetUtils.convertToAbstractDataset(this.data.get(this.names.indexOf(string)));
        }
        return null;
    }

    public boolean contains(String string) {
        return this.names.contains(string);
    }

    public int indexOf(String string) {
        return this.names.indexOf(string);
    }

    public String[] getNames() {
        return this.names.toArray(new String[this.names.size()]);
    }

    public String getName(int n) {
        return this.names.get(n);
    }

    public int size() {
        return this.data.size();
    }

    public int namesSize() {
        return this.names.size();
    }

    public void clear() {
        this.data.clear();
        this.names.clear();
    }

    public void remove(int n) {
        this.data.remove(n);
        this.names.remove(n);
    }
}

