/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.analysis.io.IFileLoader;
import gda.analysis.io.IFileSaver;
import gda.analysis.io.ScanFileHolderException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerDataset;
import uk.ac.diamond.scisoft.analysis.io.AbstractFileLoader;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.Utils;

public class CrysalisLoader
extends AbstractFileLoader
implements IFileLoader,
IFileSaver {
    private static final Logger logger = LoggerFactory.getLogger(CrysalisLoader.class);
    private String fileName = "";

    public CrysalisLoader() {
    }

    public CrysalisLoader(String string) {
        this.fileName = string;
    }

    public void setFile(String string) {
        this.fileName = string;
    }

    private void readInt(InputStream inputStream, int[] nArray, int n, int n2) throws IOException {
        byte[] byArray = new byte[4 * n2];
        inputStream.read(byArray);
        int n3 = n * 4;
        int n4 = 0;
        while (n4 < n2) {
            nArray[n4] = Utils.leInt((int)byArray[n3 + 3], (int)byArray[n3 + 2], (int)byArray[n3 + 1], (int)byArray[n3]);
            n3 += 4;
            ++n4;
        }
    }

    @Override
    public DataHolder loadFile() throws ScanFileHolderException {
        Object object;
        FileInputStream fileInputStream;
        IntegerDataset integerDataset;
        block17: {
            integerDataset = null;
            File file = null;
            fileInputStream = null;
            try {
                try {
                    file = new File(this.fileName);
                    fileInputStream = new FileInputStream(file);
                    object = new BufferedReader(new FileReader(file));
                    char[] cArray = new char[255];
                    ((BufferedReader)object).read(cArray, 0, 255);
                    String string = new String(cArray);
                    if (string.contains("OD")) {
                        ((BufferedReader)object).close();
                        fileInputStream.close();
                        fileInputStream = new FileInputStream(file);
                        object = new BufferedReader(new FileReader(file));
                        String[] stringArray = new String[5];
                        int n = 0;
                        while (n < stringArray.length) {
                            stringArray[n] = ((BufferedReader)object).readLine();
                            ++n;
                        }
                        if (!stringArray[1].contains("COMPRESSION= NO")) {
                            throw new IllegalArgumentException("File is compressed  - " + this.fileName);
                        }
                        Pattern pattern = Pattern.compile("NX= *(\\d+).*");
                        Matcher matcher = pattern.matcher(stringArray[2]);
                        if (!matcher.matches()) {
                            throw new IllegalArgumentException("NX not found  - " + this.fileName);
                        }
                        int n2 = Integer.valueOf(matcher.group(1));
                        pattern = Pattern.compile(".*NY= *(\\d+).*");
                        matcher = pattern.matcher(stringArray[2]);
                        if (!matcher.matches()) {
                            throw new IllegalArgumentException("NY not found  - " + this.fileName);
                        }
                        int n3 = Integer.valueOf(matcher.group(1));
                        pattern = Pattern.compile("NHEADER= *(\\d+).*");
                        matcher = pattern.matcher(stringArray[3]);
                        if (!matcher.matches()) {
                            throw new IllegalArgumentException("NHEADER not found  - " + this.fileName);
                        }
                        int n4 = Integer.valueOf(matcher.group(1));
                        char[] cArray2 = new char[n4];
                        int n5 = 0;
                        while (n5 < cArray2.length) {
                            fileInputStream.read();
                            ++n5;
                        }
                        n5 = n2;
                        int n6 = n3;
                        int n7 = n5 * n6;
                        int[] nArray = new int[]{n5, n6};
                        integerDataset = new IntegerDataset(nArray);
                        int[] nArray2 = integerDataset.getData();
                        this.readInt(fileInputStream, nArray2, 0, n7);
                        break block17;
                    }
                    throw new ScanFileHolderException("Not a valid Crysalis file");
                }
                catch (Exception exception) {
                    logger.error("File failed to load {} with error: {}", (Object)this.fileName, (Object)exception);
                    throw new ScanFileHolderException("File failed to load " + this.fileName, exception);
                }
            }
            catch (Throwable throwable) {
                if (fileInputStream != null) {
                    try {
                        fileInputStream.close();
                    }
                    catch (IOException iOException) {}
                    fileInputStream = null;
                }
                throw throwable;
            }
        }
        if (fileInputStream != null) {
            try {
                fileInputStream.close();
            }
            catch (IOException iOException) {}
            fileInputStream = null;
        }
        object = new DataHolder();
        ((DataHolder)object).addDataset("Ruby_Image", integerDataset);
        return object;
    }

    @Override
    public void saveFile(DataHolder dataHolder) {
        block15: {
            File file = null;
            FileOutputStream fileOutputStream = null;
            try {
                try {
                    file = new File(this.fileName);
                    fileOutputStream = new FileOutputStream(file);
                    AbstractDataset abstractDataset = dataHolder.getDataset(0);
                    int[] nArray = abstractDataset.getShape();
                    int n = nArray[0];
                    int n2 = nArray[1];
                    Utils.writeLeInt(fileOutputStream, n);
                    Utils.writeLeInt(fileOutputStream, n2);
                    int[] nArray2 = new int[2];
                    int n3 = 0;
                    while (n3 < n) {
                        nArray2[0] = n3;
                        int n4 = 0;
                        while (n4 < n2) {
                            nArray2[1] = n4++;
                            int n5 = abstractDataset.getInt(nArray2);
                            Utils.writeLeInt(fileOutputStream, n5);
                        }
                        ++n3;
                    }
                }
                catch (Exception exception) {
                    logger.error(exception.toString());
                    if (fileOutputStream == null) break block15;
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {}
                    fileOutputStream = null;
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (fileOutputStream != null) {
                    try {
                        fileOutputStream.close();
                    }
                    catch (IOException iOException) {}
                    fileOutputStream = null;
                }
                throw throwable;
            }
            if (fileOutputStream != null) {
                try {
                    fileOutputStream.close();
                }
                catch (IOException iOException) {}
                fileOutputStream = null;
            }
        }
    }
}

