/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.io;

import gda.analysis.io.ScanFileHolderException;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.HashMap;
import java.util.Vector;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerDataset;
import uk.ac.diamond.scisoft.analysis.io.AbstractFileLoader;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.Utils;

public class ADSCImageLoader
extends AbstractFileLoader {
    private String fileName = "";
    private HashMap<String, String> metadata = new HashMap();
    public HashMap<String, Object> GDAMetadata = new HashMap();
    private Vector<String> extraHeaders;
    private boolean keepBitWidth = false;

    public boolean isKeepBitWidth() {
        return this.keepBitWidth;
    }

    public void setKeepBitWidth(boolean bl) {
        this.keepBitWidth = bl;
    }

    public ADSCImageLoader() {
    }

    public ADSCImageLoader(String string) {
        this(string, false);
    }

    public ADSCImageLoader(String string, boolean bl) {
        this.fileName = string;
        this.keepBitWidth = bl;
    }

    public void setFile(String string) {
        this.fileName = string;
    }

    @Override
    public DataHolder loadFile() throws ScanFileHolderException {
        DataHolder dataHolder = new DataHolder();
        RandomAccessFile randomAccessFile = null;
        try {
            randomAccessFile = new RandomAccessFile(this.fileName, "r");
            this.processingMetadata(randomAccessFile);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new ScanFileHolderException("File not found", fileNotFoundException);
        }
        catch (Exception exception) {
            try {
                if (randomAccessFile != null) {
                    randomAccessFile.close();
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            throw new ScanFileHolderException("There was a problem loading or reading metadata", exception);
        }
        try {
            try {
                int n = Integer.parseInt(this.metadata.get("SIZE1"));
                int n2 = Integer.parseInt(this.metadata.get("SIZE2"));
                int n3 = Integer.parseInt(this.metadata.get("HEADER_BYTES").trim());
                randomAccessFile.seek(n3);
                int[] nArray = new int[]{n, n2};
                byte[] byArray = new byte[n * n2 * 2];
                randomAccessFile.read(byArray);
                AbstractDataset abstractDataset = new IntegerDataset(nArray);
                int[] nArray2 = abstractDataset.getData();
                int n4 = 0;
                int n5 = 0;
                while (n4 < nArray2.length) {
                    nArray2[n4] = Utils.leInt((int)byArray[n5], (int)byArray[n5 + 1]);
                    ++n4;
                    n5 += 2;
                }
                if (abstractDataset.max().intValue() < 32768 || this.keepBitWidth) {
                    abstractDataset = DatasetUtils.cast(abstractDataset, 2);
                }
                abstractDataset.setMetadataMap(this.GDAMetadata);
                dataHolder.addDataset("ADSC Image", abstractDataset, this.GDAMetadata);
            }
            catch (Exception exception) {
                throw new ScanFileHolderException("There was a problem reading the ADSC image", exception);
            }
        }
        finally {
            try {
                randomAccessFile.close();
            }
            catch (IOException iOException) {
                throw new ScanFileHolderException("Problem closing ADSC file", iOException);
            }
        }
        return dataHolder;
    }

    private void processingMetadata(RandomAccessFile randomAccessFile) throws ScanFileHolderException {
        try {
            byte by = randomAccessFile.readByte();
            randomAccessFile.seek(0L);
            if (by != 123) {
                throw new ScanFileHolderException("This is not a valid ADSC image");
            }
            String string = randomAccessFile.readLine();
            while (!string.contains("{")) {
                string = randomAccessFile.readLine();
            }
            while (true) {
                if ((string = randomAccessFile.readLine()).contains("}")) {
                    this.createGDAMetatdata();
                    return;
                }
                if (string.contains("=")) {
                    String[] stringArray = string.split("=");
                    this.metadata.put(stringArray[0], stringArray[1].substring(0, stringArray[1].length() - 1));
                    continue;
                }
                this.extraHeaders.add(string);
            }
        }
        catch (IOException iOException) {
            throw new ScanFileHolderException("There was a problem parsing the ADSC header information", iOException);
        }
    }

    private void createGDAMetatdata() throws ScanFileHolderException {
        try {
            double d = Double.parseDouble(this.getMetadataValue("PIXEL_SIZE"));
            double[] dArray = new double[]{(double)Integer.parseInt(this.getMetadataValue("SIZE1")) * d - Double.parseDouble(this.getMetadataValue("BEAM_CENTER_X")), (double)Integer.parseInt(this.getMetadataValue("SIZE2")) * d - Double.parseDouble(this.getMetadataValue("BEAM_CENTER_Y")), Double.parseDouble(this.getMetadataValue("DISTANCE"))};
            this.GDAMetadata.put("NXdetector:NXgeometery:NXtranslation", dArray);
            this.GDAMetadata.put("NXdetector:NXgeometery:NXtranslation:NXunits", "milli*meter");
            double[] dArray2 = new double[]{1.0, 0.0, 0.0, 0.0, 1.0, 0.0};
            this.GDAMetadata.put("NXdetector:NXgeometery:NXorientation", dArray2);
            double[] dArray3 = new double[]{Double.parseDouble(this.getMetadataValue("SIZE1")) * Double.parseDouble(this.getMetadataValue("PIXEL_SIZE")), Double.parseDouble(this.getMetadataValue("SIZE2")) * Double.parseDouble(this.getMetadataValue("PIXEL_SIZE")), 0.0, 0.0, 0.0, 0.0};
            this.GDAMetadata.put("NXdetector:NXgeometery:NXshape", dArray3);
            this.GDAMetadata.put("NXdetector:NXgeometery:NXshape:NXshape", "milli*metre");
            double[] dArray4 = new double[]{Double.parseDouble(this.getMetadataValue("PIXEL_SIZE")), Double.parseDouble(this.getMetadataValue("PIXEL_SIZE"))};
            this.GDAMetadata.put("NXdetector:x_pixel_size", dArray4[0]);
            this.GDAMetadata.put("NXdetector:x_pixel_size:NXunits", "milli*metre");
            this.GDAMetadata.put("NXdetector:y_pixel_size", dArray4[1]);
            this.GDAMetadata.put("NXdetector:y_pixel_size:NXunits", "milli*metre");
            this.GDAMetadata.put("NXmonochromator:wavelength", Double.parseDouble(this.getMetadataValue("WAVELENGTH")));
            this.GDAMetadata.put("NXmonochromator:wavelength:NXunits", "Angstrom");
            this.GDAMetadata.put("NXSample:rotation_start", Double.parseDouble(this.getMetadataValue("OSC_START")));
            this.GDAMetadata.put("NXSample:rotation_start:NXUnits", "degree");
            this.GDAMetadata.put("NXSample:rotation_range", Double.parseDouble(this.getMetadataValue("OSC_RANGE")));
            this.GDAMetadata.put("NXSample:rotation_range:NXUnits", "degree");
            this.GDAMetadata.put("NXSample:exposure_time", Double.parseDouble(this.getMetadataValue("TIME")));
            this.GDAMetadata.put("NXSample:exposure_time:NXUnits", "seconds");
        }
        catch (NumberFormatException numberFormatException) {
            throw new ScanFileHolderException("There was a problem parsing numerical value from string", numberFormatException);
        }
        catch (ScanFileHolderException scanFileHolderException) {}
    }

    private String getMetadataValue(String string) throws ScanFileHolderException {
        try {
            String string2 = this.metadata.get(string);
            return string2;
        }
        catch (Exception exception) {
            throw new ScanFileHolderException("The keyword " + string + " was not found in the ADSC Header", exception);
        }
    }
}

