/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.diffraction;

import java.util.ArrayList;
import javax.vecmath.Matrix3d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;
import uk.ac.diamond.scisoft.analysis.diffraction.DetectorProperties;
import uk.ac.diamond.scisoft.analysis.diffraction.DiffractionCrystalEnvironment;
import uk.ac.diamond.scisoft.analysis.diffraction.QSpace;

public class Resolution {
    public static double[] peakDistances(int[] nArray, DetectorProperties detectorProperties, DiffractionCrystalEnvironment diffractionCrystalEnvironment) throws Exception {
        if (nArray.length % 2 != 0) {
            throw new IllegalArgumentException("The number of xy values does not match the number of points selected");
        }
        double[] dArray = new double[nArray.length];
        int n = 0;
        while (n < nArray.length) {
            dArray[n] = nArray[n];
            dArray[n + 1] = nArray[n + 1];
            n += 2;
        }
        return Resolution.peakDistances(dArray, detectorProperties, diffractionCrystalEnvironment);
    }

    public static double[] peakDistances(double[] dArray, DetectorProperties detectorProperties, DiffractionCrystalEnvironment diffractionCrystalEnvironment) throws Exception {
        Object object;
        Object object2;
        if (dArray.length % 2 != 0) {
            throw new IllegalArgumentException("The number of xy values does not match the number of points selected");
        }
        ArrayList<double[]> arrayList = new ArrayList<double[]>();
        arrayList.add(new double[]{dArray[0], dArray[1]});
        int n = 2;
        while (n < dArray.length) {
            double[] dArray2 = new double[]{dArray[n], dArray[n + 1]};
            boolean bl = true;
            object2 = arrayList.iterator();
            while (object2.hasNext()) {
                object = (double[])object2.next();
                if (dArray2[0] != object[0] || dArray2[1] != object[1]) continue;
                bl = false;
                break;
            }
            if (bl) {
                arrayList.add(dArray2);
            }
            n += 2;
        }
        n = arrayList.size() - 1;
        Vector3d vector3d = new Vector3d();
        object = new QSpace(detectorProperties, diffractionCrystalEnvironment);
        object2 = new double[n];
        int n2 = 0;
        while (n2 < n) {
            double[] dArray3 = (double[])arrayList.get(n2);
            double[] dArray4 = (double[])arrayList.get(n2 + 1);
            vector3d.sub((Tuple3d)((QSpace)object).qFromPixelPosition(dArray3[0], dArray3[1]), (Tuple3d)((QSpace)object).qFromPixelPosition(dArray4[0], dArray4[1]));
            object2[n2] = Math.PI * 2 / vector3d.length();
            ++n2;
        }
        return object2;
    }

    @Deprecated
    public static int[] resolutionRingRaytrace(DetectorProperties detectorProperties, DiffractionCrystalEnvironment diffractionCrystalEnvironment, double d) {
        int n = 720;
        double d2 = Math.asin(diffractionCrystalEnvironment.getWavelength() / (2.0 * d));
        Vector3d vector3d = new Vector3d(0.0, Math.sin(d2), Math.cos(d2));
        vector3d.normalize();
        int n2 = 0;
        int[] nArray = new int[n * 2];
        Vector3d vector3d2 = detectorProperties.getBeamVector();
        Vector3d vector3d3 = new Vector3d();
        vector3d3.sub((Tuple3d)vector3d2, (Tuple3d)new Vector3d(0.0, 0.0, 1.0));
        Matrix3d matrix3d = new Matrix3d();
        matrix3d.setIdentity();
        Vector3d vector3d4 = new Vector3d();
        Vector3d vector3d5 = detectorProperties.getNormal();
        Vector3d vector3d6 = detectorProperties.getOrigin();
        int n3 = 0;
        while (n3 < n) {
            Vector3d vector3d7 = new Vector3d(vector3d);
            matrix3d.rotZ(Math.PI * 2 / (double)n * (double)n3);
            matrix3d.transform((Tuple3d)vector3d7);
            if (vector3d3.length() != 0.0) {
                vector3d7.add((Tuple3d)vector3d3);
            }
            double d3 = vector3d6.dot(vector3d5) / vector3d7.dot(vector3d5);
            vector3d7.scale(d3);
            vector3d4.sub((Tuple3d)vector3d7, (Tuple3d)vector3d6);
            double d4 = vector3d4.angle(detectorProperties.getHorizontalVector());
            double d5 = vector3d4.length() * Math.cos(d4);
            double d6 = vector3d4.angle(detectorProperties.getVerticalVector());
            double d7 = vector3d4.length() * Math.cos(d6);
            if (d5 <= detectorProperties.getDetectorSizeH() && d7 <= detectorProperties.getDetectorSizeV() && d5 > 0.0 && d7 > 0.0) {
                nArray[n2++] = (int)(d5 / detectorProperties.getHPxSize());
                nArray[n2++] = (int)(d7 / detectorProperties.getVPxSize());
            } else {
                nArray[n2++] = Integer.MAX_VALUE;
                nArray[n2++] = Integer.MAX_VALUE;
            }
            ++n3;
        }
        return nArray;
    }

    public static double circularResolutionRingRadius(DetectorProperties detectorProperties, DiffractionCrystalEnvironment diffractionCrystalEnvironment, double d) {
        double d2 = 2.0 * Math.asin(diffractionCrystalEnvironment.getWavelength() / (2.0 * d));
        Vector3d vector3d = new Vector3d(0.0, Math.sin(d2), Math.cos(d2));
        Vector3d vector3d2 = new Vector3d(detectorProperties.getBeamVector());
        Vector3d vector3d3 = detectorProperties.getNormal();
        vector3d.scale(detectorProperties.getOrigin().dot(vector3d3) / vector3d.dot(vector3d3));
        vector3d2.scale(detectorProperties.getOrigin().dot(vector3d3) / vector3d2.dot(vector3d3));
        vector3d.sub((Tuple3d)vector3d2);
        return vector3d.length() / detectorProperties.getVPxSize();
    }

    public static Vector3d pixelToPixelVector(DetectorProperties detectorProperties, int n, int n2, int n3, int n4) {
        Vector3d vector3d = new Vector3d();
        vector3d.sub((Tuple3d)detectorProperties.pixelPosition(n3, n4), (Tuple3d)detectorProperties.pixelPosition(n, n2));
        return vector3d;
    }
}

