/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.diffraction;

import gda.util.TestUtils;
import javax.vecmath.Matrix3d;
import javax.vecmath.Vector3d;
import org.junit.BeforeClass;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.diffraction.DetectorProperties;
import uk.ac.diamond.scisoft.analysis.diffraction.DiffractionCrystalEnvironment;
import uk.ac.diamond.scisoft.analysis.diffraction.QSpace;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.PNGSaver;

public class DetectorPropertiesTest {
    static int[] detectorCorners;
    static double pixelSize;
    static int[] imageSizePix;
    static Vector3d detectorOrigin;
    static Vector3d beamCentre;
    static Matrix3d orientationMatrix;
    static DetectorProperties det;
    static double lambda;
    private static String testScratchDirectoryName;
    private static String filePath;
    static double wavelength;
    static int[] ishape;
    static double[] pxdim;
    static double[] origin;
    static double ttheta;

    static {
        int[] nArray = new int[8];
        nArray[3] = 3072;
        nArray[4] = 3072;
        nArray[6] = 3072;
        nArray[7] = 3072;
        detectorCorners = nArray;
        pixelSize = 0.1026;
        imageSizePix = new int[]{3072, 3072};
        detectorOrigin = new Vector3d(157.44, 157.44, 329.8);
        beamCentre = new Vector3d(0.0, 0.0, 329.8);
        orientationMatrix = new Matrix3d(0.984657762021401, 0.017187265168157, -0.17364817766693, 0.012961831885909, 0.985184016468007, 0.171010071662834, 0.174014604574351, -0.170637192932859, 0.969846310392954);
        lambda = 1.001;
        filePath = "detectorproperties.png";
        wavelength = 1.4;
        ishape = new int[]{800, 400};
        pxdim = new double[]{0.2, 0.3};
        origin = new double[]{80.0, 60.0, 234.0};
        ttheta = Math.toRadians(11.5);
    }

    private static DoubleDataset makeDiffImage() {
        DoubleDataset doubleDataset = new DoubleDataset(ishape[1], ishape[0]);
        double d = origin[2] * Math.tan(ttheta);
        double d2 = 45.0;
        Matrix3d matrix3d = new Matrix3d();
        matrix3d.setIdentity();
        DetectorProperties detectorProperties = new DetectorProperties(new Vector3d(origin), ishape[1], ishape[0], pxdim[1], pxdim[0], matrix3d);
        DiffractionCrystalEnvironment diffractionCrystalEnvironment = new DiffractionCrystalEnvironment(wavelength);
        QSpace qSpace = new QSpace(detectorProperties, diffractionCrystalEnvironment);
        double d3 = 0.0;
        while (d3 < 360.0) {
            int n = (int)Math.floor((origin[0] + d * Math.cos(Math.toRadians(d3))) / pxdim[0]);
            int n2 = (int)Math.floor((origin[1] + d * Math.sin(Math.toRadians(d3))) / pxdim[1]);
            doubleDataset.set(d3 + 30.0, n2, n);
            System.out.println("Q: " + qSpace.qFromPixelPosition(n, n2) + "; value = " + (d3 + 30.0));
            d3 += d2;
        }
        return doubleDataset;
    }

    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
        testScratchDirectoryName = TestUtils.generateDirectorynameFromClassname((String)DetectorPropertiesTest.class.getCanonicalName());
        TestUtils.makeScratchDirectory((String)testScratchDirectoryName);
        DataHolder dataHolder = new DataHolder();
        DoubleDataset doubleDataset = DetectorPropertiesTest.makeDiffImage();
        dataHolder.addDataset("testing data", doubleDataset);
        new PNGSaver(String.valueOf(testScratchDirectoryName) + filePath).saveFile(dataHolder);
    }

    @Test
    public void testSetters() {
        DetectorProperties detectorProperties = new DetectorProperties();
        detectorProperties.setHPxSize(pixelSize);
        detectorProperties.setVPxSize(pixelSize);
        detectorProperties.setPx(imageSizePix[0]);
        detectorProperties.setPy(imageSizePix[1]);
        detectorProperties.setOrientation(orientationMatrix);
        detectorProperties.setOrigin(new Vector3d(50.0, 50.0, 300000.0));
    }
}

