/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset.function;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.vecmath.Vector3d;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.Maths;
import uk.ac.diamond.scisoft.analysis.dataset.function.DatasetToDatasetFunction;
import uk.ac.diamond.scisoft.analysis.diffraction.QSpace;

public class MapToQSpace
implements DatasetToDatasetFunction {
    private double qmax;
    private double qdel;
    private int qlen;
    private QSpace qspace;

    public MapToQSpace(QSpace qSpace, int n, double d) {
        this.qspace = qSpace;
        this.qlen = n;
        this.qmax = d;
        this.qdel = 2.0 * this.qmax / (double)this.qlen;
    }

    public MapToQSpace(QSpace qSpace, int n) {
        this(qSpace, n, qSpace.maxModQ());
    }

    public MapToQSpace(QSpace qSpace, double d, double d2) {
        this(qSpace, (int)(2.0 * Math.floor(d2 / d) + 1.0), d2);
    }

    @Override
    public List<AbstractDataset> value(IDataset ... iDatasetArray) {
        if (iDatasetArray.length == 0) {
            return null;
        }
        AbstractDataset abstractDataset = DatasetUtils.convertToAbstractDataset(iDatasetArray[0]);
        int[] nArray = abstractDataset.getShape();
        if (nArray.length != 2) {
            return null;
        }
        int[] nArray2 = new int[]{this.qlen, this.qlen, this.qlen};
        AbstractDataset abstractDataset2 = AbstractDataset.zeros(nArray2, abstractDataset.getDtype());
        int[] nArray3 = new int[3];
        new Vector3d();
        Vector3d vector3d = new Vector3d();
        new Vector3d();
        int n = 0;
        int[] nArray4 = new int[6];
        while (n < nArray[0] - 1) {
            int n2 = 0;
            while (n2 < nArray[1] - 1) {
                double d = this.calcSpan(n2, n, 1.0);
                this.vaabb(n2, n, d, nArray4);
                double d2 = abstractDataset2.getDouble(nArray3);
                abstractDataset2.set(d2 += Maths.getBilinear(abstractDataset, vector3d.y, vector3d.x), nArray3);
                ++n2;
            }
            ++n;
        }
        ArrayList<AbstractDataset> arrayList = new ArrayList<AbstractDataset>();
        arrayList.add(abstractDataset2);
        return arrayList;
    }

    private boolean qToVoxel(Vector3d vector3d, int[] nArray) {
        if (Math.abs(vector3d.x) > this.qmax || Math.abs(vector3d.y) > this.qmax || Math.abs(vector3d.z) > this.qmax) {
            return false;
        }
        nArray[0] = (int)Math.floor(vector3d.z / this.qdel + this.qmax);
        nArray[1] = (int)Math.floor(vector3d.y / this.qdel + this.qmax);
        nArray[2] = (int)Math.floor(vector3d.x / this.qdel + this.qmax);
        return true;
    }

    private double calcSpan(double d, double d2, double d3) {
        Vector3d vector3d = new Vector3d();
        Vector3d vector3d2 = new Vector3d();
        Vector3d vector3d3 = new Vector3d();
        Vector3d vector3d4 = new Vector3d();
        this.qspace.qFromPixelPosition(d, d2, vector3d);
        this.qspace.qFromPixelPosition(d + d3, d2, vector3d2);
        this.qspace.qFromPixelPosition(d, d2 + d3, vector3d3);
        this.qspace.qFromPixelPosition(d + d3, d2 + d3, vector3d4);
        if (this.isSurfaceSpanGreaterThanVoxel(vector3d, vector3d2, vector3d3, vector3d4)) {
            return d3;
        }
        double[] dArray = new double[]{this.calcSpan(d, d2, d3 /= 2.0), this.calcSpan(d + d3, d2, d3), this.calcSpan(d, d2 + d3, d3), this.calcSpan(d + d3, d2 + d3, d3)};
        Arrays.sort(dArray);
        return dArray[0];
    }

    private boolean isSurfaceSpanGreaterThanVoxel(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3, Vector3d vector3d4) {
        return this.checkEnds(vector3d, vector3d2) || this.checkEnds(vector3d2, vector3d3) || this.checkEnds(vector3d3, vector3d4) || this.checkEnds(vector3d4, vector3d);
    }

    private boolean checkEnds(Vector3d vector3d, Vector3d vector3d2) {
        return Math.abs(vector3d.x - vector3d2.x) > this.qdel || Math.abs(vector3d.y - vector3d2.y) > this.qdel || Math.abs(vector3d.z - vector3d2.z) > this.qdel;
    }

    private void vaabb(int n, int n2, double d, int[] nArray) {
        int n3 = (int)Math.ceil(1.0 / d);
        double d2 = n;
        double d3 = n2;
        Vector3d vector3d = new Vector3d();
        this.qspace.qFromPixelPosition(d2, d3, vector3d);
        int[] nArray2 = new int[3];
        this.qToVoxel(vector3d, nArray2);
        nArray[0] = nArray2[0];
        nArray[1] = nArray2[0] + 1;
        nArray[2] = nArray2[1];
        nArray[3] = nArray2[1] + 1;
        nArray[4] = nArray2[2];
        nArray[5] = nArray2[2] + 1;
        int n4 = 0;
        while (n4 < n3) {
            d3 = (double)n2 + (double)n4 * d;
            int n5 = 0;
            while (n5 < n3) {
                d2 = (double)n + (double)n5 * d;
                this.qspace.qFromPixelPosition(d2, d3, vector3d);
                this.qToVoxel(vector3d, nArray2);
                if (nArray2[0] < nArray[0]) {
                    nArray[0] = nArray2[0];
                }
                if (nArray2[0] >= nArray[1]) {
                    nArray[1] = nArray2[0] + 1;
                }
                if (nArray2[1] < nArray[2]) {
                    nArray[2] = nArray2[1];
                }
                if (nArray2[1] >= nArray[3]) {
                    nArray[3] = nArray2[1] + 1;
                }
                if (nArray2[2] < nArray[4]) {
                    nArray[4] = nArray2[2];
                }
                if (nArray2[2] >= nArray[5]) {
                    nArray[5] = nArray2[2] + 1;
                }
                ++n5;
            }
            ++n4;
        }
    }
}

