/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset.function;

import java.util.ArrayList;
import java.util.List;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.Maths;
import uk.ac.diamond.scisoft.analysis.dataset.function.DatasetToDatasetFunction;

public class MapToPolarAndIntegrate
implements DatasetToDatasetFunction {
    double cx;
    double cy;
    double srad;
    double sphi;
    double erad;
    double ephi;

    public MapToPolarAndIntegrate(double d, double d2, double d3, double d4, double d5, double d6) {
        this(d, d2, d3, d4, d5, d6, true);
    }

    public MapToPolarAndIntegrate(double d, double d2, double d3, double d4, double d5, double d6, boolean bl) {
        this.cx = d;
        this.cy = d2;
        this.srad = d3;
        this.erad = d5;
        if (bl) {
            this.sphi = Math.toRadians(d4);
            this.ephi = Math.toRadians(d6);
        } else {
            this.sphi = d4;
            this.ephi = d6;
        }
        if (this.sphi > this.ephi) {
            double d7 = this.sphi;
            this.sphi = this.ephi;
            this.ephi = d7;
        }
    }

    @Override
    public List<AbstractDataset> value(IDataset ... iDatasetArray) {
        if (iDatasetArray.length == 0) {
            return null;
        }
        ArrayList<AbstractDataset> arrayList = new ArrayList<AbstractDataset>();
        IDataset[] iDatasetArray2 = iDatasetArray;
        int n = iDatasetArray.length;
        int n2 = 0;
        while (n2 < n) {
            IDataset iDataset = iDatasetArray2[n2];
            if (iDataset.getRank() != 2) {
                throw new IllegalArgumentException("operating on 2d arrays only");
            }
            double d = 1.0 / this.erad;
            int n3 = (int)Math.ceil(this.erad - this.srad);
            int n4 = (int)Math.ceil((this.ephi - this.sphi) / d);
            if (n3 == 0) {
                n3 = 1;
            }
            if (n4 == 0) {
                n4 = 1;
            }
            int n5 = AbstractDataset.getBestFloatDType(iDataset.elementClass());
            AbstractDataset abstractDataset = AbstractDataset.zeros(new int[]{n3}, n5);
            AbstractDataset abstractDataset2 = AbstractDataset.zeros(new int[]{n4}, n5);
            AbstractDataset abstractDataset3 = AbstractDataset.zeros(abstractDataset);
            AbstractDataset abstractDataset4 = AbstractDataset.zeros(abstractDataset2);
            int n6 = 0;
            while (n6 < n3) {
                double d2 = this.srad + (double)n6;
                double d3 = d * d2;
                double d4 = 0.0;
                int n7 = 0;
                while (n7 < n4) {
                    double d5 = this.sphi + (double)n7 * d;
                    double d6 = this.cx + d2 * Math.cos(d5);
                    double d7 = this.cy + d2 * Math.sin(d5);
                    double d8 = d3 * Maths.getBilinear(iDataset, d7, d6);
                    d4 += d8;
                    abstractDataset2.set(d8 + abstractDataset2.getDouble(n7), n7++);
                }
                abstractDataset.set(d4, n6);
                abstractDataset3.set(d3, n6++);
            }
            abstractDataset4.fill(abstractDataset3.sum());
            abstractDataset3.imultiply(n4);
            arrayList.add(abstractDataset2);
            arrayList.add(abstractDataset);
            arrayList.add(abstractDataset4);
            arrayList.add(abstractDataset3);
            ++n2;
        }
        return arrayList;
    }
}

