/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset.function;

import java.util.List;
import junit.framework.TestCase;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;
import uk.ac.diamond.scisoft.analysis.dataset.function.Downsample;
import uk.ac.diamond.scisoft.analysis.dataset.function.DownsampleMode;

public class DownsampleTest
extends TestCase {
    AbstractDataset d;

    public void setUp() {
        this.d = AbstractDataset.arange(24.0, 5);
        this.d.setShape(4, 6);
    }

    @Test
    public void testDownsamplePoint() {
        Downsample downsample = new Downsample(DownsampleMode.POINT, 2, 3);
        List<AbstractDataset> list = downsample.value(this.d);
        double[] dArray = new double[]{0.0, 3.0, 12.0, 15.0};
        AbstractDataset abstractDataset = list.get(0);
        IndexIterator indexIterator = abstractDataset.getIterator();
        int n = 0;
        while (indexIterator.hasNext()) {
            DownsampleTest.assertEquals((double)dArray[n], (double)abstractDataset.getElementDoubleAbs(indexIterator.index), (double)1.0E-6);
            ++n;
        }
    }

    @Test
    public void testDownsampleMean() {
        Downsample downsample = new Downsample(DownsampleMode.MEAN, 2, 3);
        List<AbstractDataset> list = downsample.value(this.d);
        double[] dArray = new double[]{4.0, 7.0, 16.0, 19.0};
        AbstractDataset abstractDataset = list.get(0);
        IndexIterator indexIterator = abstractDataset.getIterator();
        int n = 0;
        while (indexIterator.hasNext()) {
            DownsampleTest.assertEquals((double)dArray[n], (double)abstractDataset.getElementDoubleAbs(indexIterator.index), (double)1.0E-6);
            ++n;
        }
    }

    @Test
    public void testDownsampleMax() {
        Downsample downsample = new Downsample(DownsampleMode.MAXIMUM, 2, 3);
        List<AbstractDataset> list = downsample.value(this.d);
        double[] dArray = new double[]{8.0, 11.0, 20.0, 23.0};
        AbstractDataset abstractDataset = list.get(0);
        IndexIterator indexIterator = abstractDataset.getIterator();
        int n = 0;
        while (indexIterator.hasNext()) {
            DownsampleTest.assertEquals((double)dArray[n], (double)abstractDataset.getElementDoubleAbs(indexIterator.index), (double)1.0E-6);
            ++n;
        }
    }

    @Test
    public void testDownsampleMin() {
        Downsample downsample = new Downsample(DownsampleMode.MINIMUM, 2, 3);
        List<AbstractDataset> list = downsample.value(this.d);
        double[] dArray = new double[]{0.0, 3.0, 12.0, 15.0};
        AbstractDataset abstractDataset = list.get(0);
        IndexIterator indexIterator = abstractDataset.getIterator();
        int n = 0;
        while (indexIterator.hasNext()) {
            DownsampleTest.assertEquals((double)dArray[n], (double)abstractDataset.getElementDoubleAbs(indexIterator.index), (double)1.0E-6);
            ++n;
        }
    }

    @Test
    public void testBreak() {
        Downsample downsample = new Downsample(DownsampleMode.MEAN, 5, 7, 2);
        List<AbstractDataset> list = downsample.value(this.d);
        double[] dArray = new double[]{11.5};
        AbstractDataset abstractDataset = list.get(0);
        IndexIterator indexIterator = abstractDataset.getIterator();
        int n = 0;
        while (indexIterator.hasNext()) {
            DownsampleTest.assertEquals((double)dArray[n], (double)abstractDataset.getElementDoubleAbs(indexIterator.index), (double)1.0E-6);
            ++n;
        }
    }
}

