/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import java.util.Arrays;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;

public class SliceIterator
extends IndexIterator {
    final int[] shape;
    final int endrank;
    final int[] gap;
    final int imax;
    final int[] start;
    final int[] stop;
    final int[] step;
    final int[] sshape;
    int[] pos;
    int istep;

    public SliceIterator(int[] nArray, int n, int[] nArray2) {
        this(nArray, n, null, null, nArray2, 1);
    }

    public SliceIterator(int[] nArray, int n, int[] nArray2, int[] nArray3) {
        this(nArray, n, nArray2, null, nArray3, 1);
    }

    public SliceIterator(int[] nArray, int n, int[] nArray2, int n2) {
        this(nArray, n, null, null, nArray2, n2);
    }

    public SliceIterator(int[] nArray, int n, int[] nArray2, int[] nArray3, int n2) {
        this(nArray, n, nArray2, null, nArray3, n2);
    }

    public SliceIterator(int[] nArray, int n, int[] nArray2, int[] nArray3, int[] nArray4) {
        this(nArray, n, nArray2, nArray3, nArray4, 1);
    }

    public SliceIterator(int[] nArray, int n, int[] nArray2, int[] nArray3, int[] nArray4, int n2) {
        int n3 = nArray.length;
        this.endrank = n3 - 1;
        this.shape = nArray;
        this.start = nArray2 == null ? new int[n3] : nArray2;
        this.sshape = nArray4;
        if (nArray3 == null) {
            this.step = new int[n3];
            Arrays.fill(this.step, 1);
        } else {
            this.step = nArray3;
        }
        this.istep = this.step[this.endrank];
        this.pos = Arrays.copyOf(nArray2, n3);
        int n4 = this.endrank;
        this.pos[n4] = this.pos[n4] - this.istep;
        this.istep *= n2;
        this.imax = n * n2;
        this.stop = new int[n3];
        this.index = this.pos[0];
        int n5 = 1;
        while (n5 <= this.endrank) {
            this.index = this.index * nArray[n5] + this.pos[n5];
            ++n5;
        }
        this.index *= n2;
        this.gap = new int[this.endrank + 1];
        n5 = n2;
        int n6 = this.endrank;
        while (n6 >= 0) {
            this.stop[n6] = this.start[n6] + nArray4[n6] * this.step[n6];
            if (this.step[n6] < 0) {
                int n7 = n6;
                this.stop[n7] = this.stop[n7] + 1;
            }
            if (n6 > 0) {
                this.gap[n6] = (nArray[n6] * this.step[n6 - 1] - nArray4[n6] * this.step[n6]) * n5;
                n5 *= nArray[n6];
            }
            --n6;
        }
    }

    @Override
    public boolean hasNext() {
        int n = this.endrank;
        while (n >= 0) {
            int n2 = n;
            this.pos[n2] = this.pos[n2] + this.step[n];
            if (this.pos[n] >= this.stop[n] != this.step[n] > 0) break;
            this.pos[n] = this.start[n];
            this.index += this.gap[n];
            --n;
        }
        if (n == -1) {
            this.index = this.imax;
            return false;
        }
        this.index += this.istep;
        return this.index < this.imax;
    }

    @Override
    public int[] getPos() {
        return this.pos;
    }

    public int[] getStart() {
        return this.start;
    }

    public int[] getStop() {
        return this.stop;
    }

    public int[] getStep() {
        return this.step;
    }

    public int[] getGap() {
        return this.gap;
    }

    public int[] getShape() {
        return this.shape;
    }

    public int[] getSliceShape() {
        return this.sshape;
    }
}

