/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import org.apache.commons.math.random.MersenneTwister;
import org.apache.commons.math.random.RandomDataImpl;
import org.apache.commons.math.random.RandomGenerator;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerDataset;

public class Random {
    private static final RandomGenerator generator = new MersenneTwister();
    private static final RandomDataImpl prng = new RandomDataImpl(generator);

    public static void seed(int n) {
        generator.setSeed(n);
    }

    public static void seed(int[] nArray) {
        generator.setSeed(nArray);
    }

    public static void seed(long l) {
        generator.setSeed(l);
    }

    public static DoubleDataset rand(int ... nArray) {
        DoubleDataset doubleDataset = new DoubleDataset(nArray);
        double[] dArray = doubleDataset.getData();
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = generator.nextDouble();
            ++n;
        }
        return doubleDataset;
    }

    public static DoubleDataset rand(double d, double d2, int ... nArray) {
        DoubleDataset doubleDataset = new DoubleDataset(nArray);
        double[] dArray = doubleDataset.getData();
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = prng.nextUniform(d, d2);
            ++n;
        }
        return doubleDataset;
    }

    public static DoubleDataset randn(int ... nArray) {
        DoubleDataset doubleDataset = new DoubleDataset(nArray);
        double[] dArray = doubleDataset.getData();
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = generator.nextGaussian();
            ++n;
        }
        return doubleDataset;
    }

    public static DoubleDataset randn(double d, double d2, int ... nArray) {
        DoubleDataset doubleDataset = new DoubleDataset(nArray);
        double[] dArray = doubleDataset.getData();
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = prng.nextGaussian(d, d2);
            ++n;
        }
        return doubleDataset;
    }

    public static IntegerDataset randint(int n, int n2, int[] nArray) {
        return Random.random_integers(n, n2 - 1, nArray);
    }

    public static IntegerDataset random_integers(int n, int n2, int[] nArray) {
        IntegerDataset integerDataset = new IntegerDataset(nArray);
        int[] nArray2 = integerDataset.getData();
        if (n == n2) {
            int n3 = 0;
            while (n3 < nArray2.length) {
                nArray2[n3] = n;
                ++n3;
            }
        } else {
            int n4 = 0;
            while (n4 < nArray2.length) {
                nArray2[n4] = prng.nextInt(n, n2);
                ++n4;
            }
        }
        return integerDataset;
    }

    public static DoubleDataset exponential(double d, int ... nArray) {
        DoubleDataset doubleDataset = new DoubleDataset(nArray);
        double[] dArray = doubleDataset.getData();
        int n = 0;
        while (n < dArray.length) {
            dArray[n] = prng.nextExponential(d);
            ++n;
        }
        return doubleDataset;
    }

    public static IntegerDataset poisson(double d, int ... nArray) {
        IntegerDataset integerDataset = new IntegerDataset(nArray);
        int[] nArray2 = integerDataset.getData();
        int n = 0;
        while (n < nArray2.length) {
            nArray2[n] = (int)prng.nextPoisson(d);
            ++n;
        }
        return integerDataset;
    }
}

