/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import gda.data.nexus.extractor.NexusExtractor;
import gda.data.nexus.extractor.NexusExtractorException;
import gda.data.nexus.extractor.NexusGroupData;
import gda.data.nexus.tree.INexusSourceProvider;
import gda.data.nexus.tree.INexusTree;
import java.net.URL;
import org.nexusformat.NexusException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.Nexus;

public class NexusDataset {
    private static final transient Logger logger = LoggerFactory.getLogger(NexusDataset.class);
    private URL source;
    private String nodePath;
    private String name;
    private int[] trueShape;
    private int[] shape;
    private AbstractDataset groupDataset;

    public NexusDataset(INexusTree iNexusTree) {
        this.setNode(iNexusTree);
    }

    public void setNode(INexusTree iNexusTree) {
        INexusTree iNexusTree2 = iNexusTree;
        while (iNexusTree2.getParentNode() != null) {
            iNexusTree2 = iNexusTree2.getParentNode();
        }
        if (iNexusTree2 instanceof INexusSourceProvider) {
            this.source = ((INexusSourceProvider)iNexusTree2).getSource();
        }
        this.name = iNexusTree.getName();
        this.nodePath = iNexusTree.getNodePathWithClasses();
        NexusGroupData nexusGroupData = iNexusTree.getData();
        this.shape = (int[])nexusGroupData.dimensions.clone();
        this.trueShape = this.shape;
        this.groupDataset = nexusGroupData.getBuffer() == null ? null : Nexus.createDataset(nexusGroupData, false);
    }

    public static NexusDataset create(INexusTree iNexusTree) {
        return new NexusDataset(iNexusTree);
    }

    public String getName() {
        return this.name;
    }

    public int[] getShape() {
        if (this.groupDataset == null) {
            return this.shape;
        }
        return this.groupDataset.getShape();
    }

    public int getRank() {
        if (this.groupDataset == null) {
            return this.shape.length;
        }
        return this.groupDataset.getRank();
    }

    public void squeeze(boolean bl) {
        if (this.groupDataset == null) {
            int[] nArray = AbstractDataset.squeezeShape(this.shape, bl);
            if (nArray != null) {
                this.shape = nArray;
            }
        } else {
            this.groupDataset.squeeze(bl);
        }
    }

    public AbstractDataset getSlice(int[] nArray, int[] nArray2, int[] nArray3) {
        if (this.groupDataset == null) {
            int n = this.shape.length;
            if (nArray3 == null) {
                nArray3 = new int[n];
                int n2 = 0;
                while (n2 < n) {
                    nArray3[n2] = 1;
                    ++n2;
                }
            }
            if (nArray.length != n || nArray2.length != n || nArray3.length != n) {
                logger.error("");
                logger.error("Wrong number of indexes, you passed it start={}, stop={}, step={}, and it needs {}", (Object)new int[]{nArray.length, nArray2.length, nArray3.length, n});
                throw new IllegalArgumentException("No of indexes does not match data dimensions: you passed it start=" + nArray.length + ", stop=" + nArray2.length + ", step=" + nArray3.length + ", and it needs " + n);
            }
            NexusGroupData nexusGroupData = null;
            int[] nArray4 = new int[n];
            int n3 = 0;
            while (n3 < n) {
                nArray4[n3] = nArray2[n3] - nArray[n3];
                ++n3;
            }
            try {
                if (this.trueShape != this.shape) {
                    n3 = this.trueShape.length;
                    int[] nArray5 = new int[n3];
                    int[] nArray6 = new int[n3];
                    int n4 = 0;
                    int n5 = 0;
                    while (n5 < n3) {
                        if (this.trueShape[n5] == 1) {
                            nArray5[n5] = 0;
                            nArray6[n5] = 1;
                        } else {
                            nArray5[n5] = nArray[n4];
                            nArray6[n5] = nArray4[n4];
                            ++n4;
                        }
                        ++n5;
                    }
                    nexusGroupData = NexusExtractor.getNexusGroupData((URL)this.source, (String)this.nodePath, (int[])nArray5, (int[])nArray6, (boolean)logger.isDebugEnabled());
                    AbstractDataset abstractDataset = Nexus.createDataset(nexusGroupData, false);
                    abstractDataset.reshape(nArray4);
                    abstractDataset.setName(this.name);
                    return abstractDataset;
                }
                nexusGroupData = NexusExtractor.getNexusGroupData((URL)this.source, (String)this.nodePath, (int[])nArray, (int[])nArray4, (boolean)logger.isDebugEnabled());
                return Nexus.createDataset(nexusGroupData, false);
            }
            catch (NexusException nexusException) {
                nexusException.printStackTrace();
            }
            catch (NexusExtractorException nexusExtractorException) {
                nexusExtractorException.printStackTrace();
            }
        } else {
            return this.groupDataset.getSlice(nArray, nArray2, nArray3);
        }
        return null;
    }
}

