/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import edu.emory.mathcs.jtransforms.fft.DoubleFFT_1D;
import edu.emory.mathcs.jtransforms.fft.DoubleFFT_2D;
import edu.emory.mathcs.jtransforms.fft.DoubleFFT_3D;
import edu.emory.mathcs.jtransforms.fft.FloatFFT_1D;
import edu.emory.mathcs.jtransforms.fft.FloatFFT_2D;
import edu.emory.mathcs.jtransforms.fft.FloatFFT_3D;
import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractCompoundDataset;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ComplexDoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.ComplexFloatDataset;
import uk.ac.diamond.scisoft.analysis.dataset.PositionIterator;

public class FFT {
    protected static final transient Logger logger = LoggerFactory.getLogger(FFT.class);

    public static AbstractDataset fft(AbstractDataset abstractDataset) {
        return FFT.fft(abstractDataset, abstractDataset.shape[abstractDataset.shape.length - 1], -1);
    }

    public static AbstractDataset fft(AbstractDataset abstractDataset, int n, int n2) {
        if (n <= 0) {
            logger.error("number of points should be greater than zero");
            throw new IllegalArgumentException("number of points should be greater than zero");
        }
        n2 = abstractDataset.checkAxis(n2);
        return FFT.fft1d(abstractDataset, n, n2);
    }

    public static AbstractDataset fft2(AbstractDataset abstractDataset, int[] nArray, int[] nArray2) {
        int n = abstractDataset.getRank();
        if (n < 2) {
            logger.error("dataset should be at least 2 dimensional");
            throw new IllegalArgumentException("dataset should be at least 2 dimensional");
        }
        if (nArray2 == null) {
            nArray2 = new int[]{n - 2, n - 1};
        } else if (nArray2.length != 2) {
            logger.error("axes should have two entries");
            throw new IllegalArgumentException("axes should have two entries");
        }
        if (nArray == null) {
            nArray = new int[2];
            int[] nArray3 = abstractDataset.getShape();
            nArray[0] = nArray3[nArray2[0]];
            nArray[1] = nArray3[nArray2[1]];
        } else if (nArray.length < 2) {
            logger.error("shape should not have more than 2 dimensions");
            throw new IllegalArgumentException("shape should not have more than 2 dimensions");
        }
        return FFT.fftn(abstractDataset, nArray, nArray2);
    }

    public static AbstractDataset fftn(AbstractDataset abstractDataset, int[] nArray, int[] nArray2) {
        int n;
        int[] nArray3 = abstractDataset.getShape();
        int n2 = nArray3.length;
        AbstractDataset abstractDataset2 = null;
        if (nArray == null) {
            if (nArray2 == null) {
                nArray = nArray3;
                nArray2 = new int[n2];
                n = 0;
                while (n < n2) {
                    nArray2[n] = n;
                    ++n;
                }
            } else {
                nArray = new int[nArray2.length];
                Arrays.sort(nArray2);
                n = 0;
                while (n < nArray2.length) {
                    nArray2[n] = abstractDataset.checkAxis(nArray2[n]);
                    nArray[n] = nArray3[nArray2[n]];
                    ++n;
                }
            }
        } else {
            if (nArray.length > n2) {
                logger.error("shape of FFT should not have more dimensions than dataset");
                throw new IllegalArgumentException("shape of FFT should not have more dimensions than dataset");
            }
            if (nArray2 == null) {
                nArray2 = new int[nArray.length];
                n = 0;
                while (n < nArray.length) {
                    nArray2[n] = n2 - nArray.length + n;
                    ++n;
                }
            } else if (nArray.length != nArray2.length) {
                logger.error("shape of FFT should have same rank as axes");
                throw new IllegalArgumentException("shape of FFT should have same rank as axes");
            }
        }
        if (nArray.length > 3) {
            logger.error("Fourier transform across more than 3 dimensions are not supported");
            throw new IllegalArgumentException("Fourier transform across more than 3 dimensions are not supported");
        }
        n = 0;
        while (n < nArray2.length) {
            if (nArray[n] <= 0) {
                logger.error("dimensions should be greater than zero");
                throw new IllegalArgumentException("dimensions should be greater than zero");
            }
            nArray2[n] = abstractDataset.checkAxis(nArray2[n]);
            ++n;
        }
        switch (nArray.length) {
            case 1: {
                abstractDataset2 = FFT.fft1d(abstractDataset, nArray[0], nArray2[0]);
                break;
            }
            case 2: {
                abstractDataset2 = FFT.fft2d(abstractDataset, nArray, nArray2);
                break;
            }
            case 3: {
                abstractDataset2 = FFT.fft3d(abstractDataset, nArray, nArray2);
            }
        }
        return abstractDataset2;
    }

    private static int[] newShape(int[] nArray, int[] nArray2, int[] nArray3) {
        int[] nArray4 = (int[])nArray.clone();
        int n = 0;
        while (n < nArray2.length) {
            nArray4[nArray3[n]] = nArray2[n];
            ++n;
        }
        return nArray4;
    }

    private static AbstractDataset fft1d(AbstractDataset abstractDataset, int n, int n2) {
        AbstractCompoundDataset abstractCompoundDataset = null;
        AbstractCompoundDataset abstractCompoundDataset2 = null;
        switch (abstractDataset.getDtype()) {
            case 5: 
            case 7: {
                FloatFFT_1D floatFFT_1D = new FloatFFT_1D(n);
                int[] nArray = (int[])abstractDataset.getShape().clone();
                nArray[n2] = n;
                abstractCompoundDataset = new ComplexFloatDataset(nArray);
                abstractCompoundDataset2 = new ComplexFloatDataset(new int[]{2 * n});
                float[] fArray = (float[])abstractCompoundDataset2.odata;
                PositionIterator positionIterator = abstractDataset.getPositionIterator(n2);
                int[] nArray2 = positionIterator.getPos();
                boolean[] blArray = positionIterator.getOmit();
                while (positionIterator.hasNext()) {
                    Arrays.fill(fArray, 0.0f);
                    abstractDataset.copyItemsFromAxes(nArray2, blArray, abstractCompoundDataset2);
                    floatFFT_1D.complexForward(fArray);
                    abstractCompoundDataset.setItemsOnAxes(nArray2, blArray, fArray);
                }
                break;
            }
            case 6: 
            case 8: {
                DoubleFFT_1D doubleFFT_1D = new DoubleFFT_1D(n);
                int[] nArray = (int[])abstractDataset.getShape().clone();
                nArray[n2] = n;
                abstractCompoundDataset = new ComplexDoubleDataset(nArray);
                abstractCompoundDataset2 = new ComplexDoubleDataset(new int[]{2 * n});
                double[] dArray = (double[])abstractCompoundDataset2.odata;
                PositionIterator positionIterator = abstractDataset.getPositionIterator(n2);
                int[] nArray3 = positionIterator.getPos();
                boolean[] blArray = positionIterator.getOmit();
                while (positionIterator.hasNext()) {
                    Arrays.fill(dArray, 0.0);
                    abstractDataset.copyItemsFromAxes(nArray3, blArray, abstractCompoundDataset2);
                    doubleFFT_1D.complexForward(dArray);
                    abstractCompoundDataset.setItemsOnAxes(nArray3, blArray, dArray);
                }
                break;
            }
            default: {
                logger.warn("Non-float dataset not yet supported");
            }
        }
        return abstractCompoundDataset;
    }

    private static AbstractDataset fft2d(AbstractDataset abstractDataset, int[] nArray, int[] nArray2) {
        AbstractCompoundDataset abstractCompoundDataset = null;
        AbstractCompoundDataset abstractCompoundDataset2 = null;
        switch (abstractDataset.getDtype()) {
            case 5: 
            case 7: {
                FloatFFT_2D floatFFT_2D = new FloatFFT_2D(nArray[0], nArray[1]);
                float[] fArray = null;
                abstractCompoundDataset = new ComplexFloatDataset(FFT.newShape(abstractDataset.shape, nArray, nArray2));
                abstractCompoundDataset2 = new ComplexFloatDataset(nArray);
                fArray = (float[])abstractCompoundDataset2.odata;
                PositionIterator positionIterator = abstractDataset.getPositionIterator(nArray2);
                int[] nArray3 = positionIterator.getPos();
                boolean[] blArray = positionIterator.getOmit();
                while (positionIterator.hasNext()) {
                    Arrays.fill(fArray, 0.0f);
                    abstractDataset.copyItemsFromAxes(nArray3, blArray, abstractCompoundDataset2);
                    floatFFT_2D.complexForward(fArray);
                    abstractCompoundDataset.setItemsOnAxes(nArray3, blArray, fArray);
                }
                break;
            }
            case 6: 
            case 8: {
                DoubleFFT_2D doubleFFT_2D = new DoubleFFT_2D(nArray[0], nArray[1]);
                double[] dArray = null;
                abstractCompoundDataset = new ComplexDoubleDataset(FFT.newShape(abstractDataset.shape, nArray, nArray2));
                abstractCompoundDataset2 = new ComplexDoubleDataset(nArray);
                dArray = (double[])abstractCompoundDataset2.odata;
                PositionIterator positionIterator = abstractDataset.getPositionIterator(nArray2);
                int[] nArray4 = positionIterator.getPos();
                boolean[] blArray = positionIterator.getOmit();
                while (positionIterator.hasNext()) {
                    Arrays.fill(dArray, 0.0);
                    abstractDataset.copyItemsFromAxes(nArray4, blArray, abstractCompoundDataset2);
                    doubleFFT_2D.complexForward(dArray);
                    abstractCompoundDataset.setItemsOnAxes(nArray4, blArray, dArray);
                }
                break;
            }
            default: {
                logger.warn("Non-float dataset not yet supported");
            }
        }
        return abstractCompoundDataset;
    }

    private static AbstractDataset fft3d(AbstractDataset abstractDataset, int[] nArray, int[] nArray2) {
        AbstractCompoundDataset abstractCompoundDataset = null;
        AbstractCompoundDataset abstractCompoundDataset2 = null;
        switch (abstractDataset.getDtype()) {
            case 5: 
            case 7: {
                FloatFFT_3D floatFFT_3D = new FloatFFT_3D(nArray[0], nArray[1], nArray[2]);
                float[] fArray = null;
                abstractCompoundDataset = new ComplexFloatDataset(FFT.newShape(abstractDataset.shape, nArray, nArray2));
                abstractCompoundDataset2 = new ComplexFloatDataset(nArray);
                fArray = (float[])abstractCompoundDataset2.odata;
                PositionIterator positionIterator = abstractDataset.getPositionIterator(nArray2);
                int[] nArray3 = positionIterator.getPos();
                boolean[] blArray = positionIterator.getOmit();
                while (positionIterator.hasNext()) {
                    Arrays.fill(fArray, 0.0f);
                    abstractDataset.copyItemsFromAxes(nArray3, blArray, abstractCompoundDataset2);
                    floatFFT_3D.complexForward(fArray);
                    abstractCompoundDataset.setItemsOnAxes(nArray3, blArray, fArray);
                }
                break;
            }
            case 6: 
            case 8: {
                DoubleFFT_3D doubleFFT_3D = new DoubleFFT_3D(nArray[0], nArray[1], nArray[2]);
                double[] dArray = null;
                abstractCompoundDataset = new ComplexDoubleDataset(FFT.newShape(abstractDataset.shape, nArray, nArray2));
                abstractCompoundDataset2 = new ComplexDoubleDataset(nArray);
                dArray = (double[])abstractCompoundDataset2.odata;
                PositionIterator positionIterator = abstractDataset.getPositionIterator(nArray2);
                int[] nArray4 = positionIterator.getPos();
                boolean[] blArray = positionIterator.getOmit();
                while (positionIterator.hasNext()) {
                    Arrays.fill(dArray, 0.0);
                    abstractDataset.copyItemsFromAxes(nArray4, blArray, abstractCompoundDataset2);
                    doubleFFT_3D.complexForward(dArray);
                    abstractCompoundDataset.setItemsOnAxes(nArray4, blArray, dArray);
                }
                break;
            }
            default: {
                logger.warn("Non-float dataset not yet supported");
            }
        }
        return abstractCompoundDataset;
    }

    public static AbstractDataset ifft(AbstractDataset abstractDataset) {
        return FFT.ifft(abstractDataset, abstractDataset.shape[abstractDataset.shape.length - 1], -1);
    }

    public static AbstractDataset ifft(AbstractDataset abstractDataset, int n, int n2) {
        if (n <= 0) {
            logger.error("number of points should be greater than zero");
            throw new IllegalArgumentException("number of points should be greater than zero");
        }
        n2 = abstractDataset.checkAxis(n2);
        return FFT.ifft1d(abstractDataset, n, n2);
    }

    public static AbstractDataset ifft2(AbstractDataset abstractDataset, int[] nArray, int[] nArray2) {
        int n = abstractDataset.getRank();
        if (n < 2) {
            logger.error("dataset should be at least 2 dimensional");
            throw new IllegalArgumentException("dataset should be at least 2 dimensional");
        }
        if (nArray2 == null) {
            nArray2 = new int[]{n - 2, n - 1};
        } else if (nArray2.length != 2) {
            logger.error("axes should have two entries");
            throw new IllegalArgumentException("axes should have two entries");
        }
        if (nArray == null) {
            nArray = new int[2];
            int[] nArray3 = abstractDataset.getShape();
            nArray[0] = nArray3[nArray2[0]];
            nArray[1] = nArray3[nArray2[1]];
        } else if (nArray.length < 2) {
            logger.error("shape should not have more than 2 dimensions");
            throw new IllegalArgumentException("shape should not have more than 2 dimensions");
        }
        return FFT.ifftn(abstractDataset, nArray, nArray2);
    }

    public static AbstractDataset ifftn(AbstractDataset abstractDataset, int[] nArray, int[] nArray2) {
        int n;
        int[] nArray3 = abstractDataset.getShape();
        int n2 = nArray3.length;
        AbstractDataset abstractDataset2 = null;
        if (nArray == null) {
            if (nArray2 == null) {
                nArray = nArray3;
                nArray2 = new int[n2];
                n = 0;
                while (n < n2) {
                    nArray2[n] = n;
                    ++n;
                }
            } else {
                nArray = new int[nArray2.length];
                Arrays.sort(nArray2);
                n = 0;
                while (n < nArray2.length) {
                    nArray2[n] = abstractDataset.checkAxis(nArray2[n]);
                    nArray[n] = nArray3[nArray2[n]];
                    ++n;
                }
            }
        } else {
            if (nArray.length > n2) {
                logger.error("shape of FFT should not have more dimensions than dataset");
                throw new IllegalArgumentException("shape of FFT should not have more dimensions than dataset");
            }
            if (nArray2 == null) {
                nArray2 = new int[nArray.length];
                n = 0;
                while (n < nArray.length) {
                    nArray2[n] = n2 - nArray.length + n;
                    ++n;
                }
            } else if (nArray.length != nArray2.length) {
                logger.error("shape of FFT should have same rank as axes");
                throw new IllegalArgumentException("shape of FFT should have same rank as axes");
            }
        }
        if (nArray.length > 3) {
            logger.error("Fourier transform across more than 3 dimensions are not supported");
            throw new IllegalArgumentException("Fourier transform across more than 3 dimensions are not supported");
        }
        n = 0;
        while (n < nArray2.length) {
            if (nArray[n] <= 0) {
                logger.error("dimensions should be greater than zero");
                throw new IllegalArgumentException("dimensions should be greater than zero");
            }
            nArray2[n] = abstractDataset.checkAxis(nArray2[n]);
            ++n;
        }
        switch (nArray.length) {
            case 1: {
                abstractDataset2 = FFT.ifft1d(abstractDataset, nArray[0], nArray2[0]);
                break;
            }
            case 2: {
                abstractDataset2 = FFT.ifft2d(abstractDataset, nArray, nArray2);
                break;
            }
            case 3: {
                abstractDataset2 = FFT.ifft3d(abstractDataset, nArray, nArray2);
            }
        }
        return abstractDataset2;
    }

    private static AbstractDataset ifft1d(AbstractDataset abstractDataset, int n, int n2) {
        AbstractCompoundDataset abstractCompoundDataset = null;
        AbstractCompoundDataset abstractCompoundDataset2 = null;
        switch (abstractDataset.getDtype()) {
            case 7: {
                FloatFFT_1D floatFFT_1D = new FloatFFT_1D(n);
                float[] fArray = null;
                int[] nArray = (int[])abstractDataset.getShape().clone();
                nArray[n2] = n;
                abstractCompoundDataset = new ComplexFloatDataset(nArray);
                abstractCompoundDataset2 = new ComplexFloatDataset(new int[]{n});
                fArray = (float[])abstractCompoundDataset2.odata;
                PositionIterator positionIterator = abstractDataset.getPositionIterator(n2);
                int[] nArray2 = positionIterator.getPos();
                boolean[] blArray = positionIterator.getOmit();
                while (positionIterator.hasNext()) {
                    Arrays.fill(fArray, 0.0f);
                    abstractDataset.copyItemsFromAxes(nArray2, blArray, abstractCompoundDataset2);
                    floatFFT_1D.complexInverse(fArray, true);
                    abstractCompoundDataset.setItemsOnAxes(nArray2, blArray, fArray);
                }
                break;
            }
            case 8: {
                DoubleFFT_1D doubleFFT_1D = new DoubleFFT_1D(n);
                double[] dArray = null;
                int[] nArray = (int[])abstractDataset.getShape().clone();
                nArray[n2] = n;
                abstractCompoundDataset = new ComplexDoubleDataset(nArray);
                abstractCompoundDataset2 = new ComplexDoubleDataset(new int[]{n});
                dArray = (double[])abstractCompoundDataset2.odata;
                PositionIterator positionIterator = abstractDataset.getPositionIterator(n2);
                int[] nArray3 = positionIterator.getPos();
                boolean[] blArray = positionIterator.getOmit();
                while (positionIterator.hasNext()) {
                    Arrays.fill(dArray, 0.0);
                    abstractDataset.copyItemsFromAxes(nArray3, blArray, abstractCompoundDataset2);
                    doubleFFT_1D.complexInverse(dArray, true);
                    abstractCompoundDataset.setItemsOnAxes(nArray3, blArray, dArray);
                }
                break;
            }
            default: {
                logger.warn("Non-complex dataset not yet supported");
            }
        }
        return abstractCompoundDataset;
    }

    private static AbstractDataset ifft2d(AbstractDataset abstractDataset, int[] nArray, int[] nArray2) {
        AbstractCompoundDataset abstractCompoundDataset = null;
        AbstractCompoundDataset abstractCompoundDataset2 = null;
        switch (abstractDataset.getDtype()) {
            case 7: {
                FloatFFT_2D floatFFT_2D = new FloatFFT_2D(nArray[0], nArray[1]);
                float[] fArray = null;
                abstractCompoundDataset = new ComplexFloatDataset(FFT.newShape(abstractDataset.shape, nArray, nArray2));
                abstractCompoundDataset2 = new ComplexFloatDataset(nArray);
                fArray = (float[])abstractCompoundDataset2.odata;
                PositionIterator positionIterator = abstractDataset.getPositionIterator(nArray2);
                int[] nArray3 = positionIterator.getPos();
                boolean[] blArray = positionIterator.getOmit();
                while (positionIterator.hasNext()) {
                    Arrays.fill(fArray, 0.0f);
                    abstractDataset.copyItemsFromAxes(nArray3, blArray, abstractCompoundDataset2);
                    floatFFT_2D.complexInverse(fArray, true);
                    abstractCompoundDataset.setItemsOnAxes(nArray3, blArray, fArray);
                }
                break;
            }
            case 8: {
                DoubleFFT_2D doubleFFT_2D = new DoubleFFT_2D(nArray[0], nArray[1]);
                double[] dArray = null;
                abstractCompoundDataset = new ComplexDoubleDataset(FFT.newShape(abstractDataset.shape, nArray, nArray2));
                abstractCompoundDataset2 = new ComplexDoubleDataset(nArray);
                dArray = (double[])abstractCompoundDataset2.odata;
                PositionIterator positionIterator = abstractDataset.getPositionIterator(nArray2);
                int[] nArray4 = positionIterator.getPos();
                boolean[] blArray = positionIterator.getOmit();
                while (positionIterator.hasNext()) {
                    Arrays.fill(dArray, 0.0);
                    abstractDataset.copyItemsFromAxes(nArray4, blArray, abstractCompoundDataset2);
                    doubleFFT_2D.complexInverse(dArray, true);
                    abstractCompoundDataset.setItemsOnAxes(nArray4, blArray, dArray);
                }
                break;
            }
            default: {
                logger.warn("Non-complex dataset not yet supported");
            }
        }
        return abstractCompoundDataset;
    }

    private static AbstractDataset ifft3d(AbstractDataset abstractDataset, int[] nArray, int[] nArray2) {
        AbstractCompoundDataset abstractCompoundDataset = null;
        AbstractCompoundDataset abstractCompoundDataset2 = null;
        switch (abstractDataset.getDtype()) {
            case 7: {
                FloatFFT_3D floatFFT_3D = new FloatFFT_3D(nArray[0], nArray[1], nArray[2]);
                float[] fArray = null;
                abstractCompoundDataset = new ComplexFloatDataset(FFT.newShape(abstractDataset.shape, nArray, nArray2));
                abstractCompoundDataset2 = new ComplexFloatDataset(nArray);
                fArray = (float[])abstractCompoundDataset2.odata;
                PositionIterator positionIterator = abstractDataset.getPositionIterator(nArray2);
                int[] nArray3 = positionIterator.getPos();
                boolean[] blArray = positionIterator.getOmit();
                while (positionIterator.hasNext()) {
                    Arrays.fill(fArray, 0.0f);
                    abstractDataset.copyItemsFromAxes(nArray3, blArray, abstractCompoundDataset2);
                    floatFFT_3D.complexInverse(fArray, true);
                    abstractCompoundDataset.setItemsOnAxes(nArray3, blArray, fArray);
                }
                break;
            }
            case 8: {
                DoubleFFT_3D doubleFFT_3D = new DoubleFFT_3D(nArray[0], nArray[1], nArray[2]);
                double[] dArray = null;
                abstractCompoundDataset = new ComplexDoubleDataset(FFT.newShape(abstractDataset.shape, nArray, nArray2));
                abstractCompoundDataset2 = new ComplexDoubleDataset(nArray);
                dArray = (double[])abstractCompoundDataset2.odata;
                PositionIterator positionIterator = abstractDataset.getPositionIterator(nArray2);
                int[] nArray4 = positionIterator.getPos();
                boolean[] blArray = positionIterator.getOmit();
                while (positionIterator.hasNext()) {
                    Arrays.fill(dArray, 0.0);
                    abstractDataset.copyItemsFromAxes(nArray4, blArray, abstractCompoundDataset2);
                    doubleFFT_3D.complexInverse(dArray, true);
                    abstractCompoundDataset.setItemsOnAxes(nArray4, blArray, dArray);
                }
                break;
            }
            default: {
                logger.warn("Non-complex dataset not yet supported");
            }
        }
        return abstractCompoundDataset;
    }

    public static AbstractDataset fftshift(AbstractDataset abstractDataset, int[] nArray) {
        int n;
        int n2;
        if (nArray == null) {
            n2 = abstractDataset.getRank();
            nArray = new int[n2];
            n = 0;
            while (n < n2) {
                nArray[n] = n;
                ++n;
            }
        } else {
            n2 = nArray.length;
            n = 0;
            while (n < n2) {
                nArray[n] = abstractDataset.checkAxis(nArray[n]);
                ++n;
            }
        }
        AbstractDataset abstractDataset2 = abstractDataset;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray[n3];
            int n5 = abstractDataset.shape[n4];
            int n6 = (n5 + 1) / 2;
            logger.info("Shift {} by {}", (Object)n4, (Object)n6);
            int[] nArray2 = new int[n5];
            int n7 = 0;
            while (n7 < n5) {
                nArray2[n7] = n7 < n5 - n6 ? n6 + n7 : n7 - n5 + n6;
                ++n7;
            }
            abstractDataset2 = abstractDataset2.take(nArray2, n4);
            ++n3;
        }
        return abstractDataset2;
    }

    public static AbstractDataset ifftshift(AbstractDataset abstractDataset, int[] nArray) {
        int n;
        int n2;
        if (nArray == null) {
            n2 = abstractDataset.getRank();
            nArray = new int[n2];
            n = 0;
            while (n < n2) {
                nArray[n] = n;
                ++n;
            }
        } else {
            n2 = nArray.length;
            n = 0;
            while (n < n2) {
                nArray[n] = abstractDataset.checkAxis(nArray[n]);
                ++n;
            }
        }
        AbstractDataset abstractDataset2 = abstractDataset;
        int n3 = 0;
        while (n3 < n2) {
            int n4 = nArray[n3];
            int n5 = abstractDataset.shape[n4];
            int n6 = n5 - (n5 + 1) / 2;
            logger.info("Shift {} by {}", (Object)n4, (Object)n6);
            int[] nArray2 = new int[n5];
            int n7 = 0;
            while (n7 < n5) {
                nArray2[n7] = n7 < n5 - n6 ? n6 + n7 : n7 - n5 + n6;
                ++n7;
            }
            abstractDataset2 = abstractDataset2.take(nArray2, n4);
            ++n3;
        }
        return abstractDataset2;
    }
}

