/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;

public class DiscontiguousIterator
extends IndexIterator {
    private final int[] shape;
    private final int endrank;
    private final int[] gaps;
    private final int imax;
    private final int istep;
    private final int[] pos;

    public DiscontiguousIterator(int[] nArray, int[] nArray2, int n) {
        this(nArray, nArray2, n, 1);
    }

    public DiscontiguousIterator(int[] nArray, int[] nArray2, int n, int n2) {
        this.shape = nArray;
        this.endrank = nArray.length - 1;
        this.istep = n2;
        this.pos = new int[this.endrank + 1];
        this.pos[this.endrank] = -1;
        this.index = -n2;
        this.imax = n;
        this.gaps = new int[this.endrank + 1];
        int n3 = n2;
        int n4 = this.endrank;
        while (n4 >= 0) {
            this.gaps[n4] = (nArray2[n4] - nArray[n4]) * n3;
            n3 *= nArray2[n4];
            --n4;
        }
    }

    @Override
    public boolean hasNext() {
        int n = this.endrank;
        while (n >= 0) {
            int n2 = n;
            this.pos[n2] = this.pos[n2] + 1;
            if (this.pos[n] < this.shape[n]) break;
            this.pos[n] = 0;
            this.index += this.gaps[n];
            --n;
        }
        if (n == -1) {
            this.index = this.imax;
            return false;
        }
        this.index += this.istep;
        return this.index < this.imax;
    }

    @Override
    public int[] getPos() {
        return this.pos;
    }
}

