/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import java.util.Arrays;
import org.apache.commons.math.stat.descriptive.SummaryStatistics;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractCompoundDataset;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.BooleanDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerIterator;
import uk.ac.diamond.scisoft.analysis.dataset.ShortDataset;
import uk.ac.diamond.scisoft.analysis.dataset.SliceIterator;

public class CompoundShortDataset
extends AbstractCompoundDataset {
    private static final transient Logger compoundLogger = LoggerFactory.getLogger(CompoundShortDataset.class);
    protected short[] data;

    @Override
    protected void setData() {
        this.data = (short[])this.odata;
    }

    protected short[] createArray(int n) {
        short[] sArray = null;
        try {
            sArray = new short[this.isize * n];
        }
        catch (OutOfMemoryError outOfMemoryError) {
            compoundLogger.error("The size of the dataset that is being created is too large and there is not enough memory to hold it.");
            throw new OutOfMemoryError("The dimensions given are too large, and there is not enough memory available in the Java Virtual Machine");
        }
        return sArray;
    }

    @Override
    public int getDtype() {
        return 200;
    }

    public CompoundShortDataset() {
    }

    public CompoundShortDataset(int n) {
        this.isize = n;
    }

    public CompoundShortDataset(int n, int[] nArray) {
        this.isize = n;
        if (nArray.length == 1) {
            this.size = nArray[0];
            this.shape = (int[])nArray.clone();
            if (this.size > 0) {
                this.data = this.createArray(this.size);
                this.odata = this.data;
            } else if (this.size < 0) {
                compoundLogger.error("Negative component in shape is not allowed");
                throw new IllegalArgumentException("Negative component in shape is not allowed");
            }
        } else {
            this.size = CompoundShortDataset.calcSize(nArray);
            this.shape = (int[])nArray.clone();
            this.data = this.createArray(this.size);
            this.odata = this.data;
        }
    }

    public CompoundShortDataset(CompoundShortDataset compoundShortDataset) {
        this(compoundShortDataset, false);
    }

    public CompoundShortDataset(CompoundShortDataset compoundShortDataset, boolean bl) {
        this.isize = compoundShortDataset.isize;
        this.size = compoundShortDataset.size;
        if (bl) {
            this.shape = compoundShortDataset.shape;
            this.name = compoundShortDataset.name;
            this.data = compoundShortDataset.data;
            this.odata = compoundShortDataset.data;
            this.dataSize = compoundShortDataset.dataSize;
            this.dataShape = compoundShortDataset.dataShape;
            return;
        }
        this.shape = (int[])compoundShortDataset.shape.clone();
        this.name = new String(compoundShortDataset.name);
        short[] sArray = compoundShortDataset.data;
        if (compoundShortDataset.isContiguous()) {
            this.data = (short[])sArray.clone();
            this.odata = this.data;
        } else {
            this.data = this.createArray(this.size);
            this.odata = this.data;
            IndexIterator indexIterator = compoundShortDataset.getIterator();
            IndexIterator indexIterator2 = this.getIterator();
            while (indexIterator2.hasNext() && indexIterator.hasNext()) {
                this.data[indexIterator2.index] = sArray[indexIterator.index];
                this.data[indexIterator2.index + 1] = sArray[indexIterator.index + 1];
            }
        }
    }

    public CompoundShortDataset(int n, short[] sArray, int ... nArray) {
        this.isize = n;
        if (nArray == null || nArray.length == 0) {
            nArray = new int[]{sArray.length / this.isize};
        }
        this.size = CompoundShortDataset.calcSize(nArray);
        if (this.size * this.isize != sArray.length) {
            compoundLogger.error("Shape is not compatible with size of data array");
            throw new IllegalArgumentException("Shape is not compatible with size of data array");
        }
        this.shape = (int[])nArray.clone();
        this.data = sArray;
        this.odata = sArray;
    }

    public CompoundShortDataset(AbstractDataset ... abstractDatasetArray) {
        if (abstractDatasetArray.length <= 1) {
            compoundLogger.error("Array must have length greater than one");
            throw new IllegalArgumentException("Array must have length greater than one");
        }
        int n = 1;
        while (n < abstractDatasetArray.length) {
            abstractDatasetArray[0].checkCompatibility(abstractDatasetArray[n]);
            ++n;
        }
        this.isize = abstractDatasetArray.length;
        this.size = CompoundShortDataset.calcSize(abstractDatasetArray[0].shape);
        this.shape = (int[])abstractDatasetArray[0].shape.clone();
        this.data = this.createArray(this.size);
        this.odata = this.data;
        IndexIterator[] indexIteratorArray = new IndexIterator[this.isize];
        int n2 = 0;
        while (n2 < abstractDatasetArray.length) {
            indexIteratorArray[n2] = abstractDatasetArray[n2].getIterator();
            ++n2;
        }
        n2 = 0;
        while (indexIteratorArray[0].hasNext()) {
            this.data[n2++] = (short)abstractDatasetArray[0].getElementLongAbs(indexIteratorArray[0].index);
            int n3 = 1;
            while (n3 < abstractDatasetArray.length) {
                indexIteratorArray[n3].hasNext();
                this.data[n2++] = (short)abstractDatasetArray[n3].getElementLongAbs(indexIteratorArray[n3].index);
                ++n3;
            }
        }
    }

    public CompoundShortDataset(int n, AbstractDataset abstractDataset) {
        this.isize = n;
        this.size = abstractDataset.size;
        this.shape = (int[])abstractDataset.shape.clone();
        this.name = new String(abstractDataset.name);
        this.data = this.createArray(this.size);
        this.odata = this.data;
        IndexIterator indexIterator = abstractDataset.getIterator();
        int n2 = 0;
        while (indexIterator.hasNext()) {
            this.data[n2] = (short)abstractDataset.getElementLongAbs(indexIterator.index);
            n2 += this.isize;
        }
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        CompoundShortDataset compoundShortDataset = (CompoundShortDataset)object;
        return Arrays.equals(this.data, compoundShortDataset.data);
    }

    public static CompoundShortDataset createFromObject(Object object) {
        ShortDataset shortDataset = ShortDataset.createFromObject(object);
        return (CompoundShortDataset)DatasetUtils.createCompoundDatasetFromLastAxis(shortDataset, true);
    }

    public static CompoundShortDataset arange(int n, double d) {
        return CompoundShortDataset.arange(n, 0.0, d, 1.0);
    }

    public static CompoundShortDataset arange(int n, double d, double d2, double d3) {
        int n2 = CompoundShortDataset.calcSteps(d, d2, d3);
        CompoundShortDataset compoundShortDataset = new CompoundShortDataset(n, new int[]{n2});
        int n3 = 0;
        while (n3 < n2) {
            compoundShortDataset.data[n3 * compoundShortDataset.isize] = (short)(d + (double)n3 * d3);
            ++n3;
        }
        return compoundShortDataset;
    }

    public static CompoundShortDataset ones(int n, int[] nArray) {
        return new CompoundShortDataset(n, nArray).fill(1);
    }

    @Override
    public CompoundShortDataset fill(Object object) {
        IndexIterator indexIterator = this.getIterator();
        short[] sArray = CompoundShortDataset.toShortArray(object, this.isize);
        while (indexIterator.hasNext()) {
            int n = 0;
            while (n < this.isize) {
                this.data[indexIterator.index + n] = sArray[n];
                ++n;
            }
        }
        return this;
    }

    public short[] getData() {
        return this.data;
    }

    @Override
    public CompoundShortDataset getView() {
        CompoundShortDataset compoundShortDataset = new CompoundShortDataset(this.isize);
        compoundShortDataset.name = new String(this.name);
        compoundShortDataset.size = CompoundShortDataset.calcSize(this.shape);
        compoundShortDataset.shape = (int[])this.shape.clone();
        compoundShortDataset.data = this.data;
        compoundShortDataset.odata = this.data;
        return compoundShortDataset;
    }

    public short[] getAbs(int n) {
        short[] sArray = new short[this.isize];
        int n2 = 0;
        while (n2 < this.isize) {
            sArray[n2] = this.data[n + n2];
            ++n2;
        }
        return sArray;
    }

    @Override
    public boolean getElementBooleanAbs(int n) {
        int n2 = 0;
        while (n2 < this.isize) {
            if (this.data[n + n2] == 0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public double getElementDoubleAbs(int n) {
        return this.data[n];
    }

    @Override
    public long getElementLongAbs(int n) {
        return this.data[n];
    }

    @Override
    protected void setItemDirect(int n, int n2, Object object) {
        short[] sArray = (short[])object;
        int n3 = 0;
        while (n3 < this.isize) {
            this.data[n + n3] = sArray[n2 + n3];
            ++n3;
        }
    }

    public void setAbs(short[] sArray, int n) {
        int n2 = 0;
        while (n2 < this.isize) {
            this.data[n + n2] = sArray[n2];
            ++n2;
        }
        this.setDirty();
    }

    public void setAbs(short s, int n) {
        this.data[n] = s;
        this.setDirty();
    }

    @Override
    public Object getObject(int ... nArray) {
        return this.getShortArray(nArray);
    }

    public short[] getShortArray(int ... nArray) {
        int n = this.isize * this.get1DIndex(nArray);
        return (short[])this.getObjectAbs(n);
    }

    @Override
    public void getDoubleArray(double[] dArray, int ... nArray) {
        int n = this.isize * this.get1DIndex(nArray);
        int n2 = 0;
        while (n2 < this.isize) {
            dArray[n2] = this.data[n + n2];
            ++n2;
        }
    }

    @Override
    public String getString(int ... nArray) {
        int n = this.isize * this.get1DIndex(nArray);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('(');
        stringBuilder.append(String.format("%d", this.data[n]));
        int n2 = 1;
        while (n2 < this.isize) {
            stringBuilder.append(' ');
            stringBuilder.append(String.format("%d", this.data[n + n2]));
            ++n2;
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    protected double getFirstValue(int ... nArray) {
        int n = this.isize * this.get1DIndex(nArray);
        return this.data[n];
    }

    @Override
    public Object getObjectAbs(int n) {
        short[] sArray = new short[this.isize];
        int n2 = 0;
        while (n2 < this.isize) {
            sArray[n2] = this.data[n + n2];
            ++n2;
        }
        return sArray;
    }

    @Override
    public void setObjectAbs(Object object, int n) {
        short[] sArray = CompoundShortDataset.toShortArray(object, this.isize);
        this.setAbs(sArray, n);
    }

    @Override
    public void set(Object object, int ... nArray) {
        if (nArray == null || nArray.length == 0) {
            nArray = new int[this.shape.length];
        }
        this.setItem(CompoundShortDataset.toShortArray(object, this.isize), nArray);
    }

    public void setItem(short[] sArray, int ... nArray) {
        try {
            if (!this.isPositionInShape(nArray)) {
                try {
                    int[] nArray2 = (int[])this.shape.clone();
                    int n = 0;
                    while (n < nArray.length) {
                        if (nArray[n] >= nArray2[n]) {
                            nArray2[n] = nArray[n] + 1;
                        }
                        ++n;
                    }
                    this.allocateArray(nArray2);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    compoundLogger.error("This request is outside the array boundaries, and there is not enough memory to increase the dataset's size");
                    throw outOfMemoryError;
                }
            }
            if (sArray.length > this.isize) {
                compoundLogger.error("Array is larger than compound");
                throw new IllegalArgumentException("Array is larger than compound");
            }
            this.setAbs(sArray, this.isize * this.get1DIndex(nArray));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            compoundLogger.error("Cannot get value from dataset" + this + ". The number of indices is incorrect.");
            throw illegalArgumentException;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            compoundLogger.error("Index out of bounds");
            throw arrayIndexOutOfBoundsException;
        }
    }

    private void allocateArray(int ... nArray) {
        if (this.data == null) {
            compoundLogger.error("Data buffer in dataset is null");
            throw new IllegalStateException("Data buffer in dataset is null");
        }
        if (this.dataShape != null && this.isShapeInDataShape(nArray)) {
            this.shape = nArray;
            this.size = CompoundShortDataset.calcSize(this.shape);
            if (Arrays.equals(this.shape, this.dataShape)) {
                this.dataShape = null;
            }
            return;
        }
        IndexIterator indexIterator = this.getIterator();
        if (this.dataShape == null) {
            this.dataShape = (int[])this.shape.clone();
        }
        this.expandDataShape(nArray);
        this.dataSize = CompoundShortDataset.calcSize(this.dataShape);
        short[] sArray = this.createArray(this.dataSize);
        int[] nArray2 = this.shape;
        this.shape = nArray;
        this.size = CompoundShortDataset.calcSize(nArray);
        Arrays.fill(sArray, (short)Short.MIN_VALUE);
        IndexIterator indexIterator2 = this.getSliceIterator(null, nArray2, null);
        while (indexIterator2.hasNext() && indexIterator.hasNext()) {
            int n = 0;
            while (n < this.isize) {
                sArray[indexIterator2.index + n] = this.data[indexIterator.index + n];
                ++n;
            }
        }
        this.data = sArray;
        this.odata = sArray;
        if (this.dataSize == this.size) {
            this.dataShape = null;
        }
    }

    @Override
    public void resize(int ... nArray) {
        IndexIterator indexIterator = this.getIterator();
        int n = CompoundShortDataset.calcSize(nArray);
        short[] sArray = this.createArray(n);
        int n2 = 0;
        while (indexIterator.hasNext() && n2 < n) {
            int n3 = 0;
            while (n3 < this.isize) {
                sArray[n2++] = this.data[indexIterator.index + n3];
                ++n3;
            }
        }
        this.data = sArray;
        this.odata = sArray;
        this.size = n;
        this.shape = nArray;
        this.dataShape = null;
        this.dataSize = this.size;
    }

    @Override
    public ShortDataset real() {
        ShortDataset shortDataset = new ShortDataset(this.shape);
        IndexIterator indexIterator = this.getIterator();
        IndexIterator indexIterator2 = shortDataset.getIterator();
        short[] sArray = shortDataset.data;
        while (indexIterator.hasNext() && indexIterator2.hasNext()) {
            sArray[indexIterator2.index] = this.data[indexIterator.index];
        }
        return shortDataset;
    }

    @Override
    public Object sum() {
        if (this.storedValues == null) {
            this.calculateSummaryStats();
        }
        double[] dArray = new double[this.isize];
        int n = 0;
        while (n < this.isize) {
            dArray[n] = ((SummaryStatistics)this.storedValues.get("stats-" + n)).getSum();
            ++n;
        }
        return dArray;
    }

    @Override
    public Object mean() {
        if (this.storedValues == null) {
            this.calculateSummaryStats();
        }
        double[] dArray = new double[this.isize];
        int n = 0;
        while (n < this.isize) {
            dArray[n] = ((SummaryStatistics)this.storedValues.get("stats-" + n)).getMean();
            ++n;
        }
        return dArray;
    }

    @Override
    public CompoundShortDataset getSlice(int[] nArray, int[] nArray2, int[] nArray3) {
        SliceIterator sliceIterator = (SliceIterator)this.getSliceIterator(nArray, nArray2, nArray3);
        CompoundShortDataset compoundShortDataset = new CompoundShortDataset(this.isize, sliceIterator.getSliceShape());
        short[] sArray = compoundShortDataset.data;
        IndexIterator indexIterator = compoundShortDataset.getIterator();
        while (sliceIterator.hasNext() && indexIterator.hasNext()) {
            int n = 0;
            while (n < this.isize) {
                sArray[indexIterator.index + n] = this.data[sliceIterator.index + n];
                ++n;
            }
        }
        return compoundShortDataset;
    }

    @Override
    public AbstractDataset getElements(int n) {
        ShortDataset shortDataset = new ShortDataset(this.shape);
        this.copyElements(shortDataset, n);
        return shortDataset;
    }

    @Override
    public void copyElements(AbstractDataset abstractDataset, int n) {
        if (n < 0) {
            n += this.isize;
        }
        if (n < 0 || n > this.isize) {
            compoundLogger.error("Invalid choice of element: {}/{}", (Object)n, (Object)this.isize);
            throw new IllegalArgumentException("Invalid choice of element: " + n + "/" + this.isize);
        }
        if (this.elementClass() != abstractDataset.elementClass()) {
            compoundLogger.error("Element class of destination does not match this dataset");
            throw new IllegalArgumentException("Element class of destination does not match this dataset");
        }
        IndexIterator indexIterator = this.getIterator(n);
        short[] sArray = ((ShortDataset)abstractDataset).data;
        int n2 = 0;
        while (indexIterator.hasNext()) {
            sArray[n2] = this.data[indexIterator.index];
            ++n2;
        }
    }

    @Override
    public void setElements(AbstractDataset abstractDataset, int n) {
        if (n < 0) {
            n += this.isize;
        }
        if (n < 0 || n > this.isize) {
            compoundLogger.error("Invalid choice of element: {}/{}", (Object)n, (Object)this.isize);
            throw new IllegalArgumentException("Invalid choice of element: " + n + "/" + this.isize);
        }
        if (this.elementClass() != abstractDataset.elementClass()) {
            compoundLogger.error("Element class of destination does not match this dataset");
            throw new IllegalArgumentException("Element class of destination does not match this dataset");
        }
        IndexIterator indexIterator = this.getIterator(n);
        short[] sArray = ((ShortDataset)abstractDataset).data;
        if (abstractDataset.isContiguous()) {
            int n2 = 0;
            while (indexIterator.hasNext()) {
                this.data[indexIterator.index] = sArray[n2];
                ++n2;
            }
        } else {
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                this.data[indexIterator.index] = sArray[indexIterator2.index];
            }
        }
    }

    @Override
    public void fillDataset(AbstractDataset abstractDataset, IndexIterator indexIterator) {
        IndexIterator indexIterator2 = abstractDataset.getIterator();
        short[] sArray = ((CompoundShortDataset)abstractDataset).data;
        while (indexIterator2.hasNext() && indexIterator.hasNext()) {
            int n = 0;
            while (n < this.isize) {
                sArray[indexIterator2.index + n] = this.data[indexIterator.index + n];
                ++n;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CompoundShortDataset setByBoolean(BooleanDataset var1_1, Object var2_2) {
        block10: {
            block9: {
                if (!(var2_2 instanceof AbstractDataset)) break block9;
                var3_3 = (AbstractDataset)var2_2;
                var4_5 = ((Number)var1_1.sum()).intValue();
                if (var4_5 != var3_3.getSize()) {
                    CompoundShortDataset.compoundLogger.error("Number of true items in selection does not match number of items in dataset");
                    throw new IllegalArgumentException("Number of true items in selection does not match number of items in dataset");
                }
                var5_7 = var3_3.getIterator();
                var6_9 = this.getBooleanIterator(var1_1);
                if (!(var3_3 instanceof AbstractCompoundDataset)) ** GOTO lbl26
                if (this.isize == var3_3.getElementsPerItem()) ** GOTO lbl18
                CompoundShortDataset.compoundLogger.error("Input dataset is not compatible with slice");
                throw new IllegalArgumentException("Input dataset is not compatible with slice");
lbl-1000:
                // 1 sources

                {
                    var7_10 = 0;
                    while (var7_10 < this.isize) {
                        this.data[var6_9.index + var7_10] = (short)var3_3.getElementLongAbs(var5_7.index + var7_10);
                        ++var7_10;
                    }
lbl18:
                    // 2 sources

                    ** while (var6_9.hasNext() && var5_7.hasNext())
                }
lbl19:
                // 1 sources

                break block10;
lbl-1000:
                // 1 sources

                {
                    this.data[var6_9.index] = (short)var3_3.getElementLongAbs(var5_7.index);
                    var7_11 = 1;
                    while (var7_11 < this.isize) {
                        this.data[var6_9.index + var7_11] = 0;
                        ++var7_11;
                    }
lbl26:
                    // 2 sources

                    ** while (var6_9.hasNext() && var5_7.hasNext())
                }
lbl27:
                // 1 sources

                break block10;
            }
            try {
                var3_4 = CompoundShortDataset.toShortArray(var2_2, this.isize);
                var4_6 = this.getBooleanIterator(var1_1);
                while (var4_6.hasNext()) {
                    var5_8 = 0;
                    while (var5_8 < this.isize) {
                        this.data[var4_6.index + var5_8] = var3_4[var5_8];
                        ++var5_8;
                    }
                }
            }
            catch (IllegalArgumentException v0) {
                CompoundShortDataset.compoundLogger.error("Object for setting is not a dataset or number");
                throw new IllegalArgumentException("Object for setting is not a dataset or number");
            }
        }
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CompoundShortDataset setByIndex(IntegerDataset var1_1, Object var2_2) {
        block10: {
            block9: {
                if (!(var2_2 instanceof AbstractDataset)) break block9;
                var3_3 = (AbstractDataset)var2_2;
                if (var1_1.getSize() != var3_3.getSize()) {
                    CompoundShortDataset.compoundLogger.error("Number of true items in selection does not match number of items in dataset");
                    throw new IllegalArgumentException("Number of true items in selection does not match number of items in dataset");
                }
                var4_5 = var3_3.getIterator();
                var5_7 = new IntegerIterator(var1_1, this.size, this.isize);
                if (!(var3_3 instanceof AbstractCompoundDataset)) ** GOTO lbl25
                if (this.isize == var3_3.getElementsPerItem()) ** GOTO lbl17
                CompoundShortDataset.compoundLogger.error("Input dataset is not compatible with slice");
                throw new IllegalArgumentException("Input dataset is not compatible with slice");
lbl-1000:
                // 1 sources

                {
                    var6_9 = 0;
                    while (var6_9 < this.isize) {
                        this.data[var5_7.index + var6_9] = (short)var3_3.getElementLongAbs(var4_5.index + var6_9);
                        ++var6_9;
                    }
lbl17:
                    // 2 sources

                    ** while (var5_7.hasNext() && var4_5.hasNext())
                }
lbl18:
                // 1 sources

                break block10;
lbl-1000:
                // 1 sources

                {
                    this.data[var5_7.index] = (short)var3_3.getElementLongAbs(var4_5.index);
                    var6_10 = 1;
                    while (var6_10 < this.isize) {
                        this.data[var5_7.index + var6_10] = 0;
                        ++var6_10;
                    }
lbl25:
                    // 2 sources

                    ** while (var5_7.hasNext() && var4_5.hasNext())
                }
lbl26:
                // 1 sources

                break block10;
            }
            try {
                var3_4 = CompoundShortDataset.toShortArray(var2_2, this.isize);
                var4_6 = new IntegerIterator(var1_1, this.size, this.isize);
                while (var4_6.hasNext()) {
                    var5_8 = 0;
                    while (var5_8 < this.isize) {
                        this.data[var4_6.index + var5_8] = var3_4[var5_8];
                        ++var5_8;
                    }
                }
            }
            catch (IllegalArgumentException v0) {
                CompoundShortDataset.compoundLogger.error("Object for setting is not a dataset or number");
                throw new IllegalArgumentException("Object for setting is not a dataset or number");
            }
        }
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CompoundShortDataset setSlice(int[] var1_1, int[] var2_2, int[] var3_3, Object var4_4) {
        block11: {
            block10: {
                if (!(var4_4 instanceof AbstractDataset)) break block10;
                var5_5 = (SliceIterator)this.getSliceIterator(var1_1, var2_2, var3_3);
                var6_7 = (AbstractDataset)var4_4;
                var7_9 = CompoundShortDataset.squeezeShape(var5_5.getSliceShape(), false);
                if (var7_9 == null) {
                    var7_9 = var5_5.getSliceShape();
                }
                var8_11 = var6_7.getIterator();
                if (!Arrays.equals(var7_9, var6_7.shape)) {
                    CompoundShortDataset.compoundLogger.error("Input dataset is not compatible with slice");
                    throw new IllegalArgumentException("Input dataset is not compatible with slice");
                }
                if (!(var6_7 instanceof AbstractCompoundDataset)) ** GOTO lbl28
                if (this.isize == var6_7.getElementsPerItem()) ** GOTO lbl20
                CompoundShortDataset.compoundLogger.error("Input dataset is not compatible with slice");
                throw new IllegalArgumentException("Input dataset is not compatible with slice");
lbl-1000:
                // 1 sources

                {
                    var9_12 = 0;
                    while (var9_12 < this.isize) {
                        this.data[var5_5.index + var9_12] = (short)var6_7.getElementLongAbs(var8_11.index + var9_12);
                        ++var9_12;
                    }
lbl20:
                    // 2 sources

                    ** while (var5_5.hasNext() && var8_11.hasNext())
                }
lbl21:
                // 1 sources

                break block11;
lbl-1000:
                // 1 sources

                {
                    this.data[var5_5.index] = (short)var6_7.getElementLongAbs(var8_11.index);
                    var9_13 = 1;
                    while (var9_13 < this.isize) {
                        this.data[var5_5.index + var9_13] = 0;
                        ++var9_13;
                    }
lbl28:
                    // 2 sources

                    ** while (var5_5.hasNext() && var8_11.hasNext())
                }
lbl29:
                // 1 sources

                break block11;
            }
            try {
                var6_8 = CompoundShortDataset.toShortArray(var4_4, this.isize);
                var5_6 = (SliceIterator)this.getSliceIterator(var1_1, var2_2, var3_3);
                while (var5_6.hasNext()) {
                    var7_10 = 0;
                    while (var7_10 < this.isize) {
                        this.data[var5_6.index + var7_10] = var6_8[var7_10];
                        ++var7_10;
                    }
                }
            }
            catch (IllegalArgumentException v0) {
                CompoundShortDataset.compoundLogger.error("Object for setting slice is not a dataset or number");
                throw new IllegalArgumentException("Object for setting slice is not a dataset or number");
            }
        }
        this.setDirty();
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void copyItemsFromAxes(int[] var1_1, boolean[] var2_2, AbstractDataset var3_3) {
        var4_4 = (short[])var3_3.odata;
        if (var3_3.getElementsPerItem() != this.isize) {
            CompoundShortDataset.compoundLogger.error("Destination dataset is incompatible as it has {} elements per item not {}", (Object)var3_3.getElementsPerItem(), (Object)this.isize);
            throw new IllegalArgumentException("Destination dataset is incompatible as it has different number of elements per item");
        }
        var5_5 = this.getSliceIteratorFromAxes(var1_1, var2_2);
        var6_6 = CompoundShortDataset.squeezeShape(var5_5.getSliceShape(), false);
        if (var6_6 == null) {
            var6_6 = var5_5.getSliceShape();
        }
        var7_7 = var3_3.getSliceIterator(null, var6_6, null);
        if (var4_4.length >= CompoundShortDataset.calcSize(var6_6)) ** GOTO lbl18
        CompoundShortDataset.compoundLogger.error("destination array is not large enough");
        throw new IllegalArgumentException("destination array is not large enough");
lbl-1000:
        // 1 sources

        {
            var8_8 = 0;
            while (var8_8 < this.isize) {
                var4_4[var7_7.index + var8_8] = this.data[var5_5.index + var8_8];
                ++var8_8;
            }
lbl18:
            // 2 sources

            ** while (var5_5.hasNext() && var7_7.hasNext())
        }
lbl19:
        // 1 sources

    }

    @Override
    public void setItemsOnAxes(int[] nArray, boolean[] blArray, Object object) {
        short[] sArray = (short[])object;
        SliceIterator sliceIterator = this.getSliceIteratorFromAxes(nArray, blArray);
        if (sArray.length < CompoundShortDataset.calcSize(sliceIterator.getSliceShape())) {
            compoundLogger.error("source array is not large enough");
            throw new IllegalArgumentException("source array is not large enough");
        }
        int n = 0;
        while (sliceIterator.hasNext()) {
            int n2 = 0;
            while (n2 < this.isize) {
                this.data[sliceIterator.index + n2] = sArray[this.isize * n + n2];
                ++n2;
            }
            ++n;
        }
        this.setDirty();
    }

    @Override
    public boolean containsNans() {
        return false;
    }

    @Override
    public boolean containsInfs() {
        return false;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CompoundShortDataset iadd(Object var1_1) {
        block6: {
            block5: {
                if (!(var1_1 instanceof AbstractDataset)) break block5;
                var2_2 = (AbstractDataset)var1_1;
                this.checkCompatibility(var2_2);
                var3_4 = this.getIterator();
                var4_6 = var2_2.getIterator();
                if (var2_2.getElementsPerItem() == this.isize) ** GOTO lbl18
                while (var3_4.hasNext() && var4_6.hasNext()) {
                    v0 = var3_4.index;
                    this.data[v0] = (short)((long)this.data[v0] + var2_2.getElementLongAbs(var4_6.index));
                }
                break block6;
lbl-1000:
                // 1 sources

                {
                    var5_8 = 0;
                    while (var5_8 < this.isize) {
                        v1 = var3_4.index + var5_8;
                        this.data[v1] = (short)((long)this.data[v1] + var2_2.getElementLongAbs(var4_6.index + var5_8));
                        ++var5_8;
                    }
lbl18:
                    // 2 sources

                    ** while (var3_4.hasNext() && var4_6.hasNext())
                }
lbl19:
                // 1 sources

                break block6;
            }
            var2_3 = CompoundShortDataset.toShortArray(var1_1, this.isize);
            var3_5 = this.getIterator();
            while (var3_5.hasNext()) {
                var4_7 = 0;
                while (var4_7 < this.isize) {
                    v2 = var3_5.index + var4_7;
                    this.data[v2] = (short)(this.data[v2] + var2_3[var4_7]);
                    ++var4_7;
                }
            }
        }
        this.setDirty();
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CompoundShortDataset isubtract(Object var1_1) {
        block6: {
            block5: {
                if (!(var1_1 instanceof AbstractDataset)) break block5;
                var2_2 = (AbstractDataset)var1_1;
                this.checkCompatibility(var2_2);
                var3_4 = this.getIterator();
                var4_6 = var2_2.getIterator();
                if (var2_2.getElementsPerItem() == this.isize) ** GOTO lbl18
                while (var3_4.hasNext() && var4_6.hasNext()) {
                    v0 = var3_4.index;
                    this.data[v0] = (short)((long)this.data[v0] - var2_2.getElementLongAbs(var4_6.index));
                }
                break block6;
lbl-1000:
                // 1 sources

                {
                    var5_8 = 0;
                    while (var5_8 < this.isize) {
                        v1 = var3_4.index + var5_8;
                        this.data[v1] = (short)((long)this.data[v1] - var2_2.getElementLongAbs(var4_6.index + var5_8));
                        ++var5_8;
                    }
lbl18:
                    // 2 sources

                    ** while (var3_4.hasNext() && var4_6.hasNext())
                }
lbl19:
                // 1 sources

                break block6;
            }
            var2_3 = CompoundShortDataset.toShortArray(var1_1, this.isize);
            var3_5 = this.getIterator();
            while (var3_5.hasNext()) {
                var4_7 = 0;
                while (var4_7 < this.isize) {
                    v2 = var3_5.index + var4_7;
                    this.data[v2] = (short)(this.data[v2] - var2_3[var4_7]);
                    ++var4_7;
                }
            }
        }
        this.setDirty();
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CompoundShortDataset imultiply(Object var1_1) {
        block7: {
            block6: {
                if (!(var1_1 instanceof AbstractDataset)) break block6;
                var2_2 = (AbstractDataset)var1_1;
                this.checkCompatibility(var2_2);
                var3_4 = this.getIterator();
                var4_6 = var2_2.getIterator();
                if (var2_2.getElementsPerItem() == this.isize) ** GOTO lbl23
                while (var3_4.hasNext() && var4_6.hasNext()) {
                    var5_8 = (short)var2_2.getElementLongAbs(var4_6.index);
                    var6_10 = 0;
                    while (var6_10 < this.isize) {
                        v0 = var3_4.index + var6_10;
                        this.data[v0] = (short)(this.data[v0] * var5_8);
                        ++var6_10;
                    }
                }
                break block7;
lbl-1000:
                // 1 sources

                {
                    var5_9 = 0;
                    while (var5_9 < this.isize) {
                        v1 = var3_4.index + var5_9;
                        this.data[v1] = (short)((long)this.data[v1] * var2_2.getElementLongAbs(var4_6.index + var5_9));
                        ++var5_9;
                    }
lbl23:
                    // 2 sources

                    ** while (var3_4.hasNext() && var4_6.hasNext())
                }
lbl24:
                // 1 sources

                break block7;
            }
            var2_3 = CompoundShortDataset.toShortArray(var1_1, this.isize);
            var3_5 = this.getIterator();
            while (var3_5.hasNext()) {
                var4_7 = 0;
                while (var4_7 < this.isize) {
                    v2 = var3_5.index + var4_7;
                    this.data[v2] = (short)(this.data[v2] * var2_3[var4_7]);
                    ++var4_7;
                }
            }
        }
        this.setDirty();
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CompoundShortDataset idivide(Object var1_1) {
        block12: {
            block11: {
                if (!(var1_1 instanceof AbstractDataset)) break block11;
                var2_2 = (AbstractDataset)var1_1;
                this.checkCompatibility(var2_2);
                var3_4 = this.getIterator();
                var4_6 = var2_2.getIterator();
                if (var2_2.getElementsPerItem() == this.isize) ** GOTO lbl31
                while (var3_4.hasNext() && var4_6.hasNext()) {
                    var5_8 = (short)var2_2.getElementLongAbs(var4_6.index);
                    if (var5_8 == 0) {
                        this.fill(0);
                        continue;
                    }
                    var6_10 = 0;
                    while (var6_10 < this.isize) {
                        v0 = var3_4.index + var6_10;
                        this.data[v0] = (short)(this.data[v0] / var5_8);
                        ++var6_10;
                    }
                }
                break block12;
lbl-1000:
                // 1 sources

                {
                    var5_9 = 0;
                    while (var5_9 < this.isize) {
                        try {
                            v1 = var3_4.index + var5_9;
                            this.data[v1] = (short)((long)this.data[v1] / var2_2.getElementLongAbs(var4_6.index + var5_9));
                        }
                        catch (ArithmeticException v2) {
                            this.data[var3_4.index + var5_9] = 0;
                        }
                        ++var5_9;
                    }
lbl31:
                    // 2 sources

                    ** while (var3_4.hasNext() && var4_6.hasNext())
                }
lbl32:
                // 1 sources

                break block12;
            }
            var2_3 = CompoundShortDataset.toDoubleArray(var1_1, this.isize);
            var3_5 = this.getIterator();
            while (var3_5.hasNext()) {
                var4_7 = 0;
                while (var4_7 < this.isize) {
                    if (var2_3[var4_7] == 0.0) {
                        this.data[var3_5.index + var4_7] = 0;
                    } else {
                        v3 = var3_5.index + var4_7;
                        this.data[v3] = (short)((double)this.data[v3] / var2_3[var4_7]);
                    }
                    ++var4_7;
                }
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public CompoundShortDataset ifloor() {
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CompoundShortDataset iremainder(Object var1_1) {
        block12: {
            block11: {
                if (!(var1_1 instanceof AbstractDataset)) break block11;
                var2_2 = (AbstractDataset)var1_1;
                this.checkCompatibility(var2_2);
                var3_4 = this.getIterator();
                var4_6 = var2_2.getIterator();
                if (var2_2.getElementsPerItem() == this.isize) ** GOTO lbl31
                while (var3_4.hasNext() && var4_6.hasNext()) {
                    var5_8 = (short)var2_2.getElementLongAbs(var4_6.index);
                    if (var5_8 == 0) {
                        this.fill(0);
                        continue;
                    }
                    var6_10 = 0;
                    while (var6_10 < this.isize) {
                        v0 = var3_4.index + var6_10;
                        this.data[v0] = (short)(this.data[v0] % var5_8);
                        ++var6_10;
                    }
                }
                break block12;
lbl-1000:
                // 1 sources

                {
                    var5_9 = 0;
                    while (var5_9 < this.isize) {
                        try {
                            v1 = var3_4.index + var5_9;
                            this.data[v1] = (short)((long)this.data[v1] % var2_2.getElementLongAbs(var4_6.index + var5_9));
                        }
                        catch (ArithmeticException v2) {
                            this.data[var3_4.index + var5_9] = 0;
                        }
                        ++var5_9;
                    }
lbl31:
                    // 2 sources

                    ** while (var3_4.hasNext() && var4_6.hasNext())
                }
lbl32:
                // 1 sources

                break block12;
            }
            var2_3 = CompoundShortDataset.toDoubleArray(var1_1, this.isize);
            var3_5 = this.getIterator();
            while (var3_5.hasNext()) {
                var4_7 = 0;
                while (var4_7 < this.isize) {
                    if (var2_3[var4_7] == 0.0) {
                        this.data[var3_5.index + var4_7] = 0;
                    } else {
                        v3 = var3_5.index + var4_7;
                        this.data[v3] = (short)((double)this.data[v3] % var2_3[var4_7]);
                    }
                    ++var4_7;
                }
            }
        }
        this.setDirty();
        return this;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public CompoundShortDataset ipower(Object var1_1) {
        block6: {
            block5: {
                if (!(var1_1 instanceof AbstractDataset)) break block5;
                var2_2 = (AbstractDataset)var1_1;
                this.checkCompatibility(var2_2);
                var3_4 = this.getIterator();
                var4_6 = var2_2.getIterator();
                if (var2_2.getElementsPerItem() == this.isize) ** GOTO lbl18
                while (var3_4.hasNext() && var4_6.hasNext()) {
                    var5_8 = Math.pow(this.data[var3_4.index], var2_2.getElementDoubleAbs(var4_6.index));
                    this.data[var3_4.index] = Double.isInfinite(var5_8) != false || Double.isNaN(var5_8) != false ? 0 : (short)var5_8;
                }
                break block6;
lbl-1000:
                // 1 sources

                {
                    var5_9 = 0;
                    while (var5_9 < this.isize) {
                        var6_11 = Math.pow(this.data[var3_4.index + var5_9], var2_2.getElementDoubleAbs(var4_6.index + var5_9));
                        this.data[var3_4.index + var5_9] = Double.isInfinite(var6_11) != false || Double.isNaN(var6_11) != false ? 0 : (short)var6_11;
                        ++var5_9;
                    }
lbl18:
                    // 2 sources

                    ** while (var3_4.hasNext() && var4_6.hasNext())
                }
lbl19:
                // 1 sources

                break block6;
            }
            var2_3 = CompoundShortDataset.toShortArray(var1_1, this.isize);
            var3_5 = this.getIterator();
            while (var3_5.hasNext()) {
                var4_7 = 0;
                while (var4_7 < this.isize) {
                    var5_10 = Math.pow(this.data[var3_5.index + var4_7], var2_3[var4_7]);
                    this.data[var3_5.index + var4_7] = Double.isInfinite(var5_10) != false || Double.isNaN(var5_10) != false ? 0 : (short)var5_10;
                    ++var4_7;
                }
            }
        }
        this.setDirty();
        return this;
    }

    @Override
    public double residual(Object object) {
        double d = 0.0;
        if (object instanceof AbstractDataset) {
            AbstractDataset abstractDataset = (AbstractDataset)object;
            this.checkCompatibility(abstractDataset);
            IndexIterator indexIterator = this.getIterator();
            IndexIterator indexIterator2 = abstractDataset.getIterator();
            if (abstractDataset.getElementsPerItem() != this.isize) {
                double d2 = 0.0;
                while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                    double d3 = (double)this.data[indexIterator.index] - abstractDataset.getElementDoubleAbs(indexIterator2.index);
                    double d4 = d3 * d3 - d2;
                    double d5 = d + d4;
                    d2 = d5 - d - d4;
                    d = d5;
                }
            } else {
                double d6 = 0.0;
                while (indexIterator.hasNext() && indexIterator2.hasNext()) {
                    int n = 0;
                    while (n < this.isize) {
                        double d7 = (double)this.data[indexIterator.index + n] - abstractDataset.getElementDoubleAbs(indexIterator2.index + n);
                        double d8 = d7 * d7 - d6;
                        double d9 = d + d8;
                        d6 = d9 - d - d8;
                        d = d9;
                        ++n;
                    }
                }
            }
        } else {
            double[] dArray = CompoundShortDataset.toDoubleArray(object, this.isize);
            IndexIterator indexIterator = this.getIterator();
            double d10 = 0.0;
            while (indexIterator.hasNext()) {
                int n = 0;
                while (n < this.isize) {
                    double d11 = (double)this.data[indexIterator.index + n] - dArray[n];
                    double d12 = d11 * d11 - d10;
                    double d13 = d + d12;
                    d10 = d13 - d - d12;
                    d = d13;
                    ++n;
                }
            }
        }
        return d;
    }
}

