/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.diamond.scisoft.analysis.dataset;

import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.BooleanDataset;
import uk.ac.diamond.scisoft.analysis.dataset.Comparisons;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;
import uk.ac.diamond.scisoft.analysis.dataset.IntegerDataset;

public class ComparisonsTest {
    AbstractDataset a;
    AbstractDataset b;

    @Before
    public void setUpClass() {
        this.a = new DoubleDataset(new double[]{0.0, 1.0, 3.0, 5.0, -7.0, -9.0}, new int[0]);
        this.b = new DoubleDataset(new double[]{0.01, 1.2, 2.9, 5.0, -7.1, -9.0}, new int[0]);
    }

    @Test
    public void testEqualTo() {
        BooleanDataset booleanDataset = Comparisons.equalTo(this.a, this.b);
        boolean[] blArray = new boolean[6];
        blArray[3] = true;
        blArray[5] = true;
        BooleanDataset booleanDataset2 = new BooleanDataset(blArray, new int[0]);
        this.checkDatasets(booleanDataset, booleanDataset2);
        boolean[] blArray2 = new boolean[6];
        blArray2[2] = true;
        this.checkDatasets(Comparisons.equalTo(3, (Object)this.a), new BooleanDataset(blArray2, new int[0]));
    }

    @Test
    public void testAlmostEqualTo() {
        BooleanDataset booleanDataset = Comparisons.almostEqualTo(this.a, this.b, 0.1, 0.001);
        boolean[] blArray = new boolean[6];
        blArray[2] = true;
        blArray[3] = true;
        blArray[4] = true;
        blArray[5] = true;
        BooleanDataset booleanDataset2 = new BooleanDataset(blArray, new int[0]);
        this.checkDatasets(booleanDataset, booleanDataset2);
        boolean[] blArray2 = new boolean[6];
        blArray2[2] = true;
        this.checkDatasets(Comparisons.almostEqualTo(3, (Object)this.a, 0.1, 0.001), new BooleanDataset(blArray2, new int[0]));
    }

    @Test
    public void testGreaterThan() {
        BooleanDataset booleanDataset = Comparisons.greaterThan(this.a, this.b);
        boolean[] blArray = new boolean[6];
        blArray[2] = true;
        blArray[4] = true;
        BooleanDataset booleanDataset2 = new BooleanDataset(blArray, new int[0]);
        this.checkDatasets(booleanDataset, booleanDataset2);
        boolean[] blArray2 = new boolean[6];
        blArray2[0] = true;
        blArray2[1] = true;
        blArray2[4] = true;
        blArray2[5] = true;
        this.checkDatasets(Comparisons.greaterThan(3, (Object)this.a), new BooleanDataset(blArray2, new int[0]));
    }

    @Test
    public void testGreaterThanOrEqualTo() {
        BooleanDataset booleanDataset = Comparisons.greaterThanOrEqualTo(this.a, this.b);
        boolean[] blArray = new boolean[6];
        blArray[2] = true;
        blArray[3] = true;
        blArray[4] = true;
        blArray[5] = true;
        BooleanDataset booleanDataset2 = new BooleanDataset(blArray, new int[0]);
        this.checkDatasets(booleanDataset, booleanDataset2);
        boolean[] blArray2 = new boolean[6];
        blArray2[0] = true;
        blArray2[1] = true;
        blArray2[2] = true;
        blArray2[4] = true;
        blArray2[5] = true;
        this.checkDatasets(Comparisons.greaterThanOrEqualTo(3, (Object)this.a), new BooleanDataset(blArray2, new int[0]));
    }

    @Test
    public void testLessThan() {
        BooleanDataset booleanDataset = Comparisons.lessThan(this.a, this.b);
        boolean[] blArray = new boolean[6];
        blArray[0] = true;
        blArray[1] = true;
        BooleanDataset booleanDataset2 = new BooleanDataset(blArray, new int[0]);
        this.checkDatasets(booleanDataset, booleanDataset2);
        boolean[] blArray2 = new boolean[6];
        blArray2[3] = true;
        this.checkDatasets(Comparisons.lessThan(3, (Object)this.a), new BooleanDataset(blArray2, new int[0]));
    }

    @Test
    public void testLessThanOrEqualTo() {
        BooleanDataset booleanDataset = Comparisons.lessThanOrEqualTo(this.a, this.b);
        boolean[] blArray = new boolean[6];
        blArray[0] = true;
        blArray[1] = true;
        blArray[3] = true;
        blArray[5] = true;
        BooleanDataset booleanDataset2 = new BooleanDataset(blArray, new int[0]);
        this.checkDatasets(booleanDataset, booleanDataset2);
        boolean[] blArray2 = new boolean[6];
        blArray2[2] = true;
        blArray2[3] = true;
        this.checkDatasets(Comparisons.lessThanOrEqualTo(3, (Object)this.a), new BooleanDataset(blArray2, new int[0]));
    }

    @Test
    public void testAllTrue() {
        Assert.assertFalse((boolean)Comparisons.allTrue(this.a));
        Assert.assertTrue((boolean)Comparisons.allTrue(this.b));
        AbstractDataset abstractDataset = this.a.clone().reshape(2, 3);
        boolean[] blArray = new boolean[3];
        blArray[1] = true;
        blArray[2] = true;
        this.checkDatasets(Comparisons.allTrue(abstractDataset, 0), new BooleanDataset(blArray, new int[0]));
        AbstractDataset abstractDataset2 = this.b.clone().reshape(2, 3);
        this.checkDatasets(Comparisons.allTrue(abstractDataset2, 1), new BooleanDataset(new boolean[]{true, true}, new int[0]));
    }

    @Test
    public void testAnyTrue() {
        Assert.assertTrue((boolean)Comparisons.anyTrue(this.a));
        Assert.assertTrue((boolean)Comparisons.anyTrue(this.b));
        Assert.assertFalse((boolean)Comparisons.anyTrue(new DoubleDataset(new double[]{0.0, 0.0}, new int[0])));
        AbstractDataset abstractDataset = this.a.clone().reshape(2, 3);
        this.checkDatasets(Comparisons.anyTrue(abstractDataset, 0), new BooleanDataset(new boolean[]{true, true, true}, new int[0]));
        AbstractDataset abstractDataset2 = this.b.clone().reshape(2, 3);
        this.checkDatasets(Comparisons.anyTrue(abstractDataset2, 1), new BooleanDataset(new boolean[]{true, true}, new int[0]));
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        this.checkDatasets(Comparisons.anyTrue(new DoubleDataset(new double[]{0.0, 0.0, 0.0, 1.0}, new int[0]).reshape(2, 2), 1), new BooleanDataset(blArray, new int[0]));
    }

    @Test
    public void testNot() {
        boolean[] blArray = new boolean[6];
        blArray[0] = true;
        this.checkDatasets(Comparisons.logicalNot(this.a), new BooleanDataset(blArray, new int[0]));
        this.checkDatasets(Comparisons.logicalNot(this.b), new BooleanDataset(new boolean[6], new int[0]));
    }

    @Test
    public void testAnd() {
        BooleanDataset booleanDataset = Comparisons.logicalAnd(this.a, this.b);
        boolean[] blArray = new boolean[6];
        blArray[1] = true;
        blArray[2] = true;
        blArray[3] = true;
        blArray[4] = true;
        blArray[5] = true;
        BooleanDataset booleanDataset2 = new BooleanDataset(blArray, new int[0]);
        this.checkDatasets(booleanDataset, booleanDataset2);
    }

    @Test
    public void testOr() {
        BooleanDataset booleanDataset = Comparisons.logicalOr(this.a, this.b);
        BooleanDataset booleanDataset2 = new BooleanDataset(new boolean[]{true, true, true, true, true, true}, new int[0]);
        this.checkDatasets(booleanDataset, booleanDataset2);
    }

    @Test
    public void testXor() {
        BooleanDataset booleanDataset = Comparisons.logicalXor(this.a, this.b);
        boolean[] blArray = new boolean[6];
        blArray[0] = true;
        BooleanDataset booleanDataset2 = new BooleanDataset(blArray, new int[0]);
        this.checkDatasets(booleanDataset, booleanDataset2);
    }

    @Test
    public void testNonZero() {
        AbstractDataset abstractDataset = this.a.clone().reshape(2, 3);
        List<IntegerDataset> list = Comparisons.nonZero(abstractDataset);
        int[] nArray = new int[5];
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        this.checkDatasets(list.get(0), new IntegerDataset(nArray, null));
        int[] nArray2 = new int[5];
        nArray2[0] = 1;
        nArray2[1] = 2;
        nArray2[3] = 1;
        nArray2[4] = 2;
        this.checkDatasets(list.get(1), new IntegerDataset(nArray2, null));
    }

    @Test
    public void testSelect() {
        AbstractDataset abstractDataset = this.a.clone().reshape(2, 3);
        boolean[] blArray = new boolean[6];
        blArray[1] = true;
        blArray[4] = true;
        BooleanDataset booleanDataset = new BooleanDataset(blArray, 2, 3);
        DoubleDataset doubleDataset = (DoubleDataset)Comparisons.select(new BooleanDataset[]{booleanDataset}, new Object[]{abstractDataset}, -2);
        this.checkDatasets(doubleDataset, new DoubleDataset(new double[]{-2.0, 1.0, -2.0, -2.0, -7.0, -2.0}, 2, 3));
        AbstractDataset abstractDataset2 = this.b.clone().reshape(2, 3);
        boolean[] blArray2 = new boolean[6];
        blArray2[1] = true;
        blArray2[2] = true;
        BooleanDataset booleanDataset2 = new BooleanDataset(blArray2, 2, 3);
        doubleDataset = (DoubleDataset)Comparisons.select(new BooleanDataset[]{booleanDataset, booleanDataset2}, new AbstractDataset[]{abstractDataset, abstractDataset2}, -2.5);
        this.checkDatasets(doubleDataset, new DoubleDataset(new double[]{-2.5, 1.0, 2.9, -2.5, -7.0, -2.5}, 2, 3));
    }

    public void checkDatasets(BooleanDataset booleanDataset, BooleanDataset booleanDataset2) {
        IndexIterator indexIterator = booleanDataset.getIterator(true);
        IndexIterator indexIterator2 = booleanDataset2.getIterator();
        int n = booleanDataset.getElementsPerItem();
        while (indexIterator.hasNext() && indexIterator2.hasNext()) {
            int n2 = 0;
            while (n2 < n) {
                Assert.assertEquals((String)("Value does not match at " + Arrays.toString(indexIterator.getPos()) + "; " + n2 + ": "), (Object)booleanDataset2.getAbs(indexIterator.index + n2), (Object)booleanDataset.getAbs(indexIterator2.index + n2));
                ++n2;
            }
        }
    }

    public void checkDatasets(IntegerDataset integerDataset, IntegerDataset integerDataset2) {
        IndexIterator indexIterator = integerDataset.getIterator(true);
        IndexIterator indexIterator2 = integerDataset2.getIterator();
        int n = integerDataset.getElementsPerItem();
        while (indexIterator.hasNext() && indexIterator2.hasNext()) {
            int n2 = 0;
            while (n2 < n) {
                Assert.assertEquals((String)("Value does not match at " + Arrays.toString(indexIterator.getPos()) + "; " + n2 + ": "), (long)integerDataset2.getAbs(indexIterator.index + n2), (long)integerDataset.getAbs(indexIterator2.index + n2));
                ++n2;
            }
        }
    }

    public void checkDatasets(DoubleDataset doubleDataset, DoubleDataset doubleDataset2) {
        IndexIterator indexIterator = doubleDataset.getIterator(true);
        IndexIterator indexIterator2 = doubleDataset2.getIterator();
        int n = doubleDataset.getElementsPerItem();
        while (indexIterator.hasNext() && indexIterator2.hasNext()) {
            int n2 = 0;
            while (n2 < n) {
                Assert.assertEquals((String)("Value does not match at " + Arrays.toString(indexIterator.getPos()) + "; " + n2 + ": "), (double)doubleDataset2.getAbs(indexIterator.index + n2), (double)doubleDataset.getAbs(indexIterator2.index + n2), (double)1.0E-5);
                ++n2;
            }
        }
    }
}

