/*
 * Decompiled with CFR 0.152.
 */
package gda.analysis.utils.optimisation;

import gda.analysis.utils.optimisation.ProblemDefinition;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Neldermead {
    private static final Logger logger = LoggerFactory.getLogger(Neldermead.class);
    private double alpha = 1.0;
    private double gamma = 2.0;
    private double phi = 0.5;
    private double sigma = 0.5;
    private double startingSpread = 0.1;
    private Random random = new Random(0L);

    public double getAlpha() {
        return this.alpha;
    }

    public void setAlpha(double d) {
        this.alpha = d;
    }

    public double getGamma() {
        return this.gamma;
    }

    public void setGamma(double d) {
        this.gamma = d;
    }

    public double getPhi() {
        return this.phi;
    }

    public void setPhi(double d) {
        this.phi = d;
    }

    public double getSigma() {
        return this.sigma;
    }

    public void setSigma(double d) {
        this.sigma = d;
    }

    public double getStartingSpread() {
        return this.startingSpread;
    }

    public void setStartingSpread(double d) {
        this.startingSpread = d;
    }

    public double[] optimise(double[] dArray, ProblemDefinition problemDefinition, double d) throws Exception {
        double[] dArray2 = dArray;
        boolean bl = true;
        while (bl) {
            Simplex simplex = new Simplex(dArray2, this.startingSpread);
            simplex.generateStartingFitnesses(problemDefinition);
            while (simplex.improving(d)) {
                simplex.iterate(problemDefinition);
            }
            dArray2 = simplex.getBestSolution();
            bl = simplex.hasCollapsed();
        }
        return dArray2;
    }

    private class Simplex {
        private boolean collapsed = false;
        double[][] points;
        double[] fitnesses;
        Double oldBest = null;
        Double oldSpread = null;

        public Simplex(double[] dArray, double d) {
            this.points = new double[dArray.length + 1][dArray.length];
            this.initialise(dArray, d);
        }

        public boolean hasCollapsed() {
            return this.collapsed;
        }

        public boolean improving(double d) {
            if (this.oldBest == null) {
                int[] nArray = this.sortFitnesses();
                this.oldBest = this.fitnesses[nArray[0]];
                this.oldSpread = Math.abs(this.fitnesses[nArray[0]] - this.fitnesses[nArray[nArray.length - 1]]);
                return true;
            }
            int[] nArray = this.sortFitnesses();
            double d2 = this.fitnesses[nArray[0]];
            double d3 = Math.abs(this.fitnesses[nArray[0]] - this.fitnesses[nArray[nArray.length - 1]]);
            if (d3 < d) {
                this.oldBest = d2;
                this.oldSpread = d3;
                return false;
            }
            if (d2 == this.oldBest && d3 == this.oldSpread) {
                logger.info("Error, the NelderMead simplex has collapsed, this minimisation may be flawed");
                this.collapsed = true;
                return false;
            }
            this.oldBest = d2;
            this.oldSpread = d3;
            return true;
        }

        public double[] getBestSolution() {
            int[] nArray = this.sortFitnesses();
            return this.points[nArray[0]];
        }

        public void iterate(ProblemDefinition problemDefinition) throws Exception {
            int[] nArray = this.sortFitnesses();
            double[] dArray = this.calculateCentreOfGravityIgnoringWorstValue(nArray);
            double[] dArray2 = this.calculateReflectedPoint(dArray, nArray);
            double d = problemDefinition.eval(dArray2);
            if (d < this.fitnesses[nArray[0]]) {
                double[] dArray3 = this.calculateExtendedPoint(dArray, nArray);
                double d2 = problemDefinition.eval(dArray3);
                if (d2 < d) {
                    this.replaceWorstPointWith(dArray3, d2, nArray);
                    return;
                }
                this.replaceWorstPointWith(dArray2, d, nArray);
                return;
            }
            if (d > this.fitnesses[nArray[nArray.length - 2]]) {
                double[] dArray4 = this.calculateContractedPoint(dArray, nArray);
                double d3 = problemDefinition.eval(dArray4);
                if (d3 < this.fitnesses[nArray[nArray.length - 1]]) {
                    this.replaceWorstPointWith(dArray4, d3, nArray);
                    return;
                }
                this.reducePoints(nArray, problemDefinition);
                return;
            }
            this.replaceWorstPointWith(dArray2, d, nArray);
        }

        private void reducePoints(int[] nArray, ProblemDefinition problemDefinition) throws Exception {
            int n = 1;
            while (n < nArray.length) {
                double d;
                int n2 = 0;
                while (n2 < this.points[n].length) {
                    this.points[nArray[n]][n2] = this.points[nArray[0]][n2] + Neldermead.this.sigma * (this.points[nArray[n]][n2] - this.points[nArray[0]][n2]);
                    ++n2;
                }
                this.fitnesses[nArray[n]] = d = problemDefinition.eval(this.points[nArray[n]]);
                ++n;
            }
        }

        private double[] calculateContractedPoint(double[] dArray, int[] nArray) {
            double[] dArray2 = new double[dArray.length];
            int n = 0;
            while (n < dArray2.length) {
                dArray2[n] = dArray[n] + Neldermead.this.phi * (dArray[n] - this.points[nArray[nArray.length - 1]][n]);
                ++n;
            }
            return dArray2;
        }

        private void replaceWorstPointWith(double[] dArray, double d, int[] nArray) {
            int n = 0;
            while (n < dArray.length) {
                this.points[nArray[nArray.length - 1]][n] = dArray[n];
                ++n;
            }
            this.fitnesses[nArray[nArray.length - 1]] = d;
        }

        private double[] calculateExtendedPoint(double[] dArray, int[] nArray) {
            double[] dArray2 = new double[dArray.length];
            int n = 0;
            while (n < dArray2.length) {
                dArray2[n] = dArray[n] + Neldermead.this.gamma * (dArray[n] - this.points[nArray[nArray.length - 1]][n]);
                ++n;
            }
            return dArray2;
        }

        private double[] calculateReflectedPoint(double[] dArray, int[] nArray) {
            double[] dArray2 = new double[dArray.length];
            int n = 0;
            while (n < dArray2.length) {
                dArray2[n] = dArray[n] + Neldermead.this.alpha * (dArray[n] - this.points[nArray[nArray.length - 1]][n]);
                ++n;
            }
            return dArray2;
        }

        private double[] calculateCentreOfGravityIgnoringWorstValue(int[] nArray) {
            double[] dArray = new double[this.points[0].length];
            int n = 0;
            while (n < dArray.length) {
                dArray[n] = 0.0;
                ++n;
            }
            n = 0;
            while (n < nArray.length - 1) {
                int n2 = 0;
                while (n2 < dArray.length) {
                    int n3 = n2;
                    dArray[n3] = dArray[n3] + this.points[nArray[n]][n2];
                    ++n2;
                }
                ++n;
            }
            n = 0;
            while (n < dArray.length) {
                dArray[n] = dArray[n] / (double)(nArray.length - 1);
                ++n;
            }
            return dArray;
        }

        private int[] sortFitnesses() {
            int[] nArray = new int[this.fitnesses.length];
            this.bubbleSort(nArray);
            return nArray;
        }

        private void bubbleSort(int[] nArray) {
            boolean bl = false;
            int n = 0;
            while (n < nArray.length) {
                nArray[n] = n;
                ++n;
            }
            while (!bl) {
                bl = true;
                n = 0;
                while (n < nArray.length - 1) {
                    if (this.fitnesses[nArray[n]] > this.fitnesses[nArray[n + 1]]) {
                        int n2 = nArray[n];
                        nArray[n] = nArray[n + 1];
                        nArray[n + 1] = n2;
                        bl = false;
                    }
                    ++n;
                }
            }
        }

        public void generateStartingFitnesses(ProblemDefinition problemDefinition) throws Exception {
            this.fitnesses = new double[this.points.length];
            int n = 0;
            while (n < this.fitnesses.length) {
                this.fitnesses[n] = problemDefinition.eval(this.points[n]);
                ++n;
            }
        }

        private void initialise(double[] dArray, double d) {
            int n = 0;
            while (n < this.points.length) {
                double[] dArray2 = this.createRandomUnitVector(dArray.length);
                int n2 = 0;
                while (n2 < dArray.length) {
                    this.points[n][n2] = dArray[n2] + dArray2[n2] * d * Math.abs(dArray[n2]);
                    ++n2;
                }
                ++n;
            }
        }

        private double[] createRandomUnitVector(int n) {
            double[] dArray = this.createRandomVector(n);
            double d = this.getVectorlength(dArray);
            int n2 = 0;
            while (n2 < dArray.length) {
                dArray[n2] = dArray[n2] / d;
                ++n2;
            }
            return dArray;
        }

        private double getVectorlength(double[] dArray) {
            double d = 0.0;
            int n = 0;
            while (n < dArray.length) {
                d += (double)(dArray.length * dArray.length);
                ++n;
            }
            return Math.sqrt(d);
        }

        private double[] createRandomVector(int n) {
            double[] dArray = new double[n];
            int n2 = 0;
            while (n2 < n) {
                dArray[n2] = Neldermead.this.random.nextDouble() - 0.5;
                ++n2;
            }
            return dArray;
        }
    }
}

