/*
 * Decompiled with CFR 0.152.
 */
package gda.analysis.utils.optimisation;

import gda.analysis.utils.optimisation.GeneticAlgorithm;
import gda.analysis.utils.optimisation.ProblemDefinition;
import gda.util.TestUtils;
import java.util.Random;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class GeneticAlgorithmTest {
    @Test
    @Ignore(value="2010/02/16 Test ignored since sometimes loops almost forever GDA-3006")
    public void testOptimiseSimple() throws Exception {
        String string = TestUtils.generateDirectorynameFromClassname((String)GeneticAlgorithmTest.class.getCanonicalName());
        TestUtils.makeScratchDirectory((String)string);
        try {
            GeneticAlgorithm geneticAlgorithm = new GeneticAlgorithm();
            double[] dArray = new double[]{0.1, 0.3, 0.5, 0.7};
            geneticAlgorithm.optimise(new simplepd(), 20, 10, null, dArray);
        }
        catch (Exception exception) {
            Assert.fail((String)"An exception occured during the optimise routine");
        }
    }

    @Test
    @Ignore(value="2010/02/16 Test ignored since sometimes loops almost forever GDA-3006")
    public void testFailingOptimisation() throws Exception {
        String string = TestUtils.generateDirectorynameFromClassname((String)GeneticAlgorithmTest.class.getCanonicalName());
        TestUtils.makeScratchDirectory((String)string);
        GeneticAlgorithm geneticAlgorithm = new GeneticAlgorithm();
        double[] dArray = new double[]{0.1, 0.3, 0.5, 0.7};
        try {
            geneticAlgorithm.optimise(new failingpd(), 20, 10, String.valueOf(string) + "test2.tmp", dArray);
        }
        catch (Exception exception) {}
        boolean bl = false;
        while (!bl) {
            try {
                geneticAlgorithm.optimise(new failingpd(), 20, String.valueOf(string) + "test2.tmp");
                bl = true;
            }
            catch (Exception exception) {}
        }
    }

    class failingpd
    extends simplepd {
        Random rand;
        double prob;

        failingpd() {
            this.rand = new Random();
            this.prob = 0.1;
        }

        @Override
        public double eval(double[] dArray) throws Exception {
            double d = this.rand.nextDouble();
            if (d < this.prob) {
                throw new Exception("PD failed");
            }
            return super.eval(dArray);
        }
    }

    class simplepd
    implements ProblemDefinition {
        simplepd() {
        }

        @Override
        public double eval(double[] dArray) throws Exception {
            double d = 0.0;
            int n = 0;
            while (n < dArray.length) {
                d += dArray[n];
                ++n;
            }
            return d;
        }

        @Override
        public int getNumberOfParameters() {
            return 4;
        }
    }
}

