/*
 * Decompiled with CFR 0.152.
 */
package gda.analysis.utils;

import gda.analysis.DataSet;
import gda.analysis.functions.IFunction;
import gda.analysis.utils.IOptimizer;
import java.util.Random;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MonteCarlo
implements IOptimizer {
    private static final Logger logger = LoggerFactory.getLogger(MonteCarlo.class);
    private double qualityFactor = 0.0;

    public MonteCarlo(double d) {
        this.qualityFactor = d;
    }

    @Override
    public void Optimize(DataSet[] dataSetArray, DataSet dataSet, IFunction iFunction) {
        double[] dArray = iFunction.getParameterValues();
        double d = iFunction.residual(true, dataSet, dataSetArray);
        Random random = new Random();
        double d2 = 1.0;
        logger.debug("Accurasy reached is :{}", (Object)d2);
        int n = 0;
        while (d2 > this.qualityFactor) {
            if (n > dArray.length * 20) {
                logger.info("Accurasy reached is :" + (d2 /= 1.2));
                n = 0;
            }
            if (n < 0) {
                n = 0;
            }
            int n2 = Math.abs(random.nextInt()) % dArray.length;
            double d3 = iFunction.getParameter(n2).getValue();
            double d4 = (random.nextDouble() - 0.5) * d2;
            double d5 = (iFunction.getParameter(n2).getUpperLimit() - iFunction.getParameter(n2).getLowerLimit()) * d4;
            double d6 = random.nextDouble() * (iFunction.getParameter(n2).getUpperLimit() - iFunction.getParameter(n2).getLowerLimit()) + iFunction.getParameter(n2).getLowerLimit();
            if (Math.abs(d3 - d6) > d5) {
                d6 = d6 > d3 ? d3 + d5 : d3 - d5;
            }
            dArray[n2] = d6;
            iFunction.setParameterValues(dArray);
            double d7 = iFunction.residual(true, dataSet, dataSetArray);
            if (d7 < d) {
                d = d7;
                logger.debug("minval is {} with a failcount of {}", (Object)d, (Object)(n -= 15));
                continue;
            }
            dArray[n2] = d3;
            iFunction.setParameterValues(dArray);
            logger.debug("minval is {} with a failcount of {}", (Object)d, (Object)(++n));
        }
        iFunction.setParameterValues(dArray);
        dArray = iFunction.getParameterValues();
    }
}

