/*
 * Decompiled with CFR 0.152.
 */
package gda.analysis.io.emulated;

import gda.analysis.io.IFileLoader;
import gda.analysis.io.ScanFileHolderException;
import gda.analysis.io.emulated.FileSystemEmulatingFileLoader;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;

public class FileSystemEmulatingFileLoaderTest {
    private IFileLoader mockLoader;
    private DataHolder loadDataHolder;
    private FileSystemEmulatingFileLoader fileSystemEmulatingFileLoader;

    @Before
    public void setUp() throws ScanFileHolderException {
        this.mockLoader = (IFileLoader)Mockito.mock(IFileLoader.class);
        this.loadDataHolder = (DataHolder)Mockito.mock(DataHolder.class);
        Mockito.when((Object)this.mockLoader.loadFile()).thenReturn((Object)this.loadDataHolder);
    }

    @Test
    public void testEmulatedLatency() throws ScanFileHolderException {
        this.fileSystemEmulatingFileLoader = new FileSystemEmulatingFileLoader(this.mockLoader, 1000L, 0L);
        this.verifyResultAndDelayWas1s();
    }

    @Test
    public void testEmulatedFileloadTime() throws ScanFileHolderException {
        this.fileSystemEmulatingFileLoader = new FileSystemEmulatingFileLoader(this.mockLoader, 0L, 1000L);
        this.verifyResultAndDelayWas1s();
    }

    @Test
    public void testEmulatedFileloadTimeToShort() throws ScanFileHolderException {
        this.fileSystemEmulatingFileLoader = new FileSystemEmulatingFileLoader(this.mockLoader, 1000L, 0L);
        this.verifyResultAndDelayWas1s();
    }

    private void verifyResultAndDelayWas1s() throws ScanFileHolderException {
        long l = System.currentTimeMillis();
        DataHolder dataHolder = this.fileSystemEmulatingFileLoader.loadFile();
        long l2 = System.currentTimeMillis() - l;
        System.out.println(l2);
        Assert.assertTrue((l2 < 1100L && l2 > 998L ? 1 : 0) != 0);
        Assert.assertEquals((Object)this.loadDataHolder, (Object)dataHolder);
    }
}

