/*
 * Decompiled with CFR 0.152.
 */
package gda.analysis.io;

import gda.analysis.DataSet;
import gda.analysis.io.CBFLoader;
import gda.analysis.io.RawOutput;
import gda.analysis.io.ScanFileHolderException;
import gda.util.TestUtils;
import junit.framework.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;
import uk.ac.diamond.scisoft.analysis.io.LoaderFactory;

public class RawOutputTest {
    static String testScratchDirectoryName = null;
    static String testpath = null;
    DataSet data;
    int sizex = 2400;
    int sizey = 2400;
    int range = this.sizex * this.sizey;
    String filePath = "TestData.dat";
    static String TestFileFolder;

    @BeforeClass
    public static void setUpClass() throws Exception {
        TestFileFolder = TestUtils.getGDALargeTestFilesLocation();
        if (TestFileFolder == null) {
            Assert.fail((String)"TestUtils.getGDALargeTestFilesLocation() returned null - test aborted");
        }
        testScratchDirectoryName = TestUtils.generateDirectorynameFromClassname((String)RawOutputTest.class.getCanonicalName());
        TestUtils.makeScratchDirectory((String)testScratchDirectoryName);
        testpath = String.valueOf(TestFileFolder) + "CBFLoaderTest/";
    }

    @Test
    public void testSaveFile() throws ScanFileHolderException {
        DataHolder dataHolder = new DataHolder();
        this.data = DataSet.linspace(0.0, 5760000.0, this.range);
        this.data.reshape(this.sizex, this.sizey);
        try {
            dataHolder.addDataset("testing data", this.data);
            new RawOutput(String.valueOf(testScratchDirectoryName) + this.filePath).saveFile(dataHolder);
        }
        catch (Exception exception) {
            throw new ScanFileHolderException("Problem testing rawOutput class", exception);
        }
    }

    @Test
    public void testCBFFile() throws ScanFileHolderException {
        DataHolder dataHolder = new CBFLoader(String.valueOf(testpath) + "F6_1_001.cbf").loadFile();
        try {
            new RawOutput(String.valueOf(testScratchDirectoryName) + "F6_1_001.dat").saveFile(dataHolder);
        }
        catch (Exception exception) {
            throw new ScanFileHolderException("Problem testing rawOutput class", exception);
        }
    }

    @Test
    public void testLoaderFactory() throws Exception {
        DataHolder dataHolder = LoaderFactory.getData(String.valueOf(testpath) + "F6_1_001.cbf", null);
        if (dataHolder == null || dataHolder.getNames().length < 1) {
            throw new Exception();
        }
    }
}

