/*
 * Decompiled with CFR 0.152.
 */
package gda.analysis.io;

import gda.analysis.DataSet;
import gda.analysis.io.IFileSaver;
import gda.analysis.io.ScanFileHolderException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.channels.FileChannel;
import java.text.DecimalFormat;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;

public class RawBinarySaver
implements IFileSaver {
    private String filename = "";
    private static int formatTag = -1056630259;

    public static int getFormatTag() {
        return formatTag;
    }

    public RawBinarySaver(String string) {
        this.filename = string;
    }

    @Override
    public void saveFile(DataHolder dataHolder) throws ScanFileHolderException {
        File file = null;
        int n = 0;
        int n2 = dataHolder.size();
        while (n < n2) {
            Object object;
            try {
                object = null;
                String string = null;
                if (n2 == 1) {
                    object = this.filename;
                } else {
                    try {
                        object = this.filename.substring(0, this.filename.lastIndexOf("."));
                        string = this.filename.substring(this.filename.lastIndexOf("."));
                    }
                    catch (Exception exception) {
                        object = this.filename;
                    }
                    DecimalFormat decimalFormat = new DecimalFormat("00000");
                    object = String.valueOf(object) + decimalFormat.format(n + 1) + string;
                }
                file = new File((String)object);
            }
            catch (Exception exception) {
                throw new ScanFileHolderException("Error saving file '" + this.filename + "'", exception);
            }
            object = dataHolder.getDataSet(n);
            byte by = -1;
            byte by2 = 1;
            String string = ((DataSet)object).getName();
            byte[] byArray = null;
            try {
                byArray = string.getBytes("UTF8");
                int n3 = string.length() - 2;
                while (byArray.length > 65535) {
                    byArray = string.substring(0, n3).getBytes("UTF8");
                    --n3;
                }
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                throw new ScanFileHolderException("Problem dealing with dataset name", unsupportedEncodingException);
            }
            int[] nArray = ((DataSet)object).getShape();
            if (nArray.length > 255) {
                throw new ScanFileHolderException("Rank exceeds 255!");
            }
            int n4 = nArray.length;
            int n5 = 7 + n4 * 4 + 2 + byArray.length;
            n5 = (n5 + 3) / 4 * 4;
            int n6 = by2 * ((DataSet)object).getSize();
            try {
                FileOutputStream fileOutputStream = new FileOutputStream(file);
                FileChannel fileChannel = fileOutputStream.getChannel();
                ByteBuffer byteBuffer = ByteBuffer.allocateDirect(n5);
                byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                byteBuffer.putInt(formatTag);
                byteBuffer.put(by);
                byteBuffer.put(by2);
                byteBuffer.put((byte)n4);
                int n7 = 0;
                while (n7 < n4) {
                    byteBuffer.putInt(nArray[n7]);
                    ++n7;
                }
                byteBuffer.putShort((short)byArray.length);
                if (byArray.length > 0) {
                    byteBuffer.put(byArray);
                }
                while (byteBuffer.position() < n5) {
                    byteBuffer.put((byte)0);
                }
                byteBuffer.rewind();
                while (byteBuffer.hasRemaining()) {
                    fileChannel.write(byteBuffer);
                }
                ByteBuffer byteBuffer2 = ByteBuffer.allocateDirect(n6 * 8);
                byteBuffer2.order(ByteOrder.LITTLE_ENDIAN);
                DoubleBuffer doubleBuffer = byteBuffer2.asDoubleBuffer();
                double[] dArray = ((DataSet)object).getBuffer();
                IndexIterator indexIterator = ((DataSet)object).getIterator();
                while (indexIterator.hasNext()) {
                    doubleBuffer.put(dArray[indexIterator.index]);
                }
                while (byteBuffer2.hasRemaining()) {
                    fileChannel.write(byteBuffer2);
                }
                fileChannel.close();
                fileOutputStream.close();
            }
            catch (Exception exception) {
                throw new ScanFileHolderException("Error saving file '" + this.filename + "'", exception);
            }
            ++n;
        }
    }
}

