/*
 * Decompiled with CFR 0.152.
 */
package gda.analysis.io;

import gda.analysis.DataSet;
import gda.analysis.io.RawBinarySaver;
import gda.analysis.io.ScanFileHolderException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import uk.ac.diamond.scisoft.analysis.io.AbstractFileLoader;
import uk.ac.diamond.scisoft.analysis.io.DataHolder;

public class RawBinaryLoader
extends AbstractFileLoader {
    private String fileName;

    public RawBinaryLoader(String string) {
        this.fileName = string;
    }

    @Override
    public DataHolder loadFile() throws ScanFileHolderException {
        DataHolder dataHolder = new DataHolder();
        File file = null;
        FileInputStream fileInputStream = null;
        try {
            try {
                file = new File(this.fileName);
                fileInputStream = new FileInputStream(file);
                FileChannel fileChannel = fileInputStream.getChannel();
                MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, fileChannel.size());
                mappedByteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                if (RawBinarySaver.getFormatTag() != mappedByteBuffer.getInt()) {
                    throw new ScanFileHolderException("File does not start with a Diamond format tag " + String.format("%x", mappedByteBuffer.getInt()));
                }
                byte by = mappedByteBuffer.get();
                if (by != -1) {
                    throw new ScanFileHolderException("Dataset type not supported");
                }
                byte by2 = mappedByteBuffer.get();
                if (by2 != 1) {
                    throw new ScanFileHolderException("Dataset item size not supported");
                }
                int n = mappedByteBuffer.get();
                int n2 = 1;
                int[] nArray = new int[n];
                int n3 = 0;
                while (n3 < n) {
                    nArray[n3] = mappedByteBuffer.getInt();
                    n2 *= nArray[n3];
                    ++n3;
                }
                n3 = mappedByteBuffer.getShort();
                byte[] byArray = new byte[n3];
                if (n3 > 0) {
                    mappedByteBuffer.get(byArray);
                }
                while (mappedByteBuffer.position() % 4 != 0) {
                    mappedByteBuffer.get();
                }
                DoubleBuffer doubleBuffer = mappedByteBuffer.asDoubleBuffer();
                if (doubleBuffer.limit() != n2) {
                    throw new ScanFileHolderException("Data size, " + doubleBuffer.limit() + ", does not match expected, " + n2);
                }
                DataSet dataSet = new DataSet(nArray);
                double[] dArray = dataSet.getBuffer();
                int n4 = 0;
                while (n4 < n2) {
                    dArray[n4] = doubleBuffer.get();
                    ++n4;
                }
                fileChannel.close();
                if (n3 > 0) {
                    String string = new String(byArray, "UTF8");
                    dataSet.setName(string);
                    dataHolder.addDataset(string, dataSet);
                } else {
                    dataHolder.addDataset("RAW file", dataSet);
                }
                dataSet.setDirty();
            }
            catch (Exception exception) {
                if (exception instanceof ScanFileHolderException) {
                    throw (ScanFileHolderException)exception;
                }
                throw new ScanFileHolderException("There was a problem reading the Raw file", exception);
            }
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return dataHolder;
    }
}

