/*
 * Decompiled with CFR 0.152.
 */
package gda.analysis.functions.dataset;

import gda.analysis.DataSet;
import gda.analysis.functions.dataset.IDataSetFunction;
import gda.analysis.utils.DatasetMaths;
import java.util.ArrayList;
import java.util.List;

public class MapToRotatedCartesian
implements IDataSetFunction {
    int ox;
    int oy;
    int h;
    int w;
    double phi;

    public MapToRotatedCartesian(int n, int n2, int n3, int n4, double d) {
        this.ox = n;
        this.oy = n2;
        this.h = n4;
        this.w = n3;
        this.phi = Math.toRadians(d);
    }

    public MapToRotatedCartesian(int n, int n2, int n3, int n4, double d, boolean bl) {
        this.ox = n;
        this.oy = n2;
        this.h = n4;
        this.w = n3;
        this.phi = bl ? Math.toRadians(d) : d;
    }

    @Override
    public List<DataSet> execute(DataSet dataSet) {
        int[] nArray = dataSet.getDimensions();
        if (nArray.length != 2) {
            return null;
        }
        double d = Math.cos(this.phi);
        double d2 = Math.sin(this.phi);
        DataSet dataSet2 = new DataSet(this.h, this.w);
        int n = 0;
        while (n < this.h) {
            int n2 = 0;
            while (n2 < this.w) {
                double d3 = (double)this.ox + (double)n2 * d - (double)n * d2;
                double d4 = (double)this.oy + (double)n2 * d2 + (double)n * d;
                dataSet2.set(DatasetMaths.getBilinear(dataSet, d4, d3), n, n2++);
            }
            ++n;
        }
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        arrayList.add(dataSet2);
        arrayList.add(DataSet.ones(this.h, this.w));
        return arrayList;
    }
}

