/*
 * Decompiled with CFR 0.152.
 */
package gda.analysis.functions.dataset;

import gda.analysis.DataSet;
import gda.analysis.functions.dataset.IDataSetFunction;
import gda.analysis.utils.DatasetMaths;
import java.util.ArrayList;
import java.util.List;

public class MapToPolar
implements IDataSetFunction {
    double cx;
    double cy;
    double srad;
    double sphi;
    double erad;
    double ephi;

    public MapToPolar(double d, double d2, double d3, double d4, double d5, double d6) {
        this(d, d2, d3, d4, d5, d6, true);
    }

    public MapToPolar(double d, double d2, double d3, double d4, double d5, double d6, boolean bl) {
        this.cx = d;
        this.cy = d2;
        this.srad = d3;
        this.erad = d5;
        if (bl) {
            this.sphi = Math.toRadians(d4);
            this.ephi = Math.toRadians(d6);
        } else {
            this.sphi = d4;
            this.ephi = d6;
        }
        if (this.sphi > this.ephi) {
            double d7 = this.sphi;
            this.sphi = this.ephi;
            this.ephi = d7;
        }
    }

    @Override
    public List<DataSet> execute(DataSet dataSet) {
        int[] nArray = dataSet.getDimensions();
        if (nArray.length != 2) {
            throw new IllegalArgumentException("operating on 2d arrays only");
        }
        double d = 1.0 / this.erad;
        int n = (int)Math.ceil(this.erad - this.srad);
        int n2 = (int)Math.ceil((this.ephi - this.sphi) / d);
        if (n == 0) {
            n = 1;
        }
        if (n2 == 0) {
            n2 = 1;
        }
        DataSet dataSet2 = new DataSet(n, n2);
        DataSet dataSet3 = new DataSet(n, n2);
        int n3 = 0;
        while (n3 < n) {
            double d2 = this.srad + (double)n3;
            double d3 = d * d2;
            int n4 = 0;
            while (n4 < n2) {
                dataSet3.set(d3, n3, n4);
                double d4 = this.sphi + (double)n4 * d;
                double d5 = this.cx + d2 * Math.cos(d4);
                double d6 = this.cy + d2 * Math.sin(d4);
                dataSet2.set(d3 * DatasetMaths.getBilinear(dataSet, d6, d5), n3, n4++);
            }
            ++n3;
        }
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        arrayList.add(dataSet2);
        arrayList.add(dataSet3);
        return arrayList;
    }
}

