/*
 * Decompiled with CFR 0.152.
 */
package gda.analysis.functions.dataset;

import gda.analysis.DataSet;
import gda.analysis.functions.dataset.IDataSetFunction;
import java.util.ArrayList;
import java.util.List;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;

public class CentroidND
implements IDataSetFunction {
    private DataSet[] bases = null;

    public CentroidND(DataSet ... dataSetArray) {
        this.bases = dataSetArray;
    }

    private void checkCompatibility(DataSet dataSet) {
        int n = dataSet.getRank();
        int[] nArray = dataSet.getShape();
        if (n == this.bases.length) {
            int n2 = 0;
            while (n2 < n) {
                if (nArray[n2] != this.bases[n2].getSize()) break;
                ++n2;
            }
            if (n2 == n) {
                return;
            }
        }
        throw new IllegalArgumentException("Dataset shape does not match given or default coordinate base");
    }

    @Override
    public List<DataSet> execute(DataSet dataSet) {
        int n = dataSet.getRank();
        int[] nArray = dataSet.getShape();
        if (this.bases == null || this.bases.length == 0) {
            this.bases = new DataSet[n];
            int n2 = 0;
            while (n2 < n) {
                DataSet dataSet2;
                int n3 = nArray[n2];
                this.bases[n2] = dataSet2 = new DataSet(n3);
                int n4 = 0;
                while (n4 < n3) {
                    dataSet2.setAbs((double)n4 + 0.5, n4);
                    ++n4;
                }
                ++n2;
            }
        } else {
            this.checkCompatibility(dataSet);
        }
        IndexIterator indexIterator = dataSet.getIterator(true);
        int[] nArray2 = indexIterator.getPos();
        double d = 0.0;
        double[] dArray = new double[n];
        while (indexIterator.hasNext()) {
            double d2 = dataSet.get(indexIterator.index);
            d += d2;
            int n5 = 0;
            while (n5 < n) {
                int n6 = n5;
                dArray[n6] = dArray[n6] + this.bases[n5].get(nArray2[n5]) * d2;
                ++n5;
            }
        }
        int n7 = 0;
        while (n7 < n) {
            int n8 = n7++;
            dArray[n8] = dArray[n8] / d;
        }
        DataSet dataSet3 = new DataSet(dArray);
        ArrayList<DataSet> arrayList = new ArrayList<DataSet>();
        arrayList.add(dataSet3);
        return arrayList;
    }
}

