/*
 * Decompiled with CFR 0.152.
 */
package gda.analysis.functions;

import gda.analysis.TerminalPrinter;
import gda.analysis.functions.AFunction;
import gda.analysis.functions.Parameter;

public class Polynomial
extends AFunction {
    private static String cname = "Polynomial";
    final double[] a;

    public Polynomial() {
        super(1);
        this.a = new double[1];
        this.name = cname;
    }

    public Polynomial(int n) {
        super(n + 1);
        this.a = new double[n + 1];
        this.name = cname;
    }

    public Polynomial(Parameter[] parameterArray) {
        super(parameterArray);
        this.a = new double[parameterArray.length];
        this.name = cname;
    }

    public Polynomial(double[] dArray, double[] dArray2) {
        super(0);
        if (dArray.length != dArray2.length) {
            throw new IllegalArgumentException("");
        }
        int n = dArray.length;
        this.parameters = new Parameter[n];
        int n2 = 0;
        while (n2 < n) {
            this.parameters[n2] = new Parameter(0.5 * (dArray[n2] + dArray2[n2]), dArray[n2], dArray2[n2]);
            ++n2;
        }
        this.a = new double[n];
        this.name = cname;
    }

    private void calcCachedParameters() {
        int n = this.getNoOfParameters();
        int n2 = 0;
        while (n2 < n) {
            this.a[n2] = this.getParameterValue(n2);
            ++n2;
        }
        this.markParametersClean();
    }

    @Override
    public double val(double ... dArray) {
        if (this.areParametersDirty()) {
            this.calcCachedParameters();
        }
        double d = dArray[0];
        int n = this.a.length - 1;
        double d2 = this.a[0];
        int n2 = 1;
        while (n2 <= n) {
            d2 = d2 * d + this.a[n2];
            ++n2;
        }
        return d2;
    }

    @Override
    public void disp() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = this.a.length;
        int n2 = 0;
        while (n2 < n) {
            stringBuilder.append(String.format("Parameter %d has value %f within the bounds [%f,%f]\n", n2, this.getParameterValue(n2), this.getParameter(n2).getLowerLimit(), this.getParameter(n2).getUpperLimit()));
            ++n2;
        }
        TerminalPrinter.print(stringBuilder.toString());
    }

    @Override
    public double partialDeriv(int n, double ... dArray) {
        int n2 = this.a.length;
        if (n < 0 || n >= n2) {
            throw new IndexOutOfBoundsException("Parameter index is out of bounds");
        }
        double d = dArray[0];
        switch (n2 -= n) {
            case 0: {
                return 1.0;
            }
            case 1: {
                return d;
            }
            case 2: {
                return d * d;
            }
        }
        return Math.pow(d, n2);
    }
}

