/*
 * Decompiled with CFR 0.152.
 */
package gda.analysis.functions;

import gda.analysis.TerminalPrinter;
import gda.analysis.functions.APeak;
import gda.analysis.functions.IPeak;
import gda.analysis.functions.IdentifiedPeak;
import gda.analysis.functions.Parameter;
import org.apache.commons.math.special.Gamma;

public class PearsonVII
extends APeak
implements IPeak {
    private static String cname = "PearsonVII";
    double defaultMixing = 100.0;
    double alpha;
    double FWHM;
    double staticComponent;
    double position;
    double mean;
    double mixing;
    double area;

    public PearsonVII(double ... dArray) {
        super(dArray);
        this.name = cname;
    }

    public PearsonVII(Parameter[] parameterArray) {
        super(parameterArray);
        this.name = cname;
    }

    public PearsonVII(IdentifiedPeak identifiedPeak) {
        super(4);
        double d = identifiedPeak.getMaxXVal() - identifiedPeak.getMinXVal();
        this.getParameter(0).setValue(identifiedPeak.getPos());
        this.getParameter(0).setLowerLimit(identifiedPeak.getMinXVal());
        this.getParameter(0).setUpperLimit(identifiedPeak.getMaxXVal());
        this.getParameter(1).setLowerLimit(0.0);
        this.getParameter(1).setUpperLimit(d * 2.0);
        this.getParameter(1).setValue(identifiedPeak.getFWHM() / 2.0);
        this.getParameter(2).setValue(this.defaultMixing);
        this.getParameter(2).setLowerLimit(1.0);
        this.getParameter(2).setUpperLimit(Double.MAX_VALUE);
        this.getParameter(3).setLowerLimit(0.0);
        this.getParameter(3).setUpperLimit(identifiedPeak.getHeight() * 2.0 * (d * 2.0));
        this.getParameter(3).setValue(identifiedPeak.getArea() / 2.0);
        this.name = cname;
    }

    public PearsonVII(double d, double d2, double d3, double d4) {
        super(4);
        this.getParameter(0).setValue(d + (d2 - d) / 2.0);
        this.getParameter(0).setLowerLimit(d);
        this.getParameter(0).setUpperLimit(d2);
        this.getParameter(1).setLowerLimit(0.0);
        this.getParameter(1).setUpperLimit(d3);
        this.getParameter(1).setValue(d3 / 2.0);
        this.getParameter(2).setValue(this.defaultMixing);
        this.getParameter(2).setLowerLimit(1.0);
        this.getParameter(2).setUpperLimit(Double.MAX_VALUE);
        this.getParameter(3).setLowerLimit(0.0);
        this.getParameter(3).setUpperLimit(d4);
        this.getParameter(3).setValue(d4 / 10.0);
        this.name = cname;
    }

    public PearsonVII(double d, double d2, double d3, double d4, double d5) {
        super(4);
        this.getParameter(0).setLowerLimit(d);
        this.getParameter(0).setUpperLimit(d2);
        this.getParameter(0).setValue(d + (d2 - d) / 2.0);
        this.getParameter(1).setLowerLimit(0.0);
        this.getParameter(1).setUpperLimit(d3);
        this.getParameter(1).setValue(d3 / 10.0);
        this.getParameter(2).setLowerLimit(1.0);
        this.getParameter(2).setUpperLimit(Double.MAX_VALUE);
        this.getParameter(2).setValue(d5);
        this.getParameter(3).setLowerLimit(-d4);
        this.getParameter(3).setUpperLimit(d4);
        this.getParameter(3).setValue(d4 / 10.0);
        this.name = cname;
    }

    public PearsonVII createPeakFunction(double d, double d2, double d3, double d4) {
        return new PearsonVII(d, d2, d3, d4);
    }

    private void calcCachedParameters() {
        this.mean = this.getParameterValue(0);
        this.FWHM = this.getParameterValue(1);
        this.mixing = this.getParameterValue(2);
        this.area = this.getParameterValue(3);
        this.alpha = Math.sqrt(Math.pow(2.0, 1.0 / this.mixing) - 1.0);
        this.staticComponent = 2.0 * Math.pow(Math.E, Gamma.logGamma((double)this.mixing)) * this.alpha / Math.pow(Math.E, Gamma.logGamma((double)(this.mixing - 0.5))) * Math.sqrt(Math.PI) / this.FWHM;
        this.markParametersClean();
    }

    @Override
    public double val(double ... dArray) {
        if (this.areParametersDirty()) {
            this.calcCachedParameters();
        }
        this.position = dArray[0];
        return this.area * this.staticComponent * Math.pow(1.0 + 4.0 * this.alpha * ((this.position - this.mean) * (this.position - this.mean)) / this.FWHM * this.FWHM, -this.mixing);
    }

    @Override
    public void disp() {
        String string = String.format("Pearson VII position has value %f within the bounds [%f,%f]", this.getParameterValue(0), this.getParameter(0).getLowerLimit(), this.getParameter(0).getUpperLimit());
        TerminalPrinter.print(string);
        string = String.format("Pearson VII standard deviation has value %f within the bounds [%f,%f]", this.getParameterValue(1), this.getParameter(1).getLowerLimit(), this.getParameter(1).getUpperLimit());
        TerminalPrinter.print(string);
        string = String.format("Pearson VII kurtosis has value %f within the bounds [%f,%f]", this.getParameterValue(2), this.getParameter(2).getLowerLimit(), this.getParameter(2).getUpperLimit());
        TerminalPrinter.print(string);
    }

    @Override
    public double getArea() {
        return this.getParameter(3).getValue();
    }

    @Override
    public double getFWHM() {
        return this.getParameter(1).getValue();
    }

    @Override
    public double getPosition() {
        return this.getParameter(0).getValue();
    }
}

