/*
 * Decompiled with CFR 0.152.
 */
package gda.analysis.functions;

import gda.analysis.functions.IFunction;
import gda.analysis.functions.Parameter;
import org.python.core.PyException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FunctionOutput {
    private static final Logger logger = LoggerFactory.getLogger(FunctionOutput.class);
    Parameter[] params = null;
    IFunction function = null;
    double chiSquared = 0.0;
    double areaUnderFit = 0.0;

    public double getAreaUnderFit() {
        return this.areaUnderFit;
    }

    public void setAreaUnderFit(double d) {
        this.areaUnderFit = d;
    }

    public double getChiSquared() {
        return this.chiSquared;
    }

    public void setChiSquared(double d) {
        this.chiSquared = d;
    }

    public IFunction getFunction() {
        return this.function;
    }

    public FunctionOutput(IFunction iFunction) {
        this.params = iFunction.getParameters();
        this.function = iFunction;
    }

    public Object __contains__(Integer n) {
        if (n < 0 || n >= this.params.length) {
            logger.error("The value {} is not within the Result objects bounds", (Object)n);
            return false;
        }
        return true;
    }

    public Object __getitem__(Integer n) {
        if (n < 0 || n >= this.params.length) {
            logger.error("The value {} is not within the Result objects bounds", (Object)n);
            throw new PyException();
        }
        return this.params[n];
    }

    public Object __delitem__(Integer n) {
        return null;
    }

    public void __setitem__(Integer n, Double d) {
    }

    public Object __len__() {
        return this.params.length;
    }

    public String disp() {
        String string = "";
        Parameter[] parameterArray = this.params;
        int n = this.params.length;
        int n2 = 0;
        while (n2 < n) {
            Parameter parameter = parameterArray[n2];
            string = String.valueOf(string) + parameter.getValue() + "(" + parameter.getLowerLimit() + "," + parameter.getUpperLimit() + ")\n";
            ++n2;
        }
        return string;
    }

    public double getParameterValue(int n) {
        return this.params[n].getValue();
    }
}

