/*
 * Decompiled with CFR 0.152.
 */
package gda.analysis.functions;

import gda.analysis.TerminalPrinter;
import gda.analysis.functions.AFunction;
import gda.analysis.functions.Parameter;

public class Cubic
extends AFunction {
    private static String cname = "Cubic";
    double a;
    double b;
    double c;
    double d;

    public Cubic() {
        super(4);
        this.name = cname;
    }

    public Cubic(Parameter[] parameterArray) {
        super(parameterArray);
        this.name = cname;
    }

    public Cubic(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        super(4);
        this.getParameter(0).setLowerLimit(d);
        this.getParameter(0).setUpperLimit(d2);
        this.getParameter(0).setValue((d + d2) / 2.0);
        this.getParameter(1).setLowerLimit(d3);
        this.getParameter(1).setUpperLimit(d4);
        this.getParameter(1).setValue((d3 + d4) / 2.0);
        this.getParameter(2).setLowerLimit(d5);
        this.getParameter(2).setUpperLimit(d6);
        this.getParameter(2).setValue((d5 + d6) / 2.0);
        this.getParameter(3).setLowerLimit(d7);
        this.getParameter(3).setUpperLimit(d8);
        this.getParameter(3).setValue((d7 + d8) / 2.0);
        this.name = cname;
    }

    private void calcCachedParameters() {
        this.a = this.getParameterValue(0);
        this.b = this.getParameterValue(1);
        this.c = this.getParameterValue(2);
        this.d = this.getParameterValue(3);
        this.markParametersClean();
    }

    @Override
    public double val(double ... dArray) {
        if (this.areParametersDirty()) {
            this.calcCachedParameters();
        }
        double d = dArray[0];
        return this.a * d * d * d + this.b * d * d + this.c * d + this.d;
    }

    @Override
    public void disp() {
        String string = String.format("A Has Value %f within the bounds [%f,%f]", this.getParameterValue(0), this.getParameter(0).getLowerLimit(), this.getParameter(0).getUpperLimit());
        TerminalPrinter.print(string);
        string = String.format("B Has Value %f within the bounds [%f,%f]", this.getParameterValue(1), this.getParameter(1).getLowerLimit(), this.getParameter(1).getUpperLimit());
        TerminalPrinter.print(string);
        string = String.format("C Has Value %f within the bounds [%f,%f]", this.getParameterValue(2), this.getParameter(2).getLowerLimit(), this.getParameter(2).getUpperLimit());
        TerminalPrinter.print(string);
        string = String.format("D Has Value %f within the bounds [%f,%f]", this.getParameterValue(3), this.getParameter(3).getLowerLimit(), this.getParameter(3).getUpperLimit());
        TerminalPrinter.print(string);
    }

    @Override
    public double partialDeriv(int n, double ... dArray) {
        double d = dArray[0];
        switch (n) {
            case 0: {
                return d * d * d;
            }
            case 1: {
                return d * d;
            }
            case 2: {
                return d;
            }
            case 3: {
                return 1.0;
            }
        }
        throw new IndexOutOfBoundsException("Parameter index is out of bounds");
    }
}

