/*
 * Decompiled with CFR 0.152.
 */
package gda.analysis.functions;

import gda.analysis.DataSet;
import gda.analysis.TerminalPrinter;
import gda.analysis.functions.AFunction;
import gda.analysis.functions.Parameter;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompositeFunction
extends AFunction {
    private List<Parameter> parameterList = new ArrayList<Parameter>();
    private List<AFunction> functionList = new ArrayList<AFunction>();
    private NavigableMap<Integer, AFunction> functionMap = new TreeMap<Integer, AFunction>();
    private static final Logger logger = LoggerFactory.getLogger(CompositeFunction.class);

    public CompositeFunction() {
        super(0);
    }

    public void addFunction(AFunction aFunction) {
        this.addFunction(this.parameterList, this.functionList, this.functionMap, aFunction);
    }

    private void addFunction(List<Parameter> list, List<AFunction> list2, NavigableMap<Integer, AFunction> navigableMap, AFunction aFunction) {
        int n = list.size();
        list2.add(aFunction);
        navigableMap.put(n, aFunction);
        Parameter[] parameterArray = aFunction.parameters;
        int n2 = aFunction.parameters.length;
        int n3 = 0;
        while (n3 < n2) {
            Parameter parameter = parameterArray[n3];
            list.add(parameter);
            ++n3;
        }
    }

    public void removeFunction(int n) {
        ArrayList<Parameter> arrayList = new ArrayList<Parameter>();
        ArrayList<AFunction> arrayList2 = new ArrayList<AFunction>();
        TreeMap<Integer, AFunction> treeMap = new TreeMap<Integer, AFunction>();
        int n2 = this.functionList.size();
        if (n > n2) {
            logger.error("Index exceed bounds");
            throw new IndexOutOfBoundsException("Index exceed bounds");
        }
        int n3 = 0;
        while (n3 < n2) {
            if (n3 != n) {
                AFunction aFunction = this.functionList.get(n3);
                this.addFunction(arrayList, arrayList2, treeMap, aFunction);
            }
            ++n3;
        }
        this.parameterList = arrayList;
        this.functionList = arrayList2;
        this.functionMap = treeMap;
    }

    @Override
    public int getNoOfFunctions() {
        return this.functionList.size();
    }

    @Override
    public AFunction getFunction(int n) {
        return this.functionList.get(n);
    }

    @Override
    public double val(double ... dArray) {
        double d = 0.0;
        for (AFunction aFunction : this.functionList) {
            d += aFunction.val(dArray);
        }
        return d;
    }

    public DataSet[] display(DataSet ... dataSetArray) {
        if (dataSetArray != null) {
            int cfr_ignored_0 = dataSetArray.length;
        }
        int n = this.getNoOfFunctions();
        DataSet[] dataSetArray2 = new DataSet[n + 1];
        dataSetArray2[0] = this.makeDataSet(dataSetArray);
        dataSetArray2[0].setName("Composite function");
        int n2 = 1;
        for (AFunction aFunction : this.functionList) {
            dataSetArray2[n2] = aFunction.makeDataSet(dataSetArray);
            dataSetArray2[n2++].setName(aFunction.getName());
        }
        return dataSetArray2;
    }

    public DataSet[] display(DataSet dataSet, DataSet dataSet2) {
        double d;
        int n = this.getNoOfFunctions();
        DataSet[] dataSetArray = new DataSet[n + 4];
        dataSetArray[0] = new DataSet(dataSet2);
        dataSetArray[1] = this.makeDataSet(dataSet);
        dataSetArray[1].setName("Composite function");
        int n2 = 0;
        while (n2 < dataSet.getSize()) {
            double d2 = this.val(dataSet.get(n2));
            dataSetArray[1].set(d2, n2++);
        }
        dataSetArray[2] = new DataSet(dataSet);
        dataSetArray[2].setName("Error Value");
        double d3 = dataSet2.min() - (dataSet2.max() - dataSet2.min()) / 5.0;
        int n3 = 0;
        while (n3 < dataSet.getSize()) {
            d = this.val(dataSet.get(n3)) - dataSet2.get(n3) + d3;
            dataSetArray[2].set(d, n3++);
        }
        dataSetArray[3] = new DataSet(dataSet);
        dataSetArray[3].setName("Error Offset");
        n3 = 0;
        while (n3 < dataSet.getSize()) {
            d = d3;
            dataSetArray[3].set(d, n3++);
        }
        n3 = 4;
        for (AFunction aFunction : this.functionList) {
            dataSetArray[n3] = aFunction.makeDataSet(dataSet);
            dataSetArray[n3++].setName(aFunction.getName());
        }
        return dataSetArray;
    }

    @Override
    public Parameter getParameter(int n) throws IndexOutOfBoundsException {
        try {
            return this.parameterList.get(n);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            logger.error("Index not in range");
            throw new IndexOutOfBoundsException("Index not in range");
        }
    }

    @Override
    public Parameter[] getParameters() {
        Parameter[] parameterArray = new Parameter[this.getNoOfParameters()];
        int n = 0;
        for (Parameter parameter : this.parameterList) {
            parameterArray[n++] = parameter;
        }
        return parameterArray;
    }

    @Override
    public int getNoOfParameters() {
        return this.parameterList.size();
    }

    @Override
    public double getParameterValue(int n) {
        return this.getParameter(n).getValue();
    }

    @Override
    public double[] getParameterValues() {
        double[] dArray = new double[this.getNoOfParameters()];
        int n = 0;
        for (Parameter parameter : this.parameterList) {
            dArray[n++] = parameter.getValue();
        }
        return dArray;
    }

    @Override
    public void setParameterValues(double ... dArray) {
        int n = Math.min(dArray.length, this.getNoOfParameters());
        int n2 = 0;
        while (n2 < n) {
            this.parameterList.get(n2).setValue(dArray[n2]);
            ++n2;
        }
        for (AFunction aFunction : this.functionList) {
            aFunction.dirty = true;
        }
        this.dirty = true;
    }

    @Override
    public void disp() {
        TerminalPrinter.print(this.toString());
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.functionList.size();
        if (n > 1) {
            int n2 = 0;
            while (n2 < n) {
                stringBuffer.append(String.format("Function %d - ", n2));
                stringBuffer.append(this.functionList.get(n2).toString());
                ++n2;
            }
        } else if (n == 1) {
            stringBuffer.append(this.functionList.get(0).toString());
        }
        return stringBuffer.toString();
    }

    @Override
    public double partialDeriv(int n, double ... dArray) throws IndexOutOfBoundsException {
        Integer n2 = this.functionMap.floorKey(n);
        if (n2 == null) {
            throw new IndexOutOfBoundsException("There are not enough parameters in the composite function");
        }
        return ((AFunction)this.functionMap.get(n2)).partialDeriv(n - n2, dArray);
    }
}

