/*
 * Decompiled with CFR 0.152.
 */
package gda.analysis.functions;

import gda.analysis.DataSet;
import gda.analysis.TerminalPrinter;
import gda.analysis.functions.IFunction;
import gda.analysis.functions.Parameter;
import java.io.Serializable;
import org.apache.commons.lang.NotImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.ac.diamond.scisoft.analysis.dataset.DatasetUtils;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IDataset;
import uk.ac.diamond.scisoft.analysis.dataset.IndexIterator;

public abstract class AFunction
implements IFunction,
Serializable {
    private static final transient Logger logger = LoggerFactory.getLogger(AFunction.class);
    protected Parameter[] parameters;
    protected String name = "default";
    protected boolean dirty = true;
    static double PERT = 1.0E-4;

    public AFunction(Parameter[] parameterArray) {
        this.parameters = new Parameter[parameterArray.length];
        int n = 0;
        while (n < parameterArray.length) {
            this.parameters[n] = new Parameter(parameterArray[n]);
            ++n;
        }
    }

    public AFunction(double[] dArray) {
        this.parameters = new Parameter[dArray.length];
        int n = 0;
        while (n < dArray.length) {
            this.parameters[n] = new Parameter(dArray[n]);
            ++n;
        }
    }

    public AFunction(int n) {
        this.parameters = new Parameter[n];
        int n2 = 0;
        while (n2 < n) {
            this.parameters[n2] = new Parameter();
            ++n2;
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String string) {
        this.name = string;
    }

    @Override
    public Parameter getParameter(int n) {
        return this.parameters[n];
    }

    @Override
    public Parameter[] getParameters() {
        Parameter[] parameterArray = new Parameter[this.parameters.length];
        int n = 0;
        while (n < this.parameters.length) {
            parameterArray[n] = new Parameter(this.parameters[n]);
            ++n;
        }
        return parameterArray;
    }

    @Override
    public int getNoOfParameters() {
        return this.parameters.length;
    }

    @Override
    public int getNoOfFunctions() {
        return 1;
    }

    @Override
    public IFunction getFunction(int n) {
        return this;
    }

    @Override
    public double getParameterValue(int n) {
        return this.parameters[n].getValue();
    }

    @Override
    public double[] getParameterValues() {
        double[] dArray = new double[this.parameters.length];
        int n = 0;
        while (n < this.parameters.length) {
            dArray[n] = this.getParameter(n).getValue();
            ++n;
        }
        return dArray;
    }

    @Override
    public void setParameterValues(double ... dArray) {
        int n = Math.min(dArray.length, this.parameters.length);
        int n2 = 0;
        while (n2 < n) {
            this.parameters[n2].setValue(dArray[n2]);
            ++n2;
        }
        this.dirty = true;
    }

    @Override
    public void disp() {
        TerminalPrinter.print(this.toString());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(String.format("'%s' has %d parameters:\n", this.name, this.parameters.length));
        int n = 0;
        while (n < this.getNoOfParameters()) {
            stringBuffer.append(String.format("%d) %f in range [%f, %f]\n", n, this.parameters[n].getValue(), this.parameters[n].getLowerLimit(), this.parameters[n].getUpperLimit()));
            ++n;
        }
        return stringBuffer.toString();
    }

    @Override
    public double partialDeriv(int n, double ... dArray) {
        double d = this.parameters[n].getValue();
        if (d != 0.0) {
            this.parameters[n].setValue(d * (1.0 - PERT));
            this.dirty = true;
            double d2 = this.val(dArray);
            this.parameters[n].setValue(d * (1.0 + PERT));
            this.dirty = true;
            double d3 = this.val(dArray);
            this.parameters[n].setValue(d);
            this.dirty = true;
            return (d3 - d2) / (2.0 * PERT * d);
        }
        this.parameters[n].setValue(-PERT);
        this.dirty = true;
        double d4 = this.val(dArray);
        this.parameters[n].setValue(PERT);
        this.dirty = true;
        double d5 = this.val(dArray);
        this.parameters[n].setValue(0.0);
        this.dirty = true;
        return (d5 - d4) / (2.0 * PERT);
    }

    public DataSet makeDataSet(DataSet dataSet) {
        DataSet[] dataSetArray = new DataSet[]{dataSet};
        return this.makeDataSet(dataSetArray);
    }

    @Override
    public DoubleDataset makeDataset(IDataset ... iDatasetArray) {
        DoubleDataset doubleDataset = this.makeSerialDataset(iDatasetArray);
        doubleDataset.setName(this.name);
        return doubleDataset;
    }

    @Override
    public DataSet makeDataSet(DataSet ... dataSetArray) {
        return DataSet.convertToDataset(this.makeSerialDataset(dataSetArray));
    }

    protected DoubleDataset makeSerialDataset(IDataset ... iDatasetArray) {
        if (iDatasetArray == null || iDatasetArray.length == 0) {
            logger.error("No values given to evaluate function");
            throw new IllegalArgumentException("No values given to evaluate function");
        }
        int n = AFunction.checkAndGetRank(iDatasetArray);
        if (n == 1) {
            return this.makeDatasetFromHypergrid(iDatasetArray);
        }
        return this.makeDatasetFromDatasets(iDatasetArray);
    }

    private static int checkAndGetRank(IDataset ... iDatasetArray) {
        int n = iDatasetArray.length;
        int n2 = iDatasetArray[0].getRank();
        int n3 = 1;
        while (n3 < n) {
            if (iDatasetArray[n3].getRank() != n2) {
                logger.error("Input value dataset ({}) does not all possess the correct rank {}", (Object)n3, (Object)n2);
                throw new IllegalArgumentException("Input value dataset (" + n3 + ") does not all possess the correct rank " + n2);
            }
            ++n3;
        }
        return n2;
    }

    protected DoubleDataset makeDatasetFromHypergrid(IDataset ... iDatasetArray) {
        int n = iDatasetArray.length - 1;
        int[] nArray = new int[n + 1];
        int n2 = 0;
        while (n2 <= n) {
            nArray[n2] = iDatasetArray[n2].getShape()[0];
            ++n2;
        }
        DoubleDataset doubleDataset = new DoubleDataset(nArray);
        double[] dArray = doubleDataset.getData();
        IndexIterator indexIterator = doubleDataset.getIterator(true);
        int[] nArray2 = indexIterator.getPos();
        double[] dArray2 = new double[n + 1];
        while (indexIterator.hasNext()) {
            if (nArray2[n] == 0) {
                int n3 = 0;
                while (n3 <= n) {
                    dArray2[n3] = iDatasetArray[n3].getDouble(nArray2[n3]);
                    ++n3;
                }
            } else {
                dArray2[n] = iDatasetArray[n].getDouble(nArray2[n]);
            }
            dArray[indexIterator.index] = this.val(dArray2);
        }
        return doubleDataset;
    }

    protected DoubleDataset makeDatasetFromDatasets(IDataset ... iDatasetArray) {
        int n = iDatasetArray.length;
        int[] nArray = iDatasetArray[0].getShape();
        DoubleDataset doubleDataset = new DoubleDataset(nArray);
        double[] dArray = doubleDataset.getData();
        IndexIterator indexIterator = doubleDataset.getIterator(true);
        int[] nArray2 = indexIterator.getPos();
        double[] dArray2 = new double[n];
        while (indexIterator.hasNext()) {
            int n2 = 0;
            while (n2 < n) {
                dArray2[n2] = iDatasetArray[n2].getDouble(nArray2);
                ++n2;
            }
            dArray[indexIterator.index] = this.val(dArray2);
        }
        return doubleDataset;
    }

    public boolean areParametersDirty() {
        return this.dirty;
    }

    public void markParametersClean() {
        this.dirty = false;
    }

    @Override
    public double residual(boolean bl, IDataset iDataset, IDataset ... iDatasetArray) {
        double d = 0.0;
        if (bl) {
            DoubleDataset doubleDataset = (DoubleDataset)DatasetUtils.convertToAbstractDataset(iDataset).cast(6);
            double[] dArray = doubleDataset.getData();
            IndexIterator indexIterator = doubleDataset.getIterator(true);
            int n = AFunction.checkAndGetRank(iDatasetArray);
            int[] nArray = indexIterator.getPos();
            if (n == 1) {
                int n2 = iDatasetArray.length - 1;
                double[] dArray2 = new double[n2 + 1];
                while (indexIterator.hasNext()) {
                    if (nArray[n2] == 0) {
                        int n3 = 0;
                        while (n3 <= n2) {
                            dArray2[n3] = iDatasetArray[n3].getDouble(nArray[n3]);
                            ++n3;
                        }
                    } else {
                        dArray2[n2] = iDatasetArray[n2].getDouble(nArray[n2]);
                    }
                    double d2 = dArray[indexIterator.index] - this.val(dArray2);
                    d += d2 * d2;
                }
            } else {
                int n4 = iDatasetArray.length;
                double[] dArray3 = new double[n4];
                while (indexIterator.hasNext()) {
                    int n5 = 0;
                    while (n5 < n4) {
                        dArray3[n5] = iDatasetArray[n5].getDouble(nArray);
                        ++n5;
                    }
                    double d3 = dArray[indexIterator.index] - this.val(dArray3);
                    d += d3 * d3;
                }
            }
        } else {
            logger.error("Stochastic sampling has not been implemented yet");
            throw new NotImplementedException("Stochastic sampling has not been implemented yet");
        }
        return d;
    }
}

