/*
 * Decompiled with CFR 0.152.
 */
package gda.analysis;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TerminalPrinter {
    private static final Logger logger = LoggerFactory.getLogger(TerminalPrinter.class);
    private static Method print;
    private static Object printer;

    private static void findPrinter() {
        try {
            Class<?> clazz = Class.forName("gda.jython.InterfaceProvider");
            Method method = clazz.getDeclaredMethod("getTerminalPrinter", null);
            printer = method.invoke(clazz, null);
            Class<?> clazz2 = printer.getClass();
            print = clazz2.getDeclaredMethod("print", String.class);
        }
        catch (Exception exception) {
            logger.info("Couldn't find a terminal printer; falling back to logger", (Throwable)exception);
            printer = logger;
            try {
                print = Logger.class.getDeclaredMethod("info", String.class);
            }
            catch (SecurityException securityException) {
                securityException.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
        }
    }

    public static void print(String string) {
        if (print == null) {
            TerminalPrinter.findPrinter();
        }
        if (print != null) {
            try {
                print.invoke(printer, string);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
        }
    }
}

