/*
 * Decompiled with CFR 0.152.
 */
package gda.analysis;

import gda.analysis.Generic1DFitter;
import gda.analysis.functions.APeak;
import gda.analysis.functions.CompositeFunction;
import gda.analysis.functions.FittedPeak;
import gda.analysis.functions.Gaussian;
import gda.analysis.functions.Lorentzian;
import gda.analysis.functions.PearsonVII;
import gda.analysis.functions.PseudoVoigt;
import gda.analysis.utils.GeneticAlg;
import java.util.Arrays;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import uk.ac.diamond.scisoft.analysis.dataset.AbstractDataset;
import uk.ac.diamond.scisoft.analysis.dataset.DoubleDataset;

public class Generic1DFitterTest {
    static final int dataRange = 550;
    static int[] defaultPeakPos = new int[]{100, 200, 300, 400, 500, 150, 250, 350, 450};
    static final int defaultFWHM = 100;
    static final int defaultArea = 50;
    static final double delta = 6.0;
    static final double lambda = 0.01;
    static final DoubleDataset xAxis = (DoubleDataset)AbstractDataset.arange(0.0, 550.0, 0.1, 6);

    @Test
    public void testPearsonVIIFitting() {
        int n = defaultPeakPos.length;
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = defaultPeakPos[n2];
            ++n2;
        }
        DoubleDataset doubleDataset = this.generatePearsonVII(n);
        try {
            this.FittingTest(nArray, doubleDataset, new PearsonVII(10.0));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println(illegalArgumentException);
            Assert.fail((String)"The number of generated peaks did not match the number of peaks found");
        }
    }

    @Test
    public void testGaussianFitting() {
        int n = defaultPeakPos.length;
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = defaultPeakPos[n2];
            ++n2;
        }
        DoubleDataset doubleDataset = this.generateGaussianPeaks(n);
        try {
            this.FittingTest(nArray, doubleDataset, new Gaussian(10.0));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println(illegalArgumentException);
            Assert.fail((String)"The number of generated peaks did not match the number of peaks found");
        }
    }

    @Test
    public void testPseudoVoigt() {
        int n = defaultPeakPos.length;
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = defaultPeakPos[n2];
            ++n2;
        }
        DoubleDataset doubleDataset = this.generatePseudoVoigt(n);
        try {
            this.FittingTest(nArray, doubleDataset, new PseudoVoigt(1.0, 1.0, 1.0, 1.0));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println(illegalArgumentException);
            Assert.fail((String)"The number of generated peaks did not match the number of peaks found");
        }
    }

    @Test
    public void testLorentzianFitting() {
        int n = defaultPeakPos.length;
        int[] nArray = new int[n];
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = defaultPeakPos[n2];
            ++n2;
        }
        DoubleDataset doubleDataset = this.generateLorentzianPeaks(n);
        try {
            this.FittingTest(nArray, doubleDataset, new Lorentzian(10.0));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.out.println(illegalArgumentException);
            Assert.fail((String)"The number of generated peaks did not match the number of peaks found");
        }
    }

    private DoubleDataset generatePseudoVoigt(int n) {
        CompositeFunction compositeFunction = new CompositeFunction();
        if (n > defaultPeakPos.length) {
            n = defaultPeakPos.length;
        }
        int n2 = 0;
        while (n2 < n) {
            compositeFunction.addFunction(new PseudoVoigt((double)(defaultPeakPos[n2] - 20), (double)(defaultPeakPos[n2] + 20), 100.0, 50.0));
            ++n2;
        }
        DoubleDataset doubleDataset = compositeFunction.makeDataset(xAxis);
        return doubleDataset;
    }

    private DoubleDataset generatePearsonVII(int n) {
        CompositeFunction compositeFunction = new CompositeFunction();
        if (n > defaultPeakPos.length) {
            n = defaultPeakPos.length;
        }
        int n2 = 0;
        while (n2 < n) {
            compositeFunction.addFunction(new PearsonVII((double)(defaultPeakPos[n2] - 20), (double)(defaultPeakPos[n2] + 20), 100.0, 50.0));
            ++n2;
        }
        DoubleDataset doubleDataset = compositeFunction.makeDataset(xAxis);
        return doubleDataset;
    }

    private DoubleDataset generateLorentzianPeaks(int n) {
        CompositeFunction compositeFunction = new CompositeFunction();
        if (n > defaultPeakPos.length) {
            n = defaultPeakPos.length;
        }
        int n2 = 0;
        while (n2 < n) {
            compositeFunction.addFunction(new Lorentzian((double)(defaultPeakPos[n2] - 20), (double)(defaultPeakPos[n2] + 20), 10.0, 10.0));
            ++n2;
        }
        DoubleDataset doubleDataset = compositeFunction.makeDataset(xAxis);
        return doubleDataset;
    }

    private DoubleDataset generateGaussianPeaks(int n) {
        CompositeFunction compositeFunction = new CompositeFunction();
        if (n > defaultPeakPos.length) {
            n = defaultPeakPos.length;
        }
        int n2 = 0;
        while (n2 < n) {
            compositeFunction.addFunction(new Gaussian((double)(defaultPeakPos[n2] - 20), (double)(defaultPeakPos[n2] + 20), 100.0, 50.0));
            ++n2;
        }
        DoubleDataset doubleDataset = compositeFunction.makeDataset(xAxis);
        return doubleDataset;
    }

    private void FittingTest(int[] nArray, DoubleDataset doubleDataset, APeak aPeak) {
        long l = -System.nanoTime();
        List<FittedPeak> list = Generic1DFitter.fitPeaks(xAxis, doubleDataset, aPeak, new GeneticAlg(0.01, 1237L), 5, nArray.length);
        System.out.printf("Fitting took %.3fms\n", (double)(l += System.nanoTime()) * 1.0E-6);
        double[] dArray = new double[list.size()];
        int n = 0;
        for (FittedPeak fittedPeak : list) {
            dArray[n++] = fittedPeak.getPeakFitted().getPosition();
        }
        Arrays.sort(dArray);
        Arrays.sort(nArray);
        Assert.assertEquals((long)dArray.length, (long)nArray.length);
        int n2 = 0;
        while (n2 < dArray.length) {
            Assert.assertEquals((double)nArray[n2], (double)dArray[n2], (double)6.0);
            ++n2;
        }
    }
}

