/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.statistics;

import com.isencia.passerelle.statistics.NamedStatistics;
import com.isencia.passerelle.statistics.StatisticsService;
import com.isencia.passerelle.statistics.StatisticsServiceDummyImpl;
import com.sun.jdmk.comm.HtmlAdaptorServer;
import java.util.HashSet;
import java.util.Set;
import javax.management.InstanceAlreadyExistsException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.NotCompliantMBeanException;
import javax.management.ObjectName;

class StatisticsServiceImpl
extends StatisticsServiceDummyImpl
implements StatisticsService {
    private MBeanServer svr;
    private HtmlAdaptorServer adapter;
    private ObjectName adapterName;
    private Set registeredNames = new HashSet();

    protected StatisticsServiceImpl() {
        try {
            this.svr = MBeanServerFactory.createMBeanServer(this.getServerName());
            this.start();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private String getServerName() {
        return "TestSvr";
    }

    private int getServerPort() {
        return 8000;
    }

    @Override
    public void registerStatistics(NamedStatistics namedStatistics) {
        try {
            ObjectName objectName = new ObjectName(String.valueOf(this.getServerName()) + ":name=" + namedStatistics.getName());
            this.registerMBean(namedStatistics, objectName);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void registerMBean(Object object, ObjectName objectName) throws MBeanRegistrationException, NotCompliantMBeanException {
        try {
            if (this.svr.isRegistered(objectName)) {
                try {
                    this.svr.unregisterMBean(objectName);
                }
                catch (InstanceNotFoundException instanceNotFoundException) {}
            }
            this.svr.registerMBean(object, objectName);
            this.registeredNames.add(objectName);
        }
        catch (InstanceAlreadyExistsException instanceAlreadyExistsException) {}
    }

    @Override
    public synchronized void start() {
        if (this.adapter == null || !this.adapter.isActive()) {
            try {
                this.adapterName = new ObjectName(String.valueOf(this.getServerName()) + ":name=htmladapter,port=" + this.getServerPort());
                this.adapter = new HtmlAdaptorServer();
                this.adapter.setPort(this.getServerPort());
                this.registerMBean(this.adapter, this.adapterName);
                this.adapter.start();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public synchronized void stop() {
        if (this.adapter != null) {
            try {
                this.adapter.stop();
                this.svr.unregisterMBean(this.adapterName);
                this.adapterName = null;
                this.adapter = null;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    @Override
    public void reset() {
        this.stop();
        for (ObjectName objectName : this.registeredNames) {
            try {
                this.svr.unregisterMBean(objectName);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }
}

