/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.statistics;

import com.isencia.passerelle.statistics.InsufficientDataException;

class StatisticalLongData {
    long count;
    long avgData;
    Long minData;
    Long maxData;

    StatisticalLongData() {
    }

    public void acceptData(long l) {
        ++this.count;
        if (this.minData == null || this.minData > l) {
            this.minData = new Long(l);
        }
        if (this.maxData == null || this.maxData < l) {
            this.maxData = new Long(l);
        }
        this.avgData += (l - this.avgData) / this.count;
    }

    public void reset() {
        this.count = 0L;
        this.avgData = 0L;
        this.minData = null;
        this.maxData = null;
    }

    public long getAvgData() throws InsufficientDataException {
        if (this.isWaitingForSufficientData()) {
            throw new InsufficientDataException();
        }
        return this.avgData;
    }

    public long getMaxData() throws InsufficientDataException {
        if (this.isWaitingForSufficientData()) {
            throw new InsufficientDataException();
        }
        return this.maxData;
    }

    public long getMinData() throws InsufficientDataException {
        if (this.isWaitingForSufficientData()) {
            throw new InsufficientDataException();
        }
        return this.minData;
    }

    public boolean isWaitingForSufficientData() {
        return this.count == 0L;
    }

    public long getCount() {
        return this.count;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[StatisticalLongData:");
        stringBuffer.append(" count: ");
        stringBuffer.append(this.count);
        stringBuffer.append(" avgData: ");
        stringBuffer.append(this.avgData);
        stringBuffer.append(" minData: ");
        stringBuffer.append(this.minData);
        stringBuffer.append(" maxData: ");
        stringBuffer.append(this.maxData);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

