/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.message.type;

import com.isencia.passerelle.core.PasserelleException;
import com.isencia.passerelle.core.PasserelleToken;
import com.isencia.passerelle.ext.TypeConverterProvider;
import com.isencia.passerelle.ext.impl.DefaultTypeConverterProvider;
import com.isencia.passerelle.message.MessageException;
import com.isencia.passerelle.message.type.ConverterBase;
import com.isencia.passerelle.message.type.TypeConverter;
import java.util.Iterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.data.Token;
import ptolemy.data.type.Type;

public class TypeConversionChain
implements TypeConverter {
    private static final Logger logger = LoggerFactory.getLogger(TypeConversionChain.class);
    private static final TypeConverterProvider DEFAULT_CONVERTER_PROVIDER = new DefaultTypeConverterProvider();
    private TypeConverterProvider converterProvider = DEFAULT_CONVERTER_PROVIDER;
    private static final TypeConversionChain instance = new TypeConversionChain();

    private TypeConversionChain() {
    }

    public static TypeConversionChain getInstance() {
        return instance;
    }

    public TypeConverterProvider getConverterProvider() {
        return this.converterProvider;
    }

    public void setConverterProvider(TypeConverterProvider typeConverterProvider) {
        this.converterProvider = typeConverterProvider != null ? typeConverterProvider : DEFAULT_CONVERTER_PROVIDER;
        logger.info("Set TypeConverterProvider to " + this.converterProvider.getName());
    }

    protected Token convertContentToToken(Object object, Type type) throws UnsupportedOperationException, MessageException {
        Token token = null;
        Iterator<TypeConverter> iterator = null;
        boolean bl = false;
        for (ConverterBase converterBase : this.converterProvider.getTypeConverters()) {
            try {
                token = converterBase.convertContentToToken(object, type);
                bl = true;
                break;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
        if (!bl) {
            throw new UnsupportedOperationException();
        }
        return token;
    }

    protected Object convertTokenToContent(Token token, Class clazz) throws UnsupportedOperationException, MessageException {
        Object object = null;
        Iterator<TypeConverter> iterator = null;
        boolean bl = false;
        for (ConverterBase converterBase : this.converterProvider.getTypeConverters()) {
            try {
                object = converterBase.convertTokenToContent(token, clazz);
                bl = true;
                break;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
        if (!bl) {
            throw new UnsupportedOperationException();
        }
        return object;
    }

    @Override
    public Token convertPasserelleTokenToPtolemyToken(PasserelleToken passerelleToken, Type type) throws UnsupportedOperationException, PasserelleException {
        Token token = null;
        Iterator<TypeConverter> iterator = null;
        boolean bl = false;
        for (TypeConverter typeConverter : this.converterProvider.getTypeConverters()) {
            try {
                token = typeConverter.convertPasserelleTokenToPtolemyToken(passerelleToken, type);
                bl = true;
                break;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
        if (!bl) {
            throw new UnsupportedOperationException();
        }
        return token;
    }

    @Override
    public PasserelleToken convertPtolemyTokenToPasserelleToken(Token token, Class clazz) throws UnsupportedOperationException, PasserelleException {
        PasserelleToken passerelleToken = null;
        Iterator<TypeConverter> iterator = null;
        boolean bl = false;
        for (TypeConverter typeConverter : this.converterProvider.getTypeConverters()) {
            try {
                passerelleToken = typeConverter.convertPtolemyTokenToPasserelleToken(token, clazz);
                bl = true;
                break;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
        if (!bl) {
            throw new UnsupportedOperationException();
        }
        return passerelleToken;
    }

    @Override
    public PasserelleToken convertPasserelleMessageContent(PasserelleToken passerelleToken, Class clazz) throws UnsupportedOperationException, PasserelleException {
        PasserelleToken passerelleToken2 = null;
        Iterator<TypeConverter> iterator = null;
        boolean bl = false;
        for (TypeConverter typeConverter : this.converterProvider.getTypeConverters()) {
            try {
                passerelleToken2 = typeConverter.convertPasserelleMessageContent(passerelleToken, clazz);
                bl = true;
                break;
            }
            catch (UnsupportedOperationException unsupportedOperationException) {}
        }
        if (!bl) {
            throw new UnsupportedOperationException();
        }
        return passerelleToken2;
    }
}

