/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.message.type;

import com.isencia.passerelle.message.MessageException;
import com.isencia.passerelle.message.type.ConverterBase;
import java.lang.reflect.Constructor;
import ptolemy.data.DoubleToken;
import ptolemy.data.Token;
import ptolemy.data.type.BaseType;
import ptolemy.data.type.Type;
import ptolemy.kernel.util.IllegalActionException;

public class DoubleConverter
extends ConverterBase {
    @Override
    protected boolean areTypesCompatible(Class clazz, Type type) {
        boolean bl = BaseType.DOUBLE.equals((Object)type);
        if (clazz != null) {
            bl = bl && (String.class.equals((Object)clazz) || Boolean.class.equals((Object)clazz) || Number.class.isAssignableFrom(clazz));
        }
        return bl;
    }

    @Override
    protected Token convertContentToToken(Object object, Type type) throws UnsupportedOperationException, MessageException {
        DoubleToken doubleToken = null;
        if (object == null) {
            doubleToken = new DoubleToken();
        } else if (Double.class.isInstance(object)) {
            doubleToken = new DoubleToken(((Double)object).doubleValue());
        } else {
            try {
                doubleToken = new DoubleToken(object.toString());
            }
            catch (IllegalActionException illegalActionException) {
                throw new UnsupportedOperationException();
            }
        }
        return doubleToken;
    }

    @Override
    protected boolean areTypesCompatible(Type type, Class clazz) {
        return BaseType.DOUBLE.equals((Object)type);
    }

    @Override
    protected Object convertTokenToContent(Token token, Class clazz) throws MessageException {
        if (clazz != null && !Double.class.equals((Object)clazz)) {
            try {
                Constructor constructor = clazz.getConstructor(String.class);
                return constructor.newInstance(Double.toString(((DoubleToken)token).doubleValue()));
            }
            catch (Exception exception) {
                throw new UnsupportedOperationException();
            }
        }
        try {
            return new Double(((DoubleToken)token).doubleValue());
        }
        catch (ClassCastException classCastException) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    protected boolean areTypesCompatible(Class clazz, Class clazz2) {
        return clazz2 == null || Double.class.isAssignableFrom(clazz2);
    }

    @Override
    protected Object convertContentToType(Object object, Class clazz) throws UnsupportedOperationException, MessageException {
        if (clazz != null && !Double.class.equals((Object)clazz)) {
            try {
                Constructor constructor = clazz.getConstructor(String.class);
                return constructor.newInstance(object.toString());
            }
            catch (Exception exception) {
                throw new UnsupportedOperationException();
            }
        }
        try {
            return new Double(Double.parseDouble(object.toString()));
        }
        catch (Exception exception) {
            throw new UnsupportedOperationException();
        }
    }
}

