/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.message.internal;

import com.isencia.passerelle.message.MessageException;
import com.isencia.passerelle.message.internal.ErrorMessageContainer;
import com.isencia.passerelle.message.internal.MessageContainer;
import com.isencia.util.MapOfLists;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ErrorMessageListContainer
extends MessageContainer {
    private static Logger logger = LoggerFactory.getLogger(ErrorMessageListContainer.class);
    private List errorMessages = new ArrayList();

    public ErrorMessageListContainer() {
        try {
            this.setBodyContent(this.errorMessages, "application/java");
        }
        catch (MessageException messageException) {
            logger.error("", (Throwable)messageException);
        }
    }

    public void addErrorMessage(ErrorMessageContainer errorMessageContainer) {
        if (errorMessageContainer != null) {
            this.errorMessages.add(errorMessageContainer);
        }
    }

    public boolean removeErrorMessage(ErrorMessageContainer errorMessageContainer) {
        if (errorMessageContainer != null) {
            return this.errorMessages.remove(errorMessageContainer);
        }
        return false;
    }

    public int size() {
        return this.errorMessages.size();
    }

    @Override
    public MessageContainer copy() throws MessageException {
        ErrorMessageListContainer errorMessageListContainer = new ErrorMessageListContainer();
        for (ErrorMessageContainer errorMessageContainer : this.errorMessages) {
            errorMessageListContainer.addErrorMessage((ErrorMessageContainer)errorMessageContainer.copy());
        }
        errorMessageListContainer.headers = ((MapOfLists)this.headers).copy();
        return errorMessageListContainer;
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[ErrorMessageListContainer:");
        stringBuffer.append(" errorMessages: ");
        stringBuffer.append(this.errorMessages);
        stringBuffer.append("]");
        return stringBuffer.toString();
    }
}

