/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.message;

import com.isencia.passerelle.actor.Actor;
import com.isencia.passerelle.core.Port;
import com.isencia.passerelle.message.ManagedMessage;

public class MessageAndPort {
    private Port port;
    private ManagedMessage message;

    private MessageAndPort(Port port, ManagedMessage managedMessage) {
        this.port = port;
        this.message = managedMessage;
    }

    public static MessageAndPort create(Actor actor, Port port, ManagedMessage managedMessage) throws IllegalArgumentException {
        if (actor == null || port == null || managedMessage == null) {
            throw new IllegalArgumentException("null parameter");
        }
        if (port.getContainer() != actor) {
            throw new IllegalArgumentException("port " + port.getFullName() + " not defined in actor " + actor.getFullName());
        }
        if (!port.isOutput()) {
            throw new IllegalArgumentException("port " + port.getFullName() + " not an output port");
        }
        return new MessageAndPort(port, managedMessage);
    }

    public ManagedMessage getMessage() {
        return this.message;
    }

    public Port getPort() {
        return this.port;
    }
}

