/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.ext.impl;

import com.isencia.passerelle.domain.cap.Director;
import com.isencia.passerelle.ext.ExecutionControlStrategy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.Actor;
import ptolemy.kernel.util.Attribute;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NameDuplicationException;
import ptolemy.kernel.util.NamedObj;

public class SuspendResumeExecutionControlStrategy
extends Attribute
implements ExecutionControlStrategy {
    private Logger logger = LoggerFactory.getLogger(SuspendResumeExecutionControlStrategy.class);
    private boolean suspended = false;

    public SuspendResumeExecutionControlStrategy(Director director, String string) throws IllegalActionException, NameDuplicationException {
        super((NamedObj)director, string);
        director.setExecutionControlStrategy(this);
        this.setPersistent(false);
    }

    public synchronized boolean isSuspended() {
        return this.suspended;
    }

    public synchronized void suspend() {
        this.suspended = true;
        this.notifyAll();
    }

    public synchronized void resume() {
        this.suspended = false;
        this.notifyAll();
    }

    @Override
    public synchronized ExecutionControlStrategy.IterationPermission requestNextIteration(Actor actor) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("requestNextIteration() - entry - actor " + ((NamedObj)actor).getName());
        }
        while (this.isSuspended()) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("requestNextIteration() - exit");
        }
        return null;
    }

    @Override
    public void iterationFinished(Actor actor, ExecutionControlStrategy.IterationPermission iterationPermission) {
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("iterationFinished() - entry - actor " + ((NamedObj)actor).getName());
        }
        if (this.logger.isTraceEnabled()) {
            this.logger.trace("iterationFinished() - exit");
        }
    }
}

