/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.domain.cap;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.IOPort;
import ptolemy.actor.QueueReceiver;
import ptolemy.actor.Receiver;
import ptolemy.actor.process.BoundaryDetector;
import ptolemy.actor.process.Branch;
import ptolemy.actor.process.ProcessReceiver;
import ptolemy.data.Token;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.Workspace;

public class BlockingQueueReceiver
extends QueueReceiver
implements ProcessReceiver {
    private static final Logger logger = LoggerFactory.getLogger(BlockingQueueReceiver.class);
    private BoundaryDetector _boundaryDetector = new BoundaryDetector((Receiver)this);
    private boolean _terminate = false;
    private int sizeWarningThreshold;

    public BlockingQueueReceiver() {
    }

    public BlockingQueueReceiver(IOPort iOPort) throws IllegalActionException {
        super(iOPort);
    }

    public boolean isConnectedToBoundary() {
        return this._boundaryDetector.isConnectedToBoundary();
    }

    public boolean isConnectedToBoundaryInside() {
        return this._boundaryDetector.isConnectedToBoundaryInside();
    }

    public boolean isConnectedToBoundaryOutside() {
        return this._boundaryDetector.isConnectedToBoundaryOutside();
    }

    public boolean isConsumerReceiver() {
        return this.isConnectedToBoundary();
    }

    public boolean isInsideBoundary() {
        return this._boundaryDetector.isInsideBoundary();
    }

    public boolean isOutsideBoundary() {
        return this._boundaryDetector.isOutsideBoundary();
    }

    public boolean isProducerReceiver() {
        return this.isOutsideBoundary() || this.isInsideBoundary();
    }

    public boolean isReadBlocked() {
        return false;
    }

    public boolean isWriteBlocked() {
        return false;
    }

    public Token get() {
        return this.get(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Token get(Branch branch) {
        Workspace workspace = this.getContainer().workspace();
        Token token = null;
        BlockingQueueReceiver blockingQueueReceiver = this;
        synchronized (blockingQueueReceiver) {
            while (true) {
                if (this._terminate || super.hasToken()) {
                    if (!super.hasToken()) return token;
                    return super.get();
                }
                try {
                    workspace.wait((Object)this);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public boolean hasRoom() {
        return true;
    }

    public boolean hasRoom(int n) {
        return true;
    }

    public boolean hasToken() {
        return true;
    }

    public boolean hasToken(int n) {
        return true;
    }

    public void put(Token token) {
        this.put(token, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Token token, Branch branch) {
        BlockingQueueReceiver blockingQueueReceiver = this;
        synchronized (blockingQueueReceiver) {
            if (!this._terminate) {
                super.put(token);
                if (this.getSizeWarningThreshold() != -1 && this.size() >= this.getSizeWarningThreshold()) {
                    logger.warn(String.valueOf(this.getContainer().getFullName()) + " - reached/passed warning threshold size " + this.getSizeWarningThreshold());
                }
                ((Object)((Object)this)).notifyAll();
            }
        }
    }

    public synchronized void requestFinish() {
        if (logger.isTraceEnabled()) {
            logger.trace("requestFinish() - entry - for " + this.toString() + " in " + this.getContainer().getFullName());
        }
        this._terminate = true;
        ((Object)((Object)this)).notifyAll();
        if (logger.isTraceEnabled()) {
            logger.trace("requestFinish() - exit");
        }
    }

    public void reset() {
        this._terminate = false;
        this._boundaryDetector.reset();
    }

    public void setSizeWarningThreshold(int n) {
        this.sizeWarningThreshold = n;
    }

    public int getSizeWarningThreshold() {
        return this.sizeWarningThreshold;
    }
}

