/*
 * Decompiled with CFR 0.152.
 */
package com.isencia.passerelle.core;

import com.isencia.passerelle.core.PortListener;
import com.isencia.passerelle.util.LoggerManager;
import com.isencia.util.BlockingReaderQueue;
import com.isencia.util.EmptyQueueException;
import com.isencia.util.FIFOQueue;
import com.isencia.util.IQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ptolemy.actor.IOPort;
import ptolemy.actor.NoTokenException;
import ptolemy.actor.process.TerminateProcessException;
import ptolemy.data.Token;
import ptolemy.kernel.util.IllegalActionException;
import ptolemy.kernel.util.NamedObj;

public class PortHandler {
    private static Logger logger = LoggerFactory.getLogger(PortHandler.class);
    private String actorInfo = "none";
    private BlockingReaderQueue queue = null;
    private IOPort ioPort = null;
    private Object channelLock = new Object();
    private PortListener listener = null;
    private ChannelHandler[] channelHandlers = null;
    private boolean started = false;
    private int channelCount = 0;

    public PortHandler(IOPort iOPort) {
        this(iOPort, null);
    }

    public PortHandler(IOPort iOPort, PortListener portListener) {
        this.ioPort = iOPort;
        this.listener = portListener;
        this.channelCount = this.getWidth();
        this.queue = new BlockingReaderQueue((IQueue)new FIFOQueue());
        NamedObj namedObj = iOPort.getContainer();
        if (namedObj != null) {
            this.actorInfo = namedObj.getFullName();
        }
    }

    public void setListener(PortListener portListener) {
        this.listener = portListener;
    }

    public boolean isStarted() {
        return this.started;
    }

    public IOPort getPort() {
        return this.ioPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Token getToken() {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getName()) + " getToken() - entry");
        }
        Token token = null;
        Object object = this.channelLock;
        synchronized (object) {
            if (this.channelCount == 0 && this.hasNoMoreTokens()) {
                return null;
            }
        }
        if (this.mustUseHandlers()) {
            try {
                token = (Token)this.queue.get();
            }
            catch (EmptyQueueException emptyQueueException) {}
        } else {
            try {
                if (this.ioPort.hasToken(0)) {
                    token = this.ioPort.get(0);
                }
            }
            catch (NoTokenException noTokenException) {
            }
            catch (IllegalActionException illegalActionException) {}
        }
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getName()) + " getToken() - exit - token : " + token);
        }
        return token;
    }

    public int getWidth() {
        return this.ioPort.getWidth();
    }

    public String getName() {
        return this.ioPort != null ? this.ioPort.getName() : "";
    }

    private boolean hasNoMoreTokens() {
        return this.queue.isEmpty();
    }

    public void start() {
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getName()) + " start() - entry");
        }
        if (this.started) {
            if (logger.isTraceEnabled()) {
                logger.trace(String.valueOf(this.getName()) + " start() - ALREADY STARTED - exit");
            }
            return;
        }
        this.channelCount = this.getWidth();
        if (this.mustUseHandlers()) {
            this.channelHandlers = new ChannelHandler[this.getWidth()];
            int n = 0;
            while (n < this.getWidth()) {
                this.channelHandlers[n] = new ChannelHandler(n);
                this.channelHandlers[n].start();
                ++n;
            }
        }
        this.started = true;
        if (logger.isTraceEnabled()) {
            logger.trace(String.valueOf(this.getName()) + " start() - STARTED - exit");
        }
    }

    private boolean mustUseHandlers() {
        return this.getWidth() > 1 || this.listener != null;
    }

    private class ChannelHandler
    extends Thread {
        private Token token = null;
        private boolean terminated = false;
        private int channelIndex = 0;

        public ChannelHandler(int n) {
            this.channelIndex = n;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            LoggerManager.pushMDC("actor", PortHandler.this.actorInfo);
            if (logger.isTraceEnabled()) {
                logger.trace(String.valueOf(PortHandler.this.getName()) + " ChannelHandler." + this.channelIndex + " run() - entry");
            }
            while (!this.terminated) {
                this.fetch();
            }
            Object object = PortHandler.this.channelLock;
            synchronized (object) {
                PortHandler portHandler = PortHandler.this;
                portHandler.channelCount = portHandler.channelCount - 1;
            }
            if (PortHandler.this.channelCount == 0) {
                PortHandler.this.queue.trigger();
                if (PortHandler.this.listener != null) {
                    PortHandler.this.listener.noMoreTokens();
                }
            }
            if (logger.isTraceEnabled()) {
                logger.trace(String.valueOf(PortHandler.this.getName()) + " ChannelHandler." + this.channelIndex + " run() - exit");
            }
            LoggerManager.popMDC("actor");
        }

        private void fetch() {
            if (logger.isTraceEnabled()) {
                logger.trace(String.valueOf(PortHandler.this.getName()) + " ChannelHandler." + this.channelIndex + " fetch() - entry");
            }
            try {
                if (PortHandler.this.ioPort.hasToken(this.channelIndex)) {
                    this.token = PortHandler.this.ioPort.get(this.channelIndex);
                    if (logger.isDebugEnabled()) {
                        logger.debug(String.valueOf(PortHandler.this.getName()) + " ChannelHandler." + this.channelIndex + " fetch() - got token : " + this.token);
                    }
                    if (this.token != null) {
                        PortHandler.this.queue.put((Object)this.token);
                    } else {
                        this.terminated = true;
                    }
                }
                if (PortHandler.this.listener != null) {
                    PortHandler.this.listener.tokenReceived();
                }
            }
            catch (TerminateProcessException terminateProcessException) {
                this.terminated = true;
            }
            catch (IllegalActionException illegalActionException) {
                this.terminated = true;
            }
            catch (NoTokenException noTokenException) {
                this.terminated = true;
            }
            if (logger.isTraceEnabled()) {
                logger.trace(String.valueOf(PortHandler.this.getName()) + " ChannelHandler." + this.channelIndex + " fetch() - exit");
            }
        }
    }
}

